/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui;

import fontanus.ui.BufferedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class BorderPanel
extends BufferedPanel {
    private static final int HEIGHT = 0;
    private static final int ASCENT = 1;
    private static final int WIDTH = 2;
    private static final int DEFAULT_PADDING = 0;
    private int _padding;
    private String _label;

    public BorderPanel() {
        this(null, 0);
    }

    public BorderPanel(String label) {
        this(label, 0);
    }

    public BorderPanel(String label, int padding) {
        this.setLabel(label);
        this.setPadding(padding);
    }

    public int getPadding() {
        return this._padding;
    }

    public synchronized void setPadding(int padding) {
        if (padding < 0) {
            throw new IllegalArgumentException("Padding must be >= 0");
        }
        this._padding = padding;
        this.invalidate();
    }

    public String getLabel() {
        return this._label;
    }

    public synchronized void setLabel(String label) {
        this._label = label;
        this.repaint();
    }

    public synchronized void paintBuffer(Graphics g) {
        super.paintBuffer(g);
        Dimension d = this.size();
        int[] labelSizes = this.calcLabelSizes();
        int y = labelSizes[0] / 2;
        Rectangle r = new Rectangle(0, y, d.width - 1, d.height - 1 - y);
        g.drawRect(r.x, r.y, r.width, r.height);
        if (this._label != null && !this._label.equals("")) {
            int ascent = labelSizes[1];
            int x = this._padding * 2;
            g.setColor(this.getBackground());
            g.drawLine(x - 1, y, x + labelSizes[2] + 1, y);
            g.setColor(this.getForeground());
            g.drawString(this._label, x, ascent);
        }
    }

    public Insets insets() {
        Insets i = super.insets();
        int pad = this._padding + 1;
        return new Insets(i.top + pad + this.calcLabelHeight(), i.left + pad, i.bottom + pad, i.right + pad);
    }

    private synchronized int calcLabelHeight() {
        if (this._label == null || this._label.equals("")) {
            return 0;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return fm.getMaxAscent() + fm.getMaxDescent();
    }

    private synchronized int[] calcLabelSizes() {
        int[] retval = new int[3];
        if (this._label == null || this._label.equals("")) {
            return retval;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int ascent = fm.getMaxAscent();
        retval[0] = ascent + fm.getMaxDescent();
        retval[1] = ascent;
        retval[2] = fm.stringWidth(this._label);
        return retval;
    }

    public static BorderPanel decorateComponent(Component c) {
        BorderPanel ret = new BorderPanel();
        ret.setLayout(new BorderLayout());
        ret.add("Center", c);
        return ret;
    }
}

