/*
 * Decompiled with CFR 0.152.
 */
package ladybug.util;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import ladybug.util.Console;

public class Formatter {
    public static String formatDate(Date d) {
        return Formatter.formatDate(d, true, true);
    }

    public static String formatDate(Console c, int width, Date d) {
        String s = Formatter.formatDate(d, true, true);
        if (c.stringLength(s) <= width) {
            return s;
        }
        s = Formatter.formatDate(d, false, true);
        if (c.stringLength(s) <= width) {
            return s;
        }
        s = Formatter.formatDate(d, true, false);
        if (c.stringLength(s) <= width) {
            return s;
        }
        return Formatter.formatDate(d, false, false);
    }

    public static String formatDate(Date d, boolean longForm, boolean giveYear) {
        if (longForm) {
            int format = 2;
        } else {
            int format = 3;
        }
        DateFormat df = DateFormat.getDateInstance();
        return df.format(d);
    }

    public static String formatTime(Date d) {
        return Formatter.formatTime(d, true, false, false);
    }

    public static String formatTime(Console c, int width, Date d) {
        String s = Formatter.formatTime(d, true, true, true);
        if (c.stringLength(s) <= width) {
            return s;
        }
        s = Formatter.formatTime(d, true, true, false);
        if (c.stringLength(s) <= width) {
            return s;
        }
        s = Formatter.formatTime(d, true, false, false);
        if (c.stringLength(s) <= width) {
            return s;
        }
        return Formatter.formatTime(d, false, false, false);
    }

    public static String formatTime(Date d, boolean longForm, boolean showSecs, boolean showAmPm) {
        if (longForm) {
            if (showSecs) {
                int format = 2;
            } else {
                boolean format = true;
            }
        } else if (showAmPm) {
            int format = 3;
        } else {
            int format = 2;
        }
        DateFormat df = DateFormat.getTimeInstance();
        Calendar c = Calendar.getInstance();
        TimeZone tz = c.getTimeZone();
        df.setTimeZone(tz);
        return df.format(d);
    }

    public static String formatElapsedTime(long millis) {
        return Formatter.formatElapsedTime(millis, true, true, true, true);
    }

    public static String formatElapsedTime(Console c, int width, long millis) {
        String et = Formatter.formatElapsedTime(millis, true, true, true, true);
        if (c.stringLength(et) <= width) {
            return et;
        }
        et = Formatter.formatElapsedTime(millis, false, true, true, true);
        if (c.stringLength(et) <= width) {
            return et;
        }
        et = Formatter.formatElapsedTime(millis, false, true, true, false);
        if (c.stringLength(et) <= width) {
            return et;
        }
        return Formatter.formatElapsedTime(millis, false, false, true, false);
    }

    public static String formatElapsedTime(long millis, boolean showHours, boolean showMinutes, boolean showSeconds, boolean showFraction) {
        String et = "";
        int deciseconds = (int)((millis + 50L) / 100L);
        int seconds = deciseconds / 10;
        int minutes = seconds / 60;
        int hours = minutes / 60;
        if (showHours) {
            if (!showMinutes) {
                if (!showFraction) {
                    hours = (minutes + 30) / 60;
                }
                et = String.valueOf(hours);
                if (showFraction) {
                    int frac = (deciseconds - hours * 60 * 60 * 10) / 3600;
                    et = String.valueOf(et) + "." + frac;
                }
                return et;
            }
            et = String.valueOf(hours) + ":";
        }
        if (showMinutes) {
            if (!showSeconds) {
                if (!showFraction) {
                    minutes = (seconds + 30) / 60;
                }
                et = showHours ? String.valueOf(et) + Formatter.twoDigits(minutes % 60) : String.valueOf(et) + minutes;
                if (showFraction) {
                    int frac = (deciseconds - minutes * 60 * 10) / 60;
                    et = String.valueOf(et) + "." + frac;
                }
                return et;
            }
            et = showHours ? String.valueOf(et) + Formatter.twoDigits(minutes % 60) + ":" : String.valueOf(et) + minutes + ":";
        }
        if (!showFraction) {
            seconds = (deciseconds + 5) / 10;
        }
        et = showMinutes ? String.valueOf(et) + Formatter.twoDigits(seconds % 60) : String.valueOf(et) + seconds;
        if (showFraction) {
            et = String.valueOf(et) + "." + deciseconds % 10;
        }
        return et;
    }

    public static String formatScalar(Number n) {
        if (n.doubleValue() > 9.223372036854776E18) {
            return Formatter.formatScalar(n.doubleValue());
        }
        return Formatter.formatScalar(n.longValue());
    }

    public static String formatScalar(long n) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        int numDigits = 1;
        double x = n;
        while (x >= 10.0) {
            ++numDigits;
            x /= 10.0;
        }
        if (numDigits <= 12) {
            nf.setGroupingUsed(true);
            return nf.format(n);
        }
        double normalized = n;
        String exp = "e" + String.valueOf(numDigits - 1);
        int i = 1;
        while (i < numDigits) {
            normalized /= 10.0;
            ++i;
        }
        nf.setMaximumFractionDigits(6);
        return String.valueOf(nf.format(normalized)) + exp;
    }

    public static String formatScalar(double n) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        int numDigits = 1;
        double x = n;
        while (x >= 10.0) {
            ++numDigits;
            x /= 10.0;
        }
        if (numDigits <= 12) {
            nf.setGroupingUsed(true);
            return nf.format(n);
        }
        double normalized = n;
        String exp = "e" + String.valueOf(numDigits - 1);
        int i = 1;
        while (i < numDigits) {
            normalized /= 10.0;
            ++i;
        }
        nf.setMaximumFractionDigits(6);
        return String.valueOf(nf.format(normalized)) + exp;
    }

    public static String formatScalar(Console c, int width, Number n) {
        return Formatter.formatScalar(c, width, n.longValue());
    }

    public static String formatScalar(Console c, int width, double n) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setGroupingUsed(true);
        String num = nf.format(n);
        if (c.stringLength(num) < width) {
            return num;
        }
        int numDigits = 1;
        double normalized = n;
        while (normalized >= 10.0) {
            ++numDigits;
            normalized /= 10.0;
        }
        String exp = "e" + String.valueOf(numDigits - 1);
        int digits = numDigits < 14 ? numDigits - 4 : 10;
        while (digits > 0) {
            nf.setMaximumFractionDigits(digits);
            num = String.valueOf(nf.format(normalized)) + exp;
            if (c.stringLength(num) < width) {
                return num;
            }
            --digits;
        }
        nf.setMaximumFractionDigits(0);
        return String.valueOf(nf.format(n)) + exp;
    }

    public static String formatScalar(Console c, int width, long n) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setGroupingUsed(true);
        String num = nf.format(n);
        if (c.stringLength(num) < width) {
            return num;
        }
        int numDigits = 1;
        double normalized = n;
        while (normalized >= 10.0) {
            ++numDigits;
            normalized /= 10.0;
        }
        String exp = "e" + String.valueOf(numDigits - 1);
        int digits = numDigits < 14 ? numDigits - 4 : 10;
        while (digits > 0) {
            nf.setMaximumFractionDigits(digits);
            num = String.valueOf(nf.format(normalized)) + exp;
            if (c.stringLength(num) < width) {
                return num;
            }
            --digits;
        }
        nf.setMaximumFractionDigits(0);
        return String.valueOf(nf.format(n)) + exp;
    }

    private static String twoDigits(int i) {
        return i < 10 ? "0" + i : Integer.toString(i);
    }
}

