/*
 * Decompiled with CFR 0.152.
 */
package ladybug.ui;

import fontanus.ui.window.FrameList;
import fontanus.ui.window.FrameListEvent;
import fontanus.ui.window.FrameListListener;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

class WindowMenuHandler
implements FrameListListener,
ActionListener {
    private FrameList _theFrameList;
    private Menu _windowMenu;

    public WindowMenuHandler(FrameList fl, Menu windowMenu) {
        this._theFrameList = fl;
        this._windowMenu = windowMenu;
        fl.addFrameListListener(this);
        Enumeration e = fl.getNames();
        while (e.hasMoreElements()) {
            this.add((String)e.nextElement());
        }
    }

    public void frameAdded(FrameListEvent evt) {
        this.add(evt.getName());
    }

    public void frameRemoved(FrameListEvent evt) {
        this.remove(evt.getName());
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        Frame f = this._theFrameList.getFrame(cmd);
        if (f != null) {
            f.show();
        }
    }

    private void add(String name) {
        MenuItem item = new MenuItem(name);
        item.addActionListener(this);
        this._windowMenu.add(item);
    }

    private void remove(String name) {
        int count = this._windowMenu.getItemCount();
        int i = 0;
        while (i < count) {
            if (this._windowMenu.getItem(i).getLabel().equals(name)) {
                this._windowMenu.remove(i);
                return;
            }
            ++i;
        }
    }
}

