/*
 * Decompiled with CFR 0.152.
 */
package ladybug.ui;

import fontanus.ui.IntegerField;
import fontanus.ui.layout.TableLayout;
import fontanus.ui.window.DialogConstants;
import fontanus.ui.window.StandardDialog;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import ladybug.engine.Scope;
import ladybug.parse.GivenType;

public class ScopeDialog
extends Panel
implements DialogConstants {
    private static final int[] colbases;
    private static final int[] colweights;
    private static final int[] rowbases;
    private static final int[] rowweights;
    private Panel left;
    private Panel right;
    private List _typeList = new List();
    private Label _numberLabel = new Label("Number of ...:");
    private IntegerField _numberField = new IntegerField(4);
    private Button _plusButton = new Button("+");
    private Button _minusButton = new Button("-");
    private Label _minMaxLabel = new Label("Min:    Max:   ");
    private List _nameList = new List(7);
    private TextField _nameField = new TextField();
    private Button _setButton = new Button("Set");
    private Scope _theScope = null;
    private GivenType _gt = null;
    private int _defaultItem = 0;

    protected ScopeDialog(Scope theScope) {
        this._theScope = theScope;
        int[] nArray = new int[3];
        nArray[1] = 12;
        int[] cb = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 5;
        nArray2[2] = 5;
        int[] cw = nArray2;
        int[] rb = new int[1];
        int[] rw = new int[]{1};
        TableLayout outsideLayout = new TableLayout(cb, cw, rb, rw);
        this.setLayout(outsideLayout);
        TableLayout layout = new TableLayout(colbases, colweights, rowbases, rowweights);
        this.right = new Panel(layout);
        layout.addComponent(this._numberLabel, this.right, 0, 0, 9, 1);
        layout.addComponent(this._numberField, this.right, 0, 1);
        layout.addComponent(this._plusButton, this.right, 2, 1);
        layout.addComponent(this._minusButton, this.right, 4, 1);
        layout.addComponent(this._minMaxLabel, this.right, 6, 1, 3, 1);
        layout.addComponent(new Label("Names"), this.right, 0, 3, 9, 1);
        layout.addComponent(this._nameList, this.right, 0, 4, 9, 1);
        layout.addComponent(this._nameField, this.right, 0, 6, 7, 1);
        layout.addComponent(this._setButton, this.right, 8, 6);
        outsideLayout.addComponent(this.right, this, 2, 0);
        this.left = new Panel(layout);
        layout.addComponent(new Label("Types"), this.left, 0, 0, 9, 1);
        layout.addComponent(this._typeList, this.left, 0, 1, 9, 6);
        outsideLayout.addComponent(this.left, this, 0, 0);
        this.setupEventBindings();
    }

    private void initColor() {
        this._typeList.setBackground(Color.white);
        ((Component)this._numberField).setBackground(Color.white);
        this._nameList.setBackground(Color.white);
        ((Component)this._nameField).setBackground(Color.white);
    }

    private void setupEventBindings() {
        this._typeList.addItemListener(new TypesHandler());
        ATypeHandler th = new ATypeHandler();
        this._numberField.addActionListener(th);
        this._plusButton.addActionListener(th);
        this._minusButton.addActionListener(th);
        this._nameList.addItemListener(th);
        this._nameField.addActionListener(th);
        this._setButton.addActionListener(th);
    }

    private void getScopeData(Scope theScope) {
        this._typeList.removeAll();
        Enumeration e = theScope.types();
        while (e.hasMoreElements()) {
            this._typeList.add(((GivenType)e.nextElement()).getName());
        }
        if (this._typeList.getItemCount() > 0) {
            this._typeList.select(this._defaultItem);
            this._typeList.dispatchEvent(new ItemEvent(this._typeList, 701, this._typeList.getSelectedItem(), 1));
        } else {
            this.disableAll();
        }
    }

    private void disableAll() {
        this._numberField.setEnabled(false);
        this._plusButton.setEnabled(false);
        this._minusButton.setEnabled(false);
        this._nameField.setEnabled(false);
        this._setButton.setEnabled(false);
    }

    public static void showScopeDialog(Component parent, Scope theScope) {
        ScopeDialog sd = new ScopeDialog(theScope);
        sd.getScopeData(theScope);
        StandardDialog d = new StandardDialog(parent, "Scope", sd, StandardDialog.localize(DialogConstants.OK_ARRAY), DialogConstants.OK_ARRAY);
        d.setResizable(true);
        StandardDialog.showStandardDialog(d);
    }

    private void updateNameList() {
        int max = this._theScope.maxBound(this._gt);
        int i = this._nameList.getSelectedIndex();
        this._nameList.removeAll();
        int j = 0;
        while (j < max) {
            this._nameList.add(this._gt.getElementName(j));
            ++j;
        }
        if (i >= max || i < this._gt.minScope()) {
            i = 0;
        }
        this._nameList.select(i);
        ((TextComponent)this._nameField).setText(this._nameList.getSelectedItem());
        this._minMaxLabel.setText("Min: " + this._gt.minScope() + "  Max: " + this._gt.maxScope());
        this._numberField.setRange(this._gt.minScope(), this._gt.maxScope());
    }

    static {
        int[] nArray = new int[9];
        nArray[1] = 3;
        nArray[3] = 3;
        nArray[5] = 6;
        nArray[7] = 3;
        colbases = nArray;
        int[] nArray2 = new int[9];
        nArray2[0] = 5;
        colweights = nArray2;
        int[] nArray3 = new int[7];
        nArray3[2] = 12;
        nArray3[5] = 3;
        rowbases = nArray3;
        int[] nArray4 = new int[7];
        nArray4[4] = 5;
        rowweights = nArray4;
    }

    private class TypesHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent evt) {
            ScopeDialog.this._gt = null;
            if (ScopeDialog.this._typeList.getSelectedItem() != null) {
                ScopeDialog.this._gt = ScopeDialog.this._theScope.getGivenType(ScopeDialog.this._typeList.getSelectedItem());
            }
            if (ScopeDialog.this._gt != null) {
                ScopeDialog.this._numberLabel.setText("Number of " + ScopeDialog.this._typeList.getSelectedItem() + "s");
                ((TextComponent)ScopeDialog.this._numberField).setText(Integer.toString(ScopeDialog.this._theScope.maxBound(ScopeDialog.this._gt)));
                ScopeDialog.this.updateNameList();
                ScopeDialog.this._numberField.requestFocus();
                ScopeDialog.this._numberField.selectAll();
            }
        }

        TypesHandler() {
        }
    }

    private class ATypeHandler
    implements ActionListener,
    ItemListener {
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ScopeDialog.this._nameField || evt.getSource() == ScopeDialog.this._setButton) {
                if (ScopeDialog.this._nameField.getText().equals("")) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (ScopeDialog.this._nameList.getSelectedIndex() == -1) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                ScopeDialog.this._gt.setElementName(ScopeDialog.this._nameList.getSelectedIndex(), ScopeDialog.this._nameField.getText());
                ScopeDialog.this.updateNameList();
                return;
            }
            try {
                int i = Integer.parseInt(ScopeDialog.this._numberField.getText());
                if (evt.getSource() == ScopeDialog.this._plusButton) {
                    ++i;
                } else if (evt.getSource() == ScopeDialog.this._minusButton) {
                    --i;
                }
                if (i > ScopeDialog.this._gt.maxScope() || i < ScopeDialog.this._gt.minScope()) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                ((TextComponent)ScopeDialog.this._numberField).setText(Integer.toString(i));
                ScopeDialog.this._theScope.setBound(ScopeDialog.this._gt, i);
                ScopeDialog.this.updateNameList();
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }

        public void itemStateChanged(ItemEvent evt) {
            if (ScopeDialog.this._nameList.getSelectedItem() != null) {
                ((TextComponent)ScopeDialog.this._nameField).setText(ScopeDialog.this._nameList.getSelectedItem());
                ScopeDialog.this._nameField.requestFocus();
                ScopeDialog.this._nameField.selectAll();
            }
        }

        ATypeHandler() {
        }
    }
}

