/*
 * Decompiled with CFR 0.152.
 */
package ladybug.ui;

import fontanus.ui.BorderPanel;
import fontanus.ui.InsetsPanel;
import fontanus.ui.ProgressBar;
import fontanus.ui.layout.TableLayout;
import fontanus.ui.window.FrameList;
import fontanus.ui.window.WindowCloser;
import fontanus.ui.window.WindowUtil;
import fontanus.util.Timer;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.InfoDescr;
import ladybug.engine.LadyBug;
import ladybug.engine.Progressor;
import ladybug.engine.SchemaSolver;
import ladybug.parse.Schema;
import ladybug.ui.DataTransferHandler;
import ladybug.ui.DisplayOptionsDialog;
import ladybug.ui.LimitsDialog;
import ladybug.ui.MainWindow;
import ladybug.ui.ScopeDialog;
import ladybug.ui.WindowMenuHandler;
import ladybug.util.Console;
import ladybug.util.ProgressorObserver;

public class SchemaWindow
extends Frame
implements Console {
    private TableLayout windowLayout;
    private static final int[] colbases;
    private static final int[] colweights;
    private static final int[] rowbases;
    private static final int[] rowweights;
    private static final int[] colbases2;
    private static final int[] colweights2;
    private static final int[] rowbases2;
    private static final int[] rowweights2;
    private static final int[] colbases3;
    private static final int[] colweights3;
    private static final int[] rowbases3;
    private static final int[] rowweights3;
    private static final int[] colbases3a;
    private static final int[] colweights3a;
    private static final int[] rowbases3a;
    private static final int[] rowweights3a;
    private static final int[] colbases3b;
    private static final int[] colweights3b;
    private static final int[] rowbases3b;
    private static final int[] rowweights3b;
    private static final int READY = 0;
    private static final int RUNNING = 1;
    private static final int PAUSED = 2;
    private static Timer _statusUpdater;
    private MenuBar mb = new MenuBar();
    private TextArea claim = new TextArea("", 5, 60);
    private MainWindow owner = null;
    private Menu displayMenu = null;
    private Menu debugMenu = null;
    private boolean useDetailedDisplay = false;
    private boolean debuggingEnabled = false;
    private ActionListener displayMenuHandler = null;
    private ItemListener debugMenuHandler = null;
    private static final String moreOptions = "More Options";
    private static final String fewerOptions = "Fewer Options";
    private static final String enableDebugging = "Enable Debugging";
    private static final String disableDebugging = "Disable Debugging";
    private TextField status = new TextField("Click on Check to begin ...");
    private ProgressBar progress = new ProgressBar(0, 1000);
    private InfoDescr[] statusFields;
    private Button check = new Button("Check");
    private Button halt = new Button("Halt");
    private Button cont = new Button("Continue");
    private Button scope = new Button("Set Scope");
    private Button limits = new Button("Set Limits");
    private Button options = new Button("Display Options");
    private Button expandOptionsButton = new Button("Options >>>");
    private Panel optionsPanel;
    private Choice solver;
    private Choice ordering;
    private Vector toggles;
    private SchemaSolver theSolver;

    public SchemaWindow(SchemaSolver aSolver, MainWindow mw) {
        this(SchemaWindow.getTitle(aSolver.getSchema()), aSolver, mw);
    }

    public SchemaWindow(String title, SchemaSolver aSolver, MainWindow mw) {
        super(title);
        this.theSolver = aSolver;
        this.theSolver.setConsole(this);
        this.owner = mw;
        this.initSchemaWindow();
    }

    public SchemaWindow(String schemaName, MainWindow mw) {
        super(SchemaWindow.getTitle(schemaName));
        this.theSolver = LadyBug.findSolver(schemaName, (Console)this);
        this.theSolver.setConsole(this);
        this.owner = mw;
        this.initSchemaWindow();
    }

    private void initSchemaWindow() {
        this.status.setEditable(false);
        this.statusFields = this.theSolver.statusInfo();
        this.initColor();
        this.initLayout();
        this.initMenuBar();
        this.syncState(this.theSolver);
        StatusHandler ch = new StatusHandler();
        this.theSolver.setProgressorObserver(ch);
        this.check.addActionListener(ch);
        this.halt.addActionListener(ch);
        this.cont.addActionListener(ch);
        this.scope.addActionListener(ch);
        this.limits.addActionListener(ch);
        this.options.addActionListener(ch);
        this.expandOptionsButton.addActionListener(ch);
        this.addWindowListener(new 1());
        this.pack();
        this.setMenuBar(this.mb);
        this.pack();
        this.updateStatusPanel(0);
        this.setState(0);
        _statusUpdater.start();
    }

    public SchemaSolver getSolver() {
        return this.theSolver;
    }

    public synchronized void dispose() {
        this.owner.schemaClosed(this);
        super.dispose();
    }

    private void initColor() {
        ((Component)this).setBackground(Color.lightGray);
        ((Component)this.claim).setBackground(Color.white);
    }

    private void initMenuBar() {
        Menu fileMenu = new Menu("File");
        this.mb.add(fileMenu);
        this.addMenuItem(fileMenu, new MenuItem("Check", new MenuShortcut(82)), new 2());
        this.addMenuItem(fileMenu, new MenuItem("Close"), WindowCloser.getInstance());
        fileMenu.addSeparator();
        this.addMenuItem(fileMenu, MainWindow.getExitMenuItem(), new 3());
        DataTransferHandler dth = new DataTransferHandler(this.claim);
        Menu editMenu = new Menu("Edit");
        this.mb.add(editMenu);
        this.addMenuItem(editMenu, new MenuItem("Copy", new MenuShortcut(67)), dth);
        Menu windowMenu = new Menu("Window");
        this.mb.add(windowMenu);
        new WindowMenuHandler(FrameList.getInstance(), windowMenu);
        this.displayMenuHandler = new 4();
        this.debugMenuHandler = new 5();
        this.displayMenu = new Menu("Display");
        this.mb.add(this.displayMenu);
        this.initDisplayMenu();
    }

    private void initDisplayMenu() {
        MenuItem item;
        String[] commands = this.theSolver.dumpCommands(this.useDetailedDisplay);
        int i = 0;
        while (i < commands.length) {
            item = new MenuItem(commands[i]);
            item.addActionListener(this.displayMenuHandler);
            this.displayMenu.add(item);
            ++i;
        }
        this.displayMenu.addSeparator();
        if (this.useDetailedDisplay) {
            item = new MenuItem(fewerOptions);
            item.addActionListener(this.displayMenuHandler);
            this.displayMenu.add(item);
        } else {
            item = new MenuItem(moreOptions);
            item.addActionListener(this.displayMenuHandler);
            this.displayMenu.add(item);
        }
        if (this.debuggingEnabled) {
            item = new MenuItem(disableDebugging);
            item.addActionListener(this.displayMenuHandler);
            this.displayMenu.add(item);
        } else {
            item = new MenuItem(enableDebugging);
            item.addActionListener(this.displayMenuHandler);
            this.displayMenu.add(item);
        }
    }

    private void initDebugMenu() {
        String[] commands = this.theSolver.debugOptions();
        int i = 0;
        while (i < commands.length) {
            CheckboxMenuItem item = new CheckboxMenuItem(commands[i]);
            item.addItemListener(this.debugMenuHandler);
            this.debugMenu.add(item);
            ++i;
        }
    }

    private void addMenuItem(Menu theMenu, MenuItem theItem, ActionListener listener) {
        theItem.addActionListener(listener);
        theMenu.add(theItem);
    }

    private void clearMenu(Menu theMenu) {
        int i = theMenu.getItemCount() - 1;
        while (i >= 0) {
            theMenu.remove(i);
            --i;
        }
    }

    private void initLayout() {
        this.windowLayout = new TableLayout(colbases, colweights, rowbases, rowweights);
        this.setLayout(this.windowLayout);
        TableLayout statusLayout = new TableLayout(colbases2, colweights2, rowbases2, rowweights2);
        this.windowLayout.addComponent(this.claim, this, 1, 1);
        this.windowLayout.addComponent(this.createStatusPanel(statusLayout), this, 1, 3);
        this.optionsPanel = this.createOptionsPanel();
        this.windowLayout.addComponent(this.optionsPanel, this, 1, 5);
        this.optionsPanel.setVisible(false);
    }

    private Panel createStatusPanel(TableLayout layout) {
        Label l;
        BorderPanel p = new BorderPanel("Status", 6);
        p.setLayout(layout);
        layout.addComponent(this.check, p, 0, 0);
        layout.addComponent(this.halt, p, 0, 2);
        layout.addComponent(this.cont, p, 0, 4);
        layout.addComponent(this.scope, p, 11, 0);
        layout.addComponent(this.limits, p, 11, 2);
        layout.addComponent(this.options, p, 11, 4);
        layout.addComponent(this.expandOptionsButton, p, 11, 6);
        layout.addComponent(this.status, p, 2, 0, 8, 1);
        new BorderPanel();
        layout.addComponent(BorderPanel.decorateComponent(this.progress), p, 2, 2, 8, 1);
        int row = 4;
        int col = 2;
        int i = 0;
        while (i < 4) {
            if (i >= this.statusFields.length) {
                return p;
            }
            layout.addComponent(new Label(String.valueOf(this.statusFields[i].getName()) + ":", 2), p, col, row);
            l = new Label(this.statusFields[i].getSampleValue(), 0);
            this.statusFields[i].setObject(l);
            layout.addComponent(l, p, col + 2, row);
            if ((col += 4) > 6) {
                col = 2;
                row += 2;
            }
            ++i;
        }
        if (i >= this.statusFields.length) {
            return p;
        }
        layout.addRow(6, 0);
        layout.addRow(0, 0);
        while (i < this.statusFields.length) {
            layout.addComponent(new Label(String.valueOf(this.statusFields[i].getName()) + ":", 2), p, col, row);
            l = new Label(this.statusFields[i].getSampleValue(), 0);
            this.statusFields[i].setObject(l);
            layout.addComponent(l, p, col + 2, row);
            if ((col += 4) > 6) {
                col = 2;
                row += 2;
                layout.addRow(6, 0);
                layout.addRow(0, 0);
            }
            ++i;
        }
        return p;
    }

    private Panel createOptionsPanel() {
        TableLayout layout = new TableLayout(colbases3, colweights3, rowbases3, rowweights3);
        BorderPanel p = new BorderPanel("Options", 6);
        p.setLayout(layout);
        Panel top = new Panel();
        TableLayout topLayout = new TableLayout(colbases3a, colweights3a, rowbases3a, rowweights3a);
        top.setLayout(topLayout);
        Panel bottom = new Panel();
        TableLayout bottomLayout = new TableLayout(colbases3b, colweights3b, rowbases3b, rowweights3b);
        bottom.setLayout(bottomLayout);
        this.solver = new Choice();
        String[] solvers = this.theSolver.solverClasses();
        if (solvers != null) {
            int i = 0;
            while (i < solvers.length) {
                this.solver.add(solvers[i]);
                ++i;
            }
        }
        this.solver.select(this.theSolver.currentSolverClass());
        this.ordering = new Choice();
        String[] orders = this.theSolver.getOrderClasses();
        if (orders != null) {
            int i = 0;
            while (i < orders.length) {
                this.ordering.add(orders[i]);
                ++i;
            }
        }
        this.ordering.select(this.theSolver.currentOrderClass());
        topLayout.addComponent(new Label("Solver", 2), top, 1, 0);
        topLayout.addComponent(this.solver, top, 3, 0);
        topLayout.addComponent(new Label("Var Ordering", 2), top, 5, 0);
        topLayout.addComponent(this.ordering, top, 7, 0);
        OptionsHandler sh = new OptionsHandler();
        this.solver.addItemListener(sh);
        this.ordering.addItemListener(sh);
        layout.addComponent(top, p, 0, 0);
        String[] toggleOptions = this.theSolver.getToggleOptions();
        this.toggles = new Vector();
        int i = 0;
        int col = 1;
        int row = 0;
        while (i < toggleOptions.length) {
            Checkbox cb = new Checkbox(toggleOptions[i], this.theSolver.getToggleOption(toggleOptions[i]));
            while (row > layout.getRowCount()) {
                layout.addRow(6, 0);
                layout.addRow(0, 0);
            }
            bottomLayout.addComponent(cb, bottom, col, row);
            cb.addItemListener(sh);
            if (col == 5) {
                row += 2;
                col = 1;
            } else {
                col += 2;
            }
            ++i;
        }
        layout.addComponent(bottom, p, 0, 2);
        InsetsPanel in = InsetsPanel.decorate(p);
        in.setInsets(6, 0, 6, 0);
        return in;
    }

    private void syncState(SchemaSolver s) {
        this.claim.setText(this.theSolver.getSchemaText());
        Enumeration e = this.toggles.elements();
        while (e.hasMoreElements()) {
            Checkbox cb = (Checkbox)e.nextElement();
            cb.setState(s.getToggleOption(cb.getLabel()));
        }
        this.solver.select(s.currentSolverClass());
        this.ordering.select(s.currentOrderClass());
    }

    public void setText(String text) {
        this.owner.setText(text);
    }

    public void appendText(String text) {
        this.owner.appendText(text);
    }

    public void appendTextLine(String text) {
        this.owner.appendTextLine(text);
    }

    public int stringLength(String text) {
        FontMetrics fm = this.status.getFontMetrics(this.status.getFont());
        return fm.stringWidth(text);
    }

    public String fillerString(String str, int len) {
        FontMetrics fm = this.status.getFontMetrics(this.status.getFont());
        String s = str;
        int l2 = fm.stringWidth(str);
        while (fm.stringWidth(s) < len + l2) {
            s = fm.stringWidth(s) < len / 2 ? String.valueOf(s) + s : String.valueOf(s) + str;
        }
        return s;
    }

    public void setStatus(String text) {
        ((TextComponent)this.status).setText(text);
    }

    public void checkSchema() {
        this.theSolver.startSolver();
    }

    public void haltCheck() {
        this.theSolver.haltSolver();
    }

    public void continueCheck() {
        this.theSolver.resumeSolver();
    }

    private void updateStatusPanel(int completed) {
        this.progress.setValue(completed);
        int i = 0;
        while (i < this.statusFields.length) {
            Label l = (Label)this.statusFields[i].getObject();
            l.setText(this.statusFields[i].getFormatted(this, l.getSize().width));
            ++i;
        }
    }

    private void setAllEnabled(boolean enabled) {
        Component[] comps = new Component[]{this.check, this.halt, this.cont, this.solver, this.ordering, this.scope};
        int i = 0;
        while (i < comps.length) {
            comps[i].setEnabled(enabled);
            ++i;
        }
        Enumeration e = this.toggles.elements();
        while (e.hasMoreElements()) {
            Checkbox cb = (Checkbox)e.nextElement();
            cb.setEnabled(enabled);
        }
    }

    private void setState(int state) {
        switch (state) {
            case 0: {
                this.setAllEnabled(true);
                this.halt.setEnabled(false);
                this.cont.setEnabled(false);
                break;
            }
            case 1: {
                this.setAllEnabled(false);
                this.halt.setEnabled(true);
                break;
            }
            case 2: {
                this.setAllEnabled(true);
                this.halt.setEnabled(false);
                break;
            }
        }
    }

    public static String getTitle(Schema aSchema) {
        return String.valueOf(aSchema.isClaim() ? "Claim: " : "Schema: ") + aSchema.getName() + " - Ladybug 1.0";
    }

    public static String getTitle(String schemaName) {
        return SchemaWindow.getTitle(LadyBug.findSchema(schemaName));
    }

    public static SchemaWindow getSchemaWindow(String schemaName, MainWindow mw) {
        SchemaWindow sw = new SchemaWindow(schemaName, mw);
        WindowUtil.cascade(sw);
        return sw;
    }

    static /* synthetic */ boolean access$2(SchemaWindow $0) {
        return $0.useDetailedDisplay;
    }

    static /* synthetic */ boolean access$9(SchemaWindow $0) {
        return $0.debuggingEnabled;
    }

    static /* synthetic */ int access$33() {
        return 1;
    }

    static /* synthetic */ int access$35() {
        return 2;
    }

    static /* synthetic */ int access$36() {
        return 0;
    }

    static {
        int[] nArray = new int[3];
        nArray[0] = 6;
        nArray[2] = 6;
        colbases = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        colweights = nArray2;
        int[] nArray3 = new int[6];
        nArray3[0] = 6;
        nArray3[2] = 12;
        nArray3[4] = 6;
        rowbases = nArray3;
        int[] nArray4 = new int[6];
        nArray4[1] = 1;
        rowweights = nArray4;
        int[] nArray5 = new int[12];
        nArray5[1] = 6;
        nArray5[3] = 6;
        nArray5[5] = 12;
        nArray5[7] = 6;
        nArray5[10] = 6;
        colbases2 = nArray5;
        int[] nArray6 = new int[12];
        nArray6[4] = 1;
        nArray6[5] = 1;
        nArray6[8] = 1;
        nArray6[9] = 2;
        colweights2 = nArray6;
        int[] nArray7 = new int[7];
        nArray7[1] = 6;
        nArray7[3] = 6;
        nArray7[5] = 6;
        rowbases2 = nArray7;
        rowweights2 = new int[7];
        colbases3 = new int[1];
        colweights3 = new int[]{1};
        int[] nArray8 = new int[3];
        nArray8[1] = 6;
        rowbases3 = nArray8;
        rowweights3 = new int[3];
        int[] nArray9 = new int[9];
        nArray9[2] = 6;
        nArray9[4] = 6;
        nArray9[6] = 6;
        colbases3a = nArray9;
        int[] nArray10 = new int[9];
        nArray10[0] = 1;
        nArray10[4] = 2;
        nArray10[8] = 1;
        colweights3a = nArray10;
        rowbases3a = new int[1];
        rowweights3a = new int[1];
        int[] nArray11 = new int[7];
        nArray11[2] = 6;
        nArray11[4] = 6;
        colbases3b = nArray11;
        int[] nArray12 = new int[7];
        nArray12[0] = 1;
        nArray12[2] = 2;
        nArray12[4] = 2;
        nArray12[6] = 1;
        colweights3b = nArray12;
        int[] nArray13 = new int[9];
        nArray13[1] = 6;
        nArray13[3] = 6;
        nArray13[5] = 6;
        nArray13[7] = 6;
        rowbases3b = nArray13;
        rowweights3b = new int[9];
        _statusUpdater = new Timer(100);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            ((Component)SchemaWindow.this).setVisible(false);
        }

        public void windowClosed(WindowEvent e) {
            FrameList fl = FrameList.getInstance();
            fl.removeFrame((Frame)e.getSource());
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchemaWindow.this.checkSchema();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            SchemaWindow.this.owner.close();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            if (evt.getActionCommand().equals(fewerOptions)) {
                SchemaWindow.this.useDetailedDisplay = false;
                SchemaWindow.this.clearMenu(SchemaWindow.this.displayMenu);
                SchemaWindow.this.initDisplayMenu();
            } else if (evt.getActionCommand().equals(moreOptions)) {
                SchemaWindow.this.useDetailedDisplay = true;
                SchemaWindow.this.clearMenu(SchemaWindow.this.displayMenu);
                SchemaWindow.this.initDisplayMenu();
            } else if (evt.getActionCommand().equals(enableDebugging)) {
                SchemaWindow.this.debuggingEnabled = true;
                if (SchemaWindow.this.debugMenu == null) {
                    SchemaWindow.this.debugMenu = new Menu("Debug");
                    SchemaWindow.this.mb.add(SchemaWindow.this.debugMenu);
                    SchemaWindow.this.pack();
                }
                SchemaWindow.this.initDebugMenu();
                SchemaWindow.this.clearMenu(SchemaWindow.this.displayMenu);
                SchemaWindow.this.initDisplayMenu();
            } else if (evt.getActionCommand().equals(disableDebugging)) {
                SchemaWindow.this.debuggingEnabled = false;
                SchemaWindow.this.mb.remove(SchemaWindow.this.debugMenu);
                SchemaWindow.this.debugMenu = null;
                SchemaWindow.this.clearMenu(SchemaWindow.this.displayMenu);
                SchemaWindow.this.initDisplayMenu();
            } else {
                SchemaWindow.this.theSolver.dumpValue(evt.getActionCommand());
            }
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ItemListener {
        public void itemStateChanged(ItemEvent evt) {
            CheckboxMenuItem debugItem = (CheckboxMenuItem)evt.getSource();
            SchemaWindow.this.theSolver.toggleDebug(debugItem.getLabel());
            debugItem.setState(SchemaWindow.this.theSolver.getDebug(debugItem.getLabel()));
        }

        /* synthetic */ 5() {
        }
    }

    class OptionsHandler
    implements ActionListener,
    ItemListener {
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            String cmd = evt.getActionCommand();
        }

        public void itemStateChanged(ItemEvent evt) {
            Object source = evt.getSource();
            if (source instanceof Checkbox) {
                Checkbox cb = (Checkbox)source;
                boolean state = cb.getState();
                SchemaWindow.this.theSolver.setToggleOption(cb.getLabel(), state);
            } else if (source == SchemaWindow.this.solver) {
                SchemaWindow.this.theSolver.setSolverClass(SchemaWindow.this.solver.getSelectedItem());
                SchemaWindow.this.windowLayout.removeLayoutComponent(SchemaWindow.this.optionsPanel);
                SchemaWindow.this.optionsPanel = SchemaWindow.this.createOptionsPanel();
                SchemaWindow.this.windowLayout.addComponent(SchemaWindow.this.optionsPanel, SchemaWindow.this, 1, 5);
                SchemaWindow.this.syncState(SchemaWindow.this.theSolver);
            } else if (source == SchemaWindow.this.ordering) {
                SchemaWindow.this.theSolver.setOrderClass(SchemaWindow.this.ordering.getSelectedItem());
                SchemaWindow.this.syncState(SchemaWindow.this.theSolver);
            }
            SchemaWindow.this.cont.setEnabled(false);
        }

        OptionsHandler() {
        }
    }

    class StatusHandler
    implements ActionListener,
    ProgressorObserver {
        private Progressor _theProgressor;

        public void actionPerformed(ActionEvent evt) {
            String cmd = evt.getActionCommand();
            Object source = evt.getSource();
            if (source == SchemaWindow.this.check) {
                SchemaWindow.this.checkSchema();
            } else if (source == SchemaWindow.this.halt) {
                SchemaWindow.this.haltCheck();
            } else if (source == SchemaWindow.this.cont) {
                SchemaWindow.this.continueCheck();
            } else if (source == SchemaWindow.this.scope) {
                ScopeDialog.showScopeDialog(SchemaWindow.this, SchemaWindow.this.theSolver.getScope());
                if (this._theProgressor != null) {
                    SchemaWindow.this.updateStatusPanel((int)(this._theProgressor.pctCompleted() * 1000.0));
                } else {
                    SchemaWindow.this.updateStatusPanel(0);
                }
            } else if (source == SchemaWindow.this.limits) {
                LimitsDialog.showLimitsDialog(SchemaWindow.this, SchemaWindow.this.theSolver);
            } else if (source == SchemaWindow.this.options) {
                DisplayOptionsDialog.showOptionsDialog(SchemaWindow.this, SchemaWindow.this.theSolver.getAssignmentDisplay());
            } else if (source == SchemaWindow.this.expandOptionsButton) {
                Dimension d = SchemaWindow.this.getSize();
                int height = ((SchemaWindow)SchemaWindow.this).optionsPanel.getPreferredSize().height;
                if (SchemaWindow.this.optionsPanel.isVisible()) {
                    SchemaWindow.this.expandOptionsButton.setLabel("Options >>>");
                    SchemaWindow.this.optionsPanel.setVisible(false);
                    ((Component)SchemaWindow.this).setSize(d.width, d.height - height);
                } else {
                    SchemaWindow.this.expandOptionsButton.setLabel("<<< Options");
                    SchemaWindow.this.optionsPanel.setVisible(true);
                    ((Component)SchemaWindow.this).setSize(d.width, d.height + height);
                }
                SchemaWindow.this.validate();
            } else if (source == _statusUpdater) {
                SchemaWindow.this.updateStatusPanel((int)(this._theProgressor.pctCompleted() * 1000.0));
            }
        }

        public void progressorStarted(Progressor p) {
            this._theProgressor = p;
            _statusUpdater.addActionListener(this);
            SchemaWindow.this.setState(SchemaWindow.access$33());
        }

        public void progressorPaused(Progressor p) {
            _statusUpdater.removeActionListener(this);
            SchemaWindow.this.updateStatusPanel((int)(this._theProgressor.pctCompleted() * 1000.0));
            SchemaWindow.this.setState(SchemaWindow.access$35());
        }

        public void progressorResumed(Progressor p) {
            _statusUpdater.addActionListener(this);
            SchemaWindow.this.setState(SchemaWindow.access$33());
        }

        public void progressorStopped(Progressor p) {
            _statusUpdater.removeActionListener(this);
            SchemaWindow.this.updateStatusPanel((int)(this._theProgressor.pctCompleted() * 1000.0));
        }

        public void progressorFinished() {
            SchemaWindow.this.setState(SchemaWindow.access$36());
        }

        StatusHandler() {
        }
    }
}

