/*
 * Decompiled with CFR 0.152.
 */
package ladybug.ui;

import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

class DataTransferHandler
implements ActionListener,
ClipboardOwner {
    public static final String CUT = "cut";
    public static final String COPY = "copy";
    public static final String PASTE = "paste";
    public static final String DELETE = "delete";
    private Clipboard _theClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private TextArea _text;

    public DataTransferHandler(TextArea text) {
        this.setTextArea(text);
    }

    public TextArea getTextArea() {
        return this._text;
    }

    public void setTextArea(TextArea text) {
        this._text = text;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this._text == null) {
            return;
        }
        String cmd = evt.getActionCommand();
        if (CUT.equalsIgnoreCase(cmd)) {
            this.copyToClipboard();
            this.deleteFromText();
        } else if (COPY.equalsIgnoreCase(cmd)) {
            this.copyToClipboard();
        } else if (PASTE.equalsIgnoreCase(cmd)) {
            this.pasteToText();
        } else if (DELETE.equalsIgnoreCase(cmd)) {
            this.deleteFromText();
        }
    }

    private void copyToClipboard() {
        String s = this._text.getText();
        String srcData = s.substring(this._text.getSelectionStart(), Math.min(this._text.getSelectionEnd(), s.length()));
        if (srcData != null) {
            StringSelection contents = new StringSelection(srcData);
            this._theClipboard.setContents(contents, this);
        }
    }

    private void deleteFromText() {
        this._text.replaceRange("", this._text.getSelectionStart(), this._text.getSelectionEnd());
    }

    private void pasteToText() {
        block3: {
            Transferable contents = this._theClipboard.getContents(this);
            if (contents == null) break block3;
            try {
                String dstData = (String)contents.getTransferData(DataFlavor.stringFlavor);
                this._text.insert(dstData, this._text.getCaretPosition());
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {}
        }
    }

    public void lostOwnership(Clipboard board, Transferable contents) {
    }
}

