/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FactSet;
import ladybug.engine.FormulaPattern;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.SimpleRule;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.Formula;
import ladybug.parse.Term;
import ladybug.parse.VarTerm;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.selenum.BoundedGenInfo;
import ladybug.selenum.BoundedGenRule;

public class SimpleBGenRule
extends SimpleRule
implements BoundedGenRule {
    private TermPattern _value;
    private VariableList _bounds;
    private int _varIndex;
    private boolean _required;
    private boolean _covers;
    private boolean _domain;

    public SimpleBGenRule(FormulaPattern enabler, TermPattern value, VariableList bounds, int varIndex, boolean required, boolean forDomain, boolean coversRules) {
        super(enabler, null);
        this._bounds = bounds;
        this._varIndex = varIndex;
        this._required = required;
        this._value = value;
        this._covers = coversRules;
        this._domain = forDomain;
    }

    public void setBounds(VariableList bounds) {
        this._bounds = bounds;
    }

    public ReplacementEnumeration enablers(Formula f, FactSet facts) {
        return new BGenEnablerWrapper(super.enablers(f, facts));
    }

    public void fire(Formula f, FactSet facts, Term[] replacements, Simplifier s) {
        BoundedGenInfo bgi;
        Variable v = ((VarTerm)replacements[this._varIndex]).getVariable();
        Term value = this._value.instantiate(replacements, s);
        Formula coveredFormula = f;
        if (!this._covers) {
            coveredFormula = null;
        }
        if (this._bounds.contains(v)) {
            bgi = (BoundedGenInfo)this._bounds.tag(v);
        } else {
            bgi = new BoundedGenInfo(v);
            this._bounds.addVar(v, bgi);
        }
        if (this._domain) {
            if (this._required) {
                bgi.addDRequired(value, coveredFormula);
            } else {
                bgi.addDForbidden(value, coveredFormula);
            }
        } else if (this._required) {
            bgi.addRRequired(value, coveredFormula);
        } else {
            bgi.addRForbidden(value, coveredFormula);
        }
    }

    public String toString() {
        String s = super.toString();
        if (this._covers) {
            s = String.valueOf(s) + "Covers ";
        }
        s = this._domain ? (this._required ? String.valueOf(s) + "DREQ " : String.valueOf(s) + "DFORB ") : (this._required ? String.valueOf(s) + "RREQ " : String.valueOf(s) + "RFORB ");
        s = String.valueOf(s) + this._value.toString();
        return s;
    }

    private class BGenEnablerWrapper
    implements ReplacementEnumeration {
        private boolean hasMore;
        private Term[] replacements;
        private ReplacementEnumeration _enablers;

        BGenEnablerWrapper(ReplacementEnumeration enablrs) {
            this._enablers = enablrs;
            this.checkMore();
        }

        public boolean hasMoreElements() {
            return this.hasMore;
        }

        public Object nextElement() throws NoSuchElementException {
            return this.nextReplacement();
        }

        public Term[] nextReplacement() throws NoSuchElementException {
            if (!this.hasMore) {
                throw new NoSuchElementException();
            }
            Term[] elem = this.replacements;
            this.checkMore();
            return elem;
        }

        private void checkMore() {
            while (this._enablers.hasMoreElements()) {
                this.replacements = this._enablers.nextReplacement();
                if (!(this.replacements[SimpleBGenRule.this._varIndex] instanceof VarTerm)) continue;
                this.hasMore = true;
                return;
            }
            this.hasMore = false;
        }
    }
}

