/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.Coloring;
import ladybug.selenum.Generator;
import ladybug.selenum.SetGenerator;

public class SetIsoGenerator
extends Generator
implements SetGenerator {
    private Coloring _baseColoring;
    private ScalarType _colorType;
    private SetValue _domain;
    private SetValue val;
    private SetValue scratch;
    private SetValue result;
    private FunctionValue map;
    private int[] _colors;
    private int[] colorSizes;
    private int[] firstElem;
    private int nextIndex;
    private int maxIndex;
    private int domSize;
    private int numElems;
    private int _minCard;
    private int _maxCard;
    private int numColors;
    private boolean computed;
    private boolean mapResult;

    public SetIsoGenerator(SetValue value, Variable var, Scope scope, Coloring baseColoring) {
        this(value, var, var.getType(), scope, baseColoring);
    }

    public SetIsoGenerator(SetValue value, Variable var, Type t, Scope scope, Coloring baseColoring) {
        super(var, t);
        this._colorType = ((SetType)t).elemType();
        this.nextIndex = 0;
        this.domSize = (int)this._colorType.numValues(scope);
        this._colors = new int[this.domSize];
        this.colorSizes = new int[this.domSize];
        this.firstElem = new int[this.domSize];
        this.result = value;
        this.mapResult = false;
        this.numElems = this.domSize;
        this.maxIndex = this.domSize;
        this.map = new FunctionValue(new RelationType(this._colorType, this._colorType, true, true, false, false, false), this.domSize, this.domSize);
        this.scratch = new SetValue(new SetType(this._colorType), scope);
        this.val = this.result;
        this._baseColoring = baseColoring;
        this._maxCard = -1;
        this._minCard = -1;
        this.terminate();
    }

    public void setValue(SetValue value) {
        this.result = value;
        if (!this.mapResult) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        this.numElems = dom.card();
        if (this.numElems == 0) {
            this.domSize = 0;
            this.mapResult = false;
            this._domain = null;
            this.val = this.result;
            this.reset();
            return;
        }
        this.domSize = dom.maxElem() + 1;
        if (this.domSize == this.numElems) {
            this.mapResult = false;
            this._domain = null;
            this.val = this.result;
        } else {
            this.mapResult = true;
            this._domain = dom;
            this.val = this.scratch;
            int i = 0;
            int j = 0;
            while (i < this.domSize) {
                if (dom.hasElement(i)) {
                    this.map.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        }
        this.reset();
    }

    public void setMinCard(int min) {
        this._minCard = min;
    }

    public void setMaxCard(int max) {
        this._maxCard = max;
    }

    public void reset() {
        int i;
        this.nextIndex = 0;
        if (this.domSize == 0) {
            this.maxIndex = 1;
            return;
        }
        if (this._baseColoring == null) {
            int i2 = 0;
            while (i2 < this.numElems) {
                this._colors[i2] = 0;
                ++i2;
            }
            this.maxIndex = this.numElems + 1;
            this.numColors = 1;
            this.colorSizes[0] = this.numElems;
            return;
        }
        int[] allColors = this._baseColoring.coloring(this._colorType);
        if (this.mapResult) {
            i = 0;
            int j = 0;
            while (i < this.domSize) {
                if (this._domain.hasElement(i)) {
                    this._colors[j++] = allColors[i];
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.domSize) {
                this._colors[i] = allColors[i];
                ++i;
            }
        }
        this.numColors = 1;
        this.colorSizes[0] = 1;
        this.firstElem[0] = 0;
        this.maxIndex = 1;
        i = 1;
        while (i < this.numElems) {
            if (this._colors[i - 1] != this._colors[i]) {
                this.maxIndex *= this.colorSizes[this.numColors - 1] + 1;
                this.colorSizes[this.numColors] = 1;
                this.firstElem[this.numColors] = i;
                ++this.numColors;
            } else {
                int n = this.numColors - 1;
                this.colorSizes[n] = this.colorSizes[n] + 1;
            }
            ++i;
        }
        this.maxIndex *= this.colorSizes[this.numColors - 1] + 1;
        this.computed = false;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        return this.computeNextSet();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextSet();
    }

    public SetValue nextSet() throws NoSuchElementException {
        if (!this.computeNextSet()) {
            throw new NoSuchElementException();
        }
        this.computed = false;
        if (this.mapResult) {
            this.map.image(this.val, this.result);
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    private boolean computeNextSet() {
        if (this.computed) {
            return true;
        }
        if (this.nextIndex == this.maxIndex) {
            return false;
        }
        int bits = this.nextIndex;
        this.val.init();
        int i = 0;
        while (bits != 0 && i < this.numColors) {
            int x = bits % (this.colorSizes[i] + 1);
            if (x != 0) {
                this.val.addBits((1 << x) - 1 << this.firstElem[i]);
            }
            bits /= this.colorSizes[i] + 1;
            ++i;
        }
        ++this.nextIndex;
        if (this._minCard > 0 && this.val.card() < this._minCard) {
            return this.computeNextSet();
        }
        if (this._maxCard >= 0 && this.val.card() > this._maxCard) {
            return this.computeNextSet();
        }
        this.computed = true;
        return true;
    }

    public double pctCompleted() {
        if (this.maxIndex == 0) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }
}

