/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.SetType;
import ladybug.parse.Variable;
import ladybug.selenum.Generator;
import ladybug.selenum.SetGenerator;

public class SetBndGenerator
extends Generator
implements SetGenerator {
    private SetValue val;
    private SetValue genValue;
    private boolean initialized;
    private boolean anyElements;
    private int domSize;
    private int _minCard;
    private int _maxCard;
    private long maxIndex;
    private SetValue domSet;
    private SetValue domEnum;
    private SetValue req;
    private SetValue forb;
    private SetValue forb2;
    private SetGenerator gen;

    public SetBndGenerator(SetValue value, Variable var, Scope scope, SetGenerator gen2, SetValue forbidden, SetValue required) {
        super(var, var.getType());
        SetType st = (SetType)var.getType();
        this.forb = forbidden;
        this.req = required;
        this.gen = gen2;
        this.initialized = false;
        this.domSize = (int)st.elemType().numValues(scope);
        this.val = value;
        if (this.req != null) {
            this.genValue = new SetValue(st, this.domSize);
            if (this.forb != null) {
                this.forb2 = new SetValue(st, this.domSize);
            }
        } else {
            this.genValue = value;
            this.forb2 = this.forb;
        }
        this.gen.setValue(this.genValue);
        this.setTypeGenerated(gen2.typeGenerated());
        this.maxIndex = this.gen.totalValues();
        this.domEnum = new SetValue(st, this.domSize);
        this.domSet = new SetValue(st, this.domSize);
        this._minCard = -1;
        this._maxCard = -1;
        this.domSet.fullSet();
        this.terminate();
    }

    public void setValue(SetValue value) {
        if (this.req == null) {
            this.gen.setValue(value);
            this.genValue = value;
        }
        this.val = value;
    }

    public void setDomain(SetValue dom) {
        this.domSet = dom;
        this.domSize = dom.maxElem() + 1;
    }

    public void setMinCard(int min) {
        this._minCard = min;
    }

    public void setMaxCard(int max) {
        this._maxCard = max;
    }

    public void reset() {
        this.initialized = false;
        this.gen.reset();
    }

    public void terminate() {
        this.gen.terminate();
    }

    public boolean hasMoreElements() {
        if (!this.initialized) {
            this.initializeBounds();
        }
        if (!this.anyElements) {
            return false;
        }
        return this.gen.hasMoreElements();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextSet();
    }

    public SetValue nextSet() throws NoSuchElementException {
        if (!this.initialized) {
            this.initializeBounds();
        }
        if (!this.anyElements) {
            throw new NoSuchElementException();
        }
        this.gen.nextSet();
        if (this.req != null) {
            this.genValue.union(this.req, this.val);
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.val);
        }
        return this.val;
    }

    public double pctCompleted() {
        return this.gen.pctCompleted();
    }

    public long totalValues() {
        return this.gen.totalValues();
    }

    public long totalGenValues() {
        return this.gen.totalGenValues();
    }

    public long valuesGend() {
        return this.gen.valuesGend();
    }

    private void initializeBounds() {
        this.initialized = true;
        if (this.req != null) {
            int rc = this.req.card();
            if (this._maxCard > 0) {
                if (rc > this._maxCard) {
                    this.anyElements = false;
                    return;
                }
                this.gen.setMaxCard(this._maxCard - rc);
            }
            if (this._minCard > 0) {
                this.gen.setMinCard(this._minCard - rc);
            }
        } else {
            if (this._maxCard > 0) {
                this.gen.setMaxCard(this._maxCard);
            }
            if (this._minCard > 0) {
                this.gen.setMinCard(this._maxCard);
            }
        }
        if (this.forb != null) {
            if (this.req != null) {
                this.forb.intersect(this.req, this.domEnum);
                if (this.domEnum.card() > 0) {
                    this.anyElements = false;
                    return;
                }
                this.forb.union(this.req, this.forb2);
            }
            this.domSet.diff(this.forb2, this.domEnum);
            this.gen.setDomain(this.domEnum);
        } else if (this.req != null) {
            this.domSet.diff(this.req, this.domEnum);
            this.gen.setDomain(this.domEnum);
        }
        this.anyElements = true;
        this.gen.reset();
    }
}

