/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.Hashtable;
import ladybug.engine.DebugOption;
import ladybug.engine.DumpOption;
import ladybug.engine.EnumVars;
import ladybug.engine.FormulaSolver;
import ladybug.engine.InfoDescr;
import ladybug.engine.LadyBug;
import ladybug.engine.LongScalarInfoDescr;
import ladybug.engine.OptionSet;
import ladybug.engine.Scope;
import ladybug.engine.Solver;
import ladybug.engine.SolverController;
import ladybug.engine.Translator;
import ladybug.engine.VarOrder;
import ladybug.selenum.Compiler;
import ladybug.selenum.ExecEnv;
import ladybug.selenum.Search;
import ladybug.selenum.SelEnumDebugs;
import ladybug.selenum.SelEnumDumps;

public class SelEnumSolver
extends SolverController {
    public static final String BoundedGenToggle = "Bounded Gen";
    public static final String ShortCircToggle = "Short Circuiting";
    public static final String IsoElimToggle = "Isomorph Elimination";
    public static final String BacktrackToggle = "Optimize Backtracks";
    public static final String oppBasedOrder = "Opportunity Based";
    private static final String[] toggleOptions = new String[]{"Derived Vars", "Normalize", "Conseq Closure", "Multiple Rule Closure", "Optimize Derived", "Bounded Gen", "Short Circuiting", "Optimize Backtracks", "Isomorph Elimination"};
    private static final String[] varOrderings = new String[]{"Size Ordering", "Opportunity Based"};
    long num_cases;
    long num_partial_cases;
    long num_values;
    boolean debugCases = false;
    boolean debugValues = false;
    boolean debugComps = false;
    boolean debugTests = false;
    boolean debugTimes = false;
    boolean debugOrder = false;
    boolean debugColors;
    boolean useBGen = true;
    boolean useSC = true;
    boolean optimSC = true;
    boolean useIsoElim = true;
    boolean constraintOrder = false;
    private ExecEnv env = null;
    private Hashtable peerTable;
    private DebugOption debugs;
    private DumpOption dumps;
    private Search search;
    static /* synthetic */ Class class$ladybug$parse$BinaryTerm;
    static /* synthetic */ Class class$ladybug$selenum$BinaryTermSEPeer;
    static /* synthetic */ Class class$ladybug$parse$EmptyTerm;
    static /* synthetic */ Class class$ladybug$selenum$EmptyTermSEPeer;
    static /* synthetic */ Class class$ladybug$parse$IdTerm;
    static /* synthetic */ Class class$ladybug$selenum$IdTermSEPeer;
    static /* synthetic */ Class class$ladybug$parse$RelDisplay;
    static /* synthetic */ Class class$ladybug$selenum$RelDisplaySEPeer;
    static /* synthetic */ Class class$ladybug$parse$SetDisplay;
    static /* synthetic */ Class class$ladybug$selenum$SetDisplaySEPeer;
    static /* synthetic */ Class class$ladybug$parse$UnaryTerm;
    static /* synthetic */ Class class$ladybug$selenum$UnaryTermSEPeer;
    static /* synthetic */ Class class$ladybug$parse$UnivTerm;
    static /* synthetic */ Class class$ladybug$selenum$UnivTermSEPeer;
    static /* synthetic */ Class class$ladybug$parse$VarTerm;
    static /* synthetic */ Class class$ladybug$selenum$VarTermSEPeer;
    static /* synthetic */ Class class$ladybug$parse$Predicate;
    static /* synthetic */ Class class$ladybug$selenum$PredicateSEPeer;
    static /* synthetic */ Class class$ladybug$parse$Comparison;
    static /* synthetic */ Class class$ladybug$selenum$ComparisonSEPeer;
    static /* synthetic */ Class class$ladybug$parse$ScalarConstTerm;
    static /* synthetic */ Class class$ladybug$selenum$ScalarConstSEPeer;
    static /* synthetic */ Class class$ladybug$parse$AssocTerm;
    static /* synthetic */ Class class$ladybug$selenum$AssocTermSEPeer;
    static /* synthetic */ Class class$ladybug$parse$CompoundFormula;
    static /* synthetic */ Class class$ladybug$selenum$CompoundFormulaSEPeer;
    static /* synthetic */ Class class$ladybug$parse$ConstantTerm;
    static /* synthetic */ Class class$ladybug$selenum$ConstantTermSEPeer;

    public SelEnumSolver(FormulaSolver fs) {
        this();
        this.setController(fs);
    }

    public SelEnumSolver() {
    }

    public void setController(FormulaSolver fs) {
        super.setController(fs);
        fs.getParent().setOrderClass(oppBasedOrder);
        this.reset();
    }

    protected Solver getSolver() {
        this.search = new Search(this);
        return this.search;
    }

    protected Translator getTranslator() {
        this.env = null;
        return new Compiler(this);
    }

    protected ExecEnv getEnv() {
        if (this.env == null) {
            this.env = new ExecEnv(this);
        }
        return this.env;
    }

    void reset() {
        this.num_cases = 0L;
        this.num_partial_cases = 0L;
        this.num_values = 0L;
        if (this.env != null) {
            this.env.reset();
        }
    }

    public synchronized void untranslate() {
        super.untranslate();
        this.env = null;
    }

    public InfoDescr[] statusInfo(InfoDescr[] baseDescrs) {
        int numBase = baseDescrs.length;
        InfoDescr[] descrs = new InfoDescr[numBase + 3];
        int i = 0;
        while (i < numBase) {
            descrs[i] = baseDescrs[i];
            ++i;
        }
        descrs[numBase] = new 1("Cases Checked", "99,999,999");
        descrs[numBase + 1] = new 2("Values Gen'd", "99,999,999");
        descrs[numBase + 2] = new 3("Part'l Assignments", "99,999,999");
        return descrs;
    }

    protected Hashtable getPeerTable() {
        if (this.peerTable != null) {
            return this.peerTable;
        }
        this.peerTable = new Hashtable();
        this.peerTable.put(class$ladybug$parse$BinaryTerm != null ? class$ladybug$parse$BinaryTerm : (class$ladybug$parse$BinaryTerm = SelEnumSolver.class$("ladybug.parse.BinaryTerm")), class$ladybug$selenum$BinaryTermSEPeer != null ? class$ladybug$selenum$BinaryTermSEPeer : (class$ladybug$selenum$BinaryTermSEPeer = SelEnumSolver.class$("ladybug.selenum.BinaryTermSEPeer")));
        this.peerTable.put(class$ladybug$parse$EmptyTerm != null ? class$ladybug$parse$EmptyTerm : (class$ladybug$parse$EmptyTerm = SelEnumSolver.class$("ladybug.parse.EmptyTerm")), class$ladybug$selenum$EmptyTermSEPeer != null ? class$ladybug$selenum$EmptyTermSEPeer : (class$ladybug$selenum$EmptyTermSEPeer = SelEnumSolver.class$("ladybug.selenum.EmptyTermSEPeer")));
        this.peerTable.put(class$ladybug$parse$IdTerm != null ? class$ladybug$parse$IdTerm : (class$ladybug$parse$IdTerm = SelEnumSolver.class$("ladybug.parse.IdTerm")), class$ladybug$selenum$IdTermSEPeer != null ? class$ladybug$selenum$IdTermSEPeer : (class$ladybug$selenum$IdTermSEPeer = SelEnumSolver.class$("ladybug.selenum.IdTermSEPeer")));
        this.peerTable.put(class$ladybug$parse$RelDisplay != null ? class$ladybug$parse$RelDisplay : (class$ladybug$parse$RelDisplay = SelEnumSolver.class$("ladybug.parse.RelDisplay")), class$ladybug$selenum$RelDisplaySEPeer != null ? class$ladybug$selenum$RelDisplaySEPeer : (class$ladybug$selenum$RelDisplaySEPeer = SelEnumSolver.class$("ladybug.selenum.RelDisplaySEPeer")));
        this.peerTable.put(class$ladybug$parse$SetDisplay != null ? class$ladybug$parse$SetDisplay : (class$ladybug$parse$SetDisplay = SelEnumSolver.class$("ladybug.parse.SetDisplay")), class$ladybug$selenum$SetDisplaySEPeer != null ? class$ladybug$selenum$SetDisplaySEPeer : (class$ladybug$selenum$SetDisplaySEPeer = SelEnumSolver.class$("ladybug.selenum.SetDisplaySEPeer")));
        this.peerTable.put(class$ladybug$parse$UnaryTerm != null ? class$ladybug$parse$UnaryTerm : (class$ladybug$parse$UnaryTerm = SelEnumSolver.class$("ladybug.parse.UnaryTerm")), class$ladybug$selenum$UnaryTermSEPeer != null ? class$ladybug$selenum$UnaryTermSEPeer : (class$ladybug$selenum$UnaryTermSEPeer = SelEnumSolver.class$("ladybug.selenum.UnaryTermSEPeer")));
        this.peerTable.put(class$ladybug$parse$UnivTerm != null ? class$ladybug$parse$UnivTerm : (class$ladybug$parse$UnivTerm = SelEnumSolver.class$("ladybug.parse.UnivTerm")), class$ladybug$selenum$UnivTermSEPeer != null ? class$ladybug$selenum$UnivTermSEPeer : (class$ladybug$selenum$UnivTermSEPeer = SelEnumSolver.class$("ladybug.selenum.UnivTermSEPeer")));
        this.peerTable.put(class$ladybug$parse$VarTerm != null ? class$ladybug$parse$VarTerm : (class$ladybug$parse$VarTerm = SelEnumSolver.class$("ladybug.parse.VarTerm")), class$ladybug$selenum$VarTermSEPeer != null ? class$ladybug$selenum$VarTermSEPeer : (class$ladybug$selenum$VarTermSEPeer = SelEnumSolver.class$("ladybug.selenum.VarTermSEPeer")));
        this.peerTable.put(class$ladybug$parse$Predicate != null ? class$ladybug$parse$Predicate : (class$ladybug$parse$Predicate = SelEnumSolver.class$("ladybug.parse.Predicate")), class$ladybug$selenum$PredicateSEPeer != null ? class$ladybug$selenum$PredicateSEPeer : (class$ladybug$selenum$PredicateSEPeer = SelEnumSolver.class$("ladybug.selenum.PredicateSEPeer")));
        this.peerTable.put(class$ladybug$parse$Comparison != null ? class$ladybug$parse$Comparison : (class$ladybug$parse$Comparison = SelEnumSolver.class$("ladybug.parse.Comparison")), class$ladybug$selenum$ComparisonSEPeer != null ? class$ladybug$selenum$ComparisonSEPeer : (class$ladybug$selenum$ComparisonSEPeer = SelEnumSolver.class$("ladybug.selenum.ComparisonSEPeer")));
        this.peerTable.put(class$ladybug$parse$ScalarConstTerm != null ? class$ladybug$parse$ScalarConstTerm : (class$ladybug$parse$ScalarConstTerm = SelEnumSolver.class$("ladybug.parse.ScalarConstTerm")), class$ladybug$selenum$ScalarConstSEPeer != null ? class$ladybug$selenum$ScalarConstSEPeer : (class$ladybug$selenum$ScalarConstSEPeer = SelEnumSolver.class$("ladybug.selenum.ScalarConstSEPeer")));
        this.peerTable.put(class$ladybug$parse$AssocTerm != null ? class$ladybug$parse$AssocTerm : (class$ladybug$parse$AssocTerm = SelEnumSolver.class$("ladybug.parse.AssocTerm")), class$ladybug$selenum$AssocTermSEPeer != null ? class$ladybug$selenum$AssocTermSEPeer : (class$ladybug$selenum$AssocTermSEPeer = SelEnumSolver.class$("ladybug.selenum.AssocTermSEPeer")));
        this.peerTable.put(class$ladybug$parse$CompoundFormula != null ? class$ladybug$parse$CompoundFormula : (class$ladybug$parse$CompoundFormula = SelEnumSolver.class$("ladybug.parse.CompoundFormula")), class$ladybug$selenum$CompoundFormulaSEPeer != null ? class$ladybug$selenum$CompoundFormulaSEPeer : (class$ladybug$selenum$CompoundFormulaSEPeer = SelEnumSolver.class$("ladybug.selenum.CompoundFormulaSEPeer")));
        this.peerTable.put(class$ladybug$parse$ConstantTerm != null ? class$ladybug$parse$ConstantTerm : (class$ladybug$parse$ConstantTerm = SelEnumSolver.class$("ladybug.parse.ConstantTerm")), class$ladybug$selenum$ConstantTermSEPeer != null ? class$ladybug$selenum$ConstantTermSEPeer : (class$ladybug$selenum$ConstantTermSEPeer = SelEnumSolver.class$("ladybug.selenum.ConstantTermSEPeer")));
        return this.peerTable;
    }

    public long casesChecked() {
        return this.num_cases;
    }

    public long valuesGend() {
        return this.num_values;
    }

    public long partialCasesChecked() {
        return this.num_partial_cases;
    }

    public void completionMessage() {
        LadyBug.message("Checked " + String.valueOf(this.num_cases) + " cases and " + String.valueOf(this.num_values) + " values");
        if (this.search != null) {
            LadyBug.message("Covered " + String.valueOf((int)(this.search.pctCompleted() * 100.0 + 0.5)) + "% of the total assignment space");
        }
    }

    public void completionMessage(FormulaSolver[] clauses) {
        long nc = 0L;
        long nv = 0L;
        int i = 0;
        while (i < clauses.length) {
            SelEnumSolver ses = (SelEnumSolver)clauses[i].getSolver();
            nc += ses.num_cases;
            nv += ses.num_values;
            ++i;
        }
        LadyBug.message("Checked " + String.valueOf(nc) + " cases and " + String.valueOf(nv) + " values");
    }

    public boolean stillValid(OptionSet changes) {
        return true;
    }

    public boolean translationValid(OptionSet changes) {
        if (!this.isTranslated()) {
            return false;
        }
        if (changes.contains(256)) {
            return false;
        }
        if (changes.contains(4096)) {
            return false;
        }
        if (changes.contains(512)) {
            return false;
        }
        return !changes.contains(1024);
    }

    public void setToggleOption(String option, boolean value) {
        if (option.equals(BoundedGenToggle)) {
            if (this.useBGen == value) {
                return;
            }
            this.useBGen = value;
            this.untranslate();
            return;
        }
        if (option.equals(ShortCircToggle)) {
            if (this.useSC == value) {
                return;
            }
            this.useSC = value;
            return;
        }
        if (option.equals(BacktrackToggle)) {
            if (this.optimSC == value) {
                return;
            }
            this.optimSC = value;
            return;
        }
        if (option.equals(IsoElimToggle)) {
            if (this.useIsoElim == value) {
                return;
            }
            this.useIsoElim = value;
            this.untranslate();
            return;
        }
    }

    public boolean getToggleOption(String option) {
        if (option.equals(BoundedGenToggle)) {
            return this.useBGen;
        }
        if (option.equals(ShortCircToggle)) {
            return this.useSC;
        }
        if (option.equals(BacktrackToggle)) {
            return this.optimSC;
        }
        if (option.equals(IsoElimToggle)) {
            return this.useIsoElim;
        }
        return false;
    }

    public String[] getToggleOptions() {
        return toggleOptions;
    }

    public DebugOption debugOptions() {
        if (this.debugs == null) {
            this.debugs = new SelEnumDebugs(this);
        }
        return this.debugs;
    }

    public DumpOption dumpOptions() {
        if (this.dumps == null) {
            this.dumps = new SelEnumDumps(this);
        }
        return this.dumps;
    }

    public OptionSet requiredOptions() {
        return new OptionSet();
    }

    public OptionSet disallowedOptions() {
        return new OptionSet();
    }

    public String dumpTranslation() {
        if (this.env == null) {
            return null;
        }
        return this.env.dumpTranslation();
    }

    public String dumpEnums() {
        if (this.env == null) {
            return null;
        }
        return this.env.dumpEnums();
    }

    public String dumpGenBounds() {
        if (!this.useBGen) {
            return null;
        }
        if (this.env == null) {
            return null;
        }
        return this.env.dumpGenBounds();
    }

    String dumpGens() {
        if (this.env == null) {
            return null;
        }
        return this.env.dumpGens();
    }

    String dumpTerms() {
        if (this.env == null) {
            return null;
        }
        return this.env.dumpTerms();
    }

    String dumpComps() {
        if (this.env == null) {
            return null;
        }
        return this.env.dumpComps();
    }

    String dumpTests() {
        if (this.env == null) {
            return null;
        }
        return this.env.dumpTests();
    }

    public VarOrder orderVars(String orderClass, EnumVars enums, Scope scope) {
        VarOrder ord = null;
        this.constraintOrder = orderClass.equals(oppBasedOrder);
        return ord;
    }

    public String[] getVarOrderings() {
        return varOrderings;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    extends LongScalarInfoDescr {
        protected long getValue() {
            return ((SelEnumSolver)SelEnumSolver.this.currentSolver()).casesChecked();
        }

        /* synthetic */ 1(String $0, String $1) {
            super($0, $1);
        }
    }

    private final class 2
    extends LongScalarInfoDescr {
        protected long getValue() {
            return ((SelEnumSolver)SelEnumSolver.this.currentSolver()).valuesGend();
        }

        /* synthetic */ 2(String $0, String $1) {
            super($0, $1);
        }
    }

    private final class 3
    extends LongScalarInfoDescr {
        protected long getValue() {
            return ((SelEnumSolver)SelEnumSolver.this.currentSolver()).partialCasesChecked();
        }

        /* synthetic */ 3(String $0, String $1) {
            super($0, $1);
        }
    }
}

