/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.engine.ValueError;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.Variable;
import ladybug.selenum.Coloring;
import ladybug.selenum.Generator;
import ladybug.selenum.ScalarGenerator;

public class ScalarIsoGenerator
extends Generator
implements ScalarGenerator {
    private Coloring _baseColoring;
    private ScalarType _colorType;
    private SetValue _domain;
    private ScalarValue val;
    private ScalarValue scratch;
    private ScalarValue result;
    private FunctionValue map;
    private int[] _colors;
    private int _pvalue;
    private int nextIndex;
    private int maxIndex;
    private int domSize;
    private int numElems;
    private boolean mapResult;

    public ScalarIsoGenerator(ScalarValue value, Variable var, Scope scope, Coloring baseColoring) {
        super(var, var.getType());
        this._colorType = (ScalarType)var.getType();
        this.nextIndex = 0;
        this.domSize = (int)this._colorType.numValues(scope);
        this._colors = new int[this.domSize];
        this.result = value;
        this.mapResult = false;
        this.numElems = this.domSize;
        this.maxIndex = this.domSize;
        this.map = new FunctionValue(new RelationType(this._colorType, this._colorType, true, true, false, false, false), this.domSize, this.domSize);
        this.scratch = new ScalarValue(this._colorType, scope);
        this.val = this.result;
        this._baseColoring = baseColoring;
        this.terminate();
    }

    public void setValue(ScalarValue value) {
        this.result = value;
        if (!this.mapResult) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        this.numElems = dom.card();
        if (this.numElems == 0) {
            this.domSize = 0;
            this.mapResult = false;
            this._domain = null;
            this.val = this.result;
            this.reset();
            return;
        }
        this.domSize = dom.maxElem() + 1;
        if (this.domSize == this.numElems) {
            this.mapResult = false;
            this._domain = null;
            this.val = this.result;
        } else {
            this.mapResult = true;
            this._domain = dom;
            this.val = this.scratch;
            int i = 0;
            int j = 0;
            while (i < this.domSize) {
                if (dom.hasElement(i)) {
                    this.map.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        }
        this.reset();
    }

    public void reset() {
        int i;
        this.nextIndex = 0;
        this._pvalue = -1;
        if (this.domSize == 0) {
            this.maxIndex = 0;
            return;
        }
        if (this._baseColoring == null) {
            this.maxIndex = 1;
            return;
        }
        int[] allColors = this._baseColoring.coloring(this._colorType);
        if (this.mapResult) {
            i = 0;
            int j = 0;
            while (i < this.domSize) {
                if (this._domain.hasElement(i)) {
                    this._colors[j++] = allColors[i];
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.domSize) {
                this._colors[i] = allColors[i];
                ++i;
            }
        }
        this.maxIndex = 1;
        i = 1;
        while (i < this.numElems) {
            if (this._colors[i - 1] != this._colors[i]) {
                ++this.maxIndex;
            }
            ++i;
        }
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        return this.nextIndex < this.maxIndex;
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextScalar();
    }

    public ScalarValue nextScalar() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        if (this.nextIndex == 0) {
            this.val.setAdjValue(0);
            this._pvalue = 0;
        } else {
            int i = this._pvalue + 1;
            while (i < this.domSize) {
                if (this._colors[i - 1] != this._colors[i]) {
                    this._pvalue = i;
                    this.val.setAdjValue(i);
                    break;
                }
                ++i;
            }
        }
        ++this.nextIndex;
        if (this.mapResult) {
            try {
                this.map.apply(this.val, this.result);
            }
            catch (ValueError valueError) {
                throw new NoSuchElementException();
            }
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    public double pctCompleted() {
        if (this.maxIndex == 0) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }
}

