/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.RelationValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Variable;
import ladybug.selenum.Coloring;
import ladybug.selenum.Generator;
import ladybug.selenum.RelationGenerator;
import ladybug.selenum.SetGenerator;
import ladybug.selenum.SetIsoGenerator;

public class RelIsoGenerator
extends Generator
implements RelationGenerator {
    private Coloring rangeColoring;
    private Coloring domainColoring;
    private ScalarType _dcolorType;
    private ScalarType _rcolorType;
    private SetValue _range;
    private RelationValue val;
    private RelationValue scratch;
    private RelationValue result;
    private FunctionValue rangeMap;
    private SetValue genDomain;
    private SetGenerator domGen;
    private SetGenerator[] ranGens;
    private SetValue[] genRanges;
    private Coloring[] ranColors;
    private int[] _dcolors;
    private int[][] _rcolors;
    private int[] _numColors;
    private int[] _edgesGenerated;
    private int[] domElems;
    private long nextIndex;
    private long maxIndex;
    private int domSize;
    private int ranSize;
    private int numElems;
    private int numDomElems;
    private boolean mapResult;
    private boolean computed;

    public RelIsoGenerator(RelationValue value, Variable var, Scope scope, Coloring baseColoring) {
        super(var, var.getType());
        RelationType rt = (RelationType)var.getType();
        this._dcolorType = rt.domain();
        this._rcolorType = rt.range();
        this.nextIndex = 0L;
        this.domSize = (int)this._dcolorType.numValues(scope);
        this.ranSize = (int)this._rcolorType.numValues(scope);
        this._rcolors = new int[this.domSize][this.ranSize];
        this._numColors = new int[this.domSize];
        this._edgesGenerated = new int[this.domSize];
        this._dcolors = new int[this.domSize];
        this.domElems = new int[this.domSize];
        this.genDomain = new SetValue(new SetType(this._dcolorType), this.domSize);
        this.domGen = new SetIsoGenerator(this.genDomain, null, this.genDomain.getType(), scope, baseColoring);
        this.ranColors = new Coloring[this.ranSize + 1];
        this.ranGens = new SetGenerator[this.ranSize];
        this.genRanges = new SetValue[this.ranSize];
        this.domainColoring = baseColoring.extend(var);
        this.domGen.setColoring(this.domainColoring);
        SetType ranType = new SetType(this._rcolorType);
        this.ranColors[0] = this.domainColoring;
        int i = 0;
        while (i < this.ranSize) {
            this.genRanges[i] = new SetValue(ranType, scope);
            this.ranGens[i] = new SetIsoGenerator(this.genRanges[i], null, ranType, scope, this.ranColors[i]);
            this.ranGens[i].setMinCard(1);
            this.ranColors[i + 1] = this.ranColors[i].extend(var);
            this.ranGens[i].setColoring(this.ranColors[i + 1]);
            ++i;
        }
        this.result = value;
        this.mapResult = false;
        this.numElems = this.domSize;
        this.maxIndex = this.domSize;
        this.rangeMap = new FunctionValue(new RelationType(this._rcolorType, this._rcolorType, true, true, false, false, false), this.domSize, this.domSize);
        this.scratch = new RelationValue(new RelationType(this._dcolorType, this._rcolorType, false, false, false, false, false), this.domSize, this.ranSize);
        this.val = this.result;
        rt = new RelationType(this._dcolorType, this._rcolorType);
        this.setTypeGenerated(rt);
        this.terminate();
    }

    public void setValue(RelationValue value) {
        this.result = value;
        if (!this.mapResult) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        this.domGen.setDomain(dom);
        this.reset();
    }

    public void setRange(SetValue ran) {
        int i = 0;
        while (i < this.ranSize) {
            this.ranGens[i].setDomain(ran);
            ++i;
        }
        this.reset();
    }

    public void reset() {
        this.domainColoring.reset();
        int[] allColors = this.domainColoring.coloring(this._dcolorType);
        int i = 0;
        while (i < this.domSize) {
            this._dcolors[i] = allColors[i];
            ++i;
        }
        this.nextIndex = 0L;
        this.domGen.reset();
        if (this.ranSize == 0) {
            this.maxIndex = 0L;
            return;
        }
        this.ranGens[0].reset();
        this.computed = false;
        this.maxIndex = 1 << this.ranSize * this.domSize;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        if (this.computed) {
            return true;
        }
        if (this.nextIndex >= this.maxIndex) {
            return false;
        }
        return this.computeNextRelation();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextRelation();
    }

    public RelationValue nextRelation() throws NoSuchElementException {
        if (!this.computed) {
            if (this.nextIndex == this.maxIndex) {
                throw new NoSuchElementException();
            }
            if (!this.computeNextRelation()) {
                throw new NoSuchElementException();
            }
        }
        this.computed = false;
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    public boolean computeNextRelation() {
        if (this.computed) {
            return true;
        }
        if (this.nextIndex == 0L) {
            return this.chooseNewDomain();
        }
        if (this.chooseNewEdgeSet()) {
            ++this.nextIndex;
            this.computed = true;
            return true;
        }
        return this.chooseNewDomain();
    }

    public boolean chooseNewDomain() {
        if (!this.domGen.hasMoreElements()) {
            this.computed = false;
            return false;
        }
        this.genDomain = this.domGen.nextSet();
        this.numDomElems = 0;
        int i = 0;
        while (i < this.domSize) {
            if (this.genDomain.hasElement(i)) {
                this.domElems[this.numDomElems] = i;
                ++this.numDomElems;
            }
            ++i;
        }
        this.val.init();
        this.ranColors[0].updateColoring(this.genDomain);
        i = 0;
        while (i < this.numDomElems) {
            this.ranColors[i].distinguish(this.domElems[i], this._dcolorType);
            if (i > 0 && this._dcolors[this.domElems[i - 1]] == this._dcolors[this.domElems[i]]) {
                this.ranGens[i].setMaxCard(this.genRanges[i - 1].card());
            }
            this.ranGens[i].reset();
            if (!this.ranGens[i].hasMoreElements()) {
                this.computed = false;
                return false;
            }
            this.ranGens[i].nextSet();
            this.val.setMapping(this.domElems[i], this.genRanges[i].bits());
            this.ranColors[i + 1].updateColoring(this.val);
            ++i;
        }
        ++this.nextIndex;
        this.computed = true;
        return true;
    }

    public boolean chooseNewEdgeSet() {
        if (this.numDomElems == 0) {
            return false;
        }
        int d = this.numDomElems - 1;
        while (d < this.numDomElems) {
            this.val.setMapping(this.domElems[d], 0);
            if (!this.ranGens[d].hasMoreElements()) {
                if (d <= 0) {
                    return false;
                }
                this.ranGens[d].reset();
                --d;
                continue;
            }
            this.ranGens[d].nextSet();
            this.val.setMapping(this.domElems[d], this.genRanges[d].bits());
            if (++d >= this.numDomElems) break;
            this.ranColors[d].updateColoring(this.val);
            this.ranColors[d].distinguish(this.domElems[d], this._dcolorType);
            if (this._dcolors[this.domElems[d - 1]] == this._dcolors[this.domElems[d]]) {
                this.ranGens[d].setMaxCard(this.genRanges[d - 1].card());
            }
            this.ranGens[d].reset();
        }
        return true;
    }

    public double pctCompleted() {
        if (this.maxIndex == 0L) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0L) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }
}

