/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.RelationValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.Variable;
import ladybug.selenum.Generator;
import ladybug.selenum.RelationGenerator;

public class RelExhGenerator
extends Generator
implements RelationGenerator {
    private RelationValue valScratch;
    private RelationValue domScratch;
    private RelationValue ranScratch;
    private RelationValue val;
    private RelationValue domResult;
    private RelationValue ranSource;
    private RelationValue result;
    private long nextIndex = 0L;
    private long maxIndex;
    private long mask;
    private int domSize;
    private int ranSize;
    private FunctionValue domMap;
    private FunctionValue ranMap;
    private boolean mapDomain;
    private boolean mapRange;

    public RelExhGenerator(RelationValue value, Variable var, Scope scope) {
        super(var, var.getType());
        this.result = value;
        RelationType rt = (RelationType)var.getType();
        this.domSize = (int)rt.domain().numValues(scope);
        this.ranSize = (int)rt.range().numValues(scope);
        this.mapDomain = false;
        this.mapRange = false;
        this.domMap = new FunctionValue(new RelationType(rt.domain(), rt.domain(), true, true, false, false, false), this.domSize, this.domSize);
        this.ranMap = new FunctionValue(new RelationType(rt.range(), rt.range(), true, true, false, false, false), this.ranSize, this.ranSize);
        this.val = this.result;
        this.domScratch = new RelationValue(rt, this.domSize, this.ranSize);
        this.ranScratch = new RelationValue(rt, this.domSize, this.ranSize);
        this.valScratch = new RelationValue(rt, this.domSize, this.ranSize);
        this.computeMax();
        this.setTypeGenerated(new RelationType(rt.domain(), rt.range()));
        this.terminate();
    }

    public void reset() {
        this.nextIndex = 0L;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        return this.nextIndex < this.maxIndex;
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextRelation();
    }

    public RelationValue nextRelation() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        long bits = this.nextIndex;
        int i = 0;
        while (i < this.domSize) {
            this.val.setMapping(i, (int)(bits & this.mask));
            bits >>= this.ranSize;
            ++i;
        }
        ++this.nextIndex;
        if (this.mapDomain) {
            this.domMap.compose(this.val, this.domResult);
        }
        if (this.mapRange) {
            this.ranSource.compose(this.ranMap, this.result);
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    public void setValue(RelationValue value) {
        this.result = value;
        if (!this.mapRange) {
            if (this.mapDomain) {
                this.domResult = this.result;
            } else {
                this.val = value;
            }
        }
    }

    public void setDomain(SetValue dom) {
        this.domSize = dom.card();
        int maxe = dom.maxElem() + 1;
        if (this.domSize < maxe) {
            this.mapDomain = true;
            this.val = this.valScratch;
            if (this.mapRange) {
                this.domResult = this.domScratch;
                this.ranSource = this.domScratch;
            } else {
                this.domResult = this.result;
            }
            this.domMap.init();
            int i = 0;
            int j = 0;
            while (i < maxe) {
                if (dom.hasElement(i)) {
                    this.domMap.addMapping(i, j);
                    ++j;
                }
                ++i;
            }
        } else if (this.mapDomain) {
            this.mapDomain = false;
            if (this.mapRange) {
                this.ranSource = this.val;
            } else {
                this.val = this.result;
            }
        }
        this.computeMax();
    }

    public void setRange(SetValue ran) {
        this.ranSize = ran.card();
        int maxe = ran.maxElem() + 1;
        if (this.ranSize < maxe) {
            this.mapRange = true;
            this.val = this.valScratch;
            if (this.mapDomain) {
                this.ranSource = this.domScratch;
                this.domResult = this.domScratch;
            } else {
                this.ranSource = this.val;
            }
            this.ranMap.init();
            int i = 0;
            int j = 0;
            while (i < maxe) {
                if (ran.hasElement(i)) {
                    this.ranMap.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        } else if (this.mapRange) {
            this.mapRange = false;
            if (this.mapDomain) {
                this.domResult = this.result;
            } else {
                this.val = this.result;
            }
        }
        this.computeMax();
    }

    public double pctCompleted() {
        if (this.maxIndex == 0L) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0L) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }

    private void computeMax() {
        long valSize = Generator.pow(2L, this.ranSize);
        this.maxIndex = Generator.pow(valSize, this.domSize);
        this.mask = valSize - 1L;
    }
}

