/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.FunctionValue;
import ladybug.engine.LadyBug;
import ladybug.engine.RelationValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.engine.ValueError;
import ladybug.parse.GivenType;
import ladybug.parse.ParseError;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.TypeList;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.selenum.AtomicColoring;
import ladybug.selenum.ChainExhGenerator;
import ladybug.selenum.ChainIsoGenerator;
import ladybug.selenum.ColorMapper;
import ladybug.selenum.Coloring;
import ladybug.selenum.FuncBijExhGenerator;
import ladybug.selenum.FuncExhGenerator;
import ladybug.selenum.FuncIsoGenerator;
import ladybug.selenum.FuncSameIsoGenerator;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Generator;
import ladybug.selenum.RelExhGenerator;
import ladybug.selenum.RelIsoGenerator;
import ladybug.selenum.RelationGenerator;
import ladybug.selenum.SetExhGenerator;
import ladybug.selenum.SetGenerator;
import ladybug.selenum.SetIsoGenerator;

public class IsoTester {
    static boolean showMappings = false;
    static boolean showIsoFree = false;
    static PrintStream outFile = System.out;
    static Vector allColors = new Vector();

    /*
     * Unable to fully structure code
     */
    public static boolean areIsomorphs(FunctionValue fv1, FunctionValue fv2, Scope scope, Coloring coloring) {
        block14: {
            rt = (RelationType)fv1.getType();
            dom1 = new SetValue(new SetType(rt.domain()), scope);
            dom2 = new SetValue(new SetType(rt.domain()), scope);
            ran1 = new SetValue(new SetType(rt.range()), scope);
            ran2 = new SetValue(new SetType(rt.range()), scope);
            fv2.range(ran2);
            fv1.range(ran1);
            if (ran1.card() != ran2.card()) {
                return false;
            }
            fv2.domain(dom2);
            fv1.domain(dom1);
            if (dom1.card() != dom2.card()) {
                return false;
            }
            if (IsoTester.showMappings) {
                IsoTester.outFile.println("Testing isomorphism of");
                IsoTester.outFile.println(fv1.toString());
                IsoTester.outFile.println(fv2.toString());
            }
            genLeft = IsoTester.findBijGen(scope, rt.domain(), coloring);
            genRight = null;
            rightMap = null;
            scr1 = new FunctionValue(rt, scope);
            scr2 = new FunctionValue(rt, scope);
            sameTypes = false;
            if (rt.domain() == rt.range()) {
                sameTypes = true;
                rightMap = new FunctionValue(rt, scope);
            } else {
                genLeft.setDomain(dom2);
                genLeft.setRange(dom1);
                genRight = IsoTester.findBijGen(scope, rt.range(), coloring);
                genRight.setDomain(ran1);
                genRight.setRange(ran2);
            }
            genLeft.reset();
            if (!sameTypes) ** GOTO lbl67
            while (genLeft.hasMoreElements()) {
                leftMap = genLeft.nextFunction();
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping lhs: " + leftMap.toString());
                }
                leftMap.compose(fv1, scr1);
                scr1.domain(dom1);
                if (!dom1.equals(dom2)) continue;
                try {
                    leftMap.transpose(rightMap);
                }
                catch (ValueError v0) {
                    continue;
                }
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping rhs: " + rightMap.toString());
                }
                scr1.compose(rightMap, scr2);
                if (!scr2.equals(fv2)) continue;
                return true;
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                leftMap = genLeft.nextFunction();
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping lhs: " + leftMap.toString());
                }
                leftMap.compose(fv1, scr1);
                scr1.domain(dom1);
                if (!dom1.equals(dom2)) continue;
                genRight.reset();
                while (genRight.hasMoreElements()) {
                    rightMap = genRight.nextFunction();
                    if (IsoTester.showMappings) {
                        IsoTester.outFile.println("Mapping rhs: " + rightMap.toString());
                    }
                    scr1.compose(rightMap, scr2);
                    if (!scr2.equals(fv2)) continue;
                    return true;
                }
lbl67:
                // 3 sources

                ** while (genLeft.hasMoreElements())
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean areIsomorphs(RelationValue fv1, RelationValue fv2, Scope scope, Coloring coloring) {
        block14: {
            rt = (RelationType)fv1.getType();
            dom1 = new SetValue(new SetType(rt.domain()), fv1.domainMax());
            dom2 = new SetValue(new SetType(rt.domain()), fv1.domainMax());
            ran1 = new SetValue(new SetType(rt.range()), scope);
            ran2 = new SetValue(new SetType(rt.range()), scope);
            fv2.range(ran2);
            fv1.range(ran1);
            if (ran1.card() != ran2.card()) {
                return false;
            }
            fv2.domain(dom2);
            fv1.domain(dom1);
            if (dom1.card() != dom2.card()) {
                return false;
            }
            if (IsoTester.showMappings) {
                IsoTester.outFile.println("Testing isomorphism of");
                IsoTester.outFile.println(fv1.toString());
                IsoTester.outFile.println(fv2.toString());
            }
            genLeft = IsoTester.findBijGen(scope, rt.domain(), coloring);
            genRight = null;
            rightMap = null;
            scr1 = new RelationValue(rt, scope);
            scr2 = new RelationValue(rt, scope);
            sameTypes = false;
            if (rt.domain() == rt.range()) {
                sameTypes = true;
                rightMap = new FunctionValue(rt, scope);
            } else {
                genLeft.setDomain(dom2);
                genLeft.setRange(dom1);
                genRight = IsoTester.findBijGen(scope, rt.range(), coloring);
                genRight.setDomain(ran1);
                genRight.setRange(ran2);
            }
            genLeft.reset();
            if (!sameTypes) ** GOTO lbl67
            while (genLeft.hasMoreElements()) {
                leftMap = genLeft.nextFunction();
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping lhs: " + leftMap.toString());
                }
                leftMap.compose(fv1, scr1);
                scr1.domain(dom1);
                if (!dom1.equals(dom2)) continue;
                try {
                    leftMap.transpose(rightMap);
                }
                catch (ValueError v0) {
                    continue;
                }
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping rhs: " + rightMap.toString());
                }
                scr1.compose(rightMap, scr2);
                if (!scr2.equals(fv2)) continue;
                return true;
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                leftMap = genLeft.nextFunction();
                if (IsoTester.showMappings) {
                    IsoTester.outFile.println("Mapping lhs: " + leftMap.toString());
                }
                leftMap.compose(fv1, scr1);
                scr1.domain(dom1);
                if (!dom1.equals(dom2)) continue;
                genRight.reset();
                while (genRight.hasMoreElements()) {
                    rightMap = genRight.nextFunction();
                    if (IsoTester.showMappings) {
                        IsoTester.outFile.println("Mapping rhs: " + rightMap.toString());
                    }
                    scr1.compose(rightMap, scr2);
                    if (!scr2.equals(fv2)) continue;
                    return true;
                }
lbl67:
                // 3 sources

                ** while (genLeft.hasMoreElements())
            }
        }
        return false;
    }

    public static boolean areIsomorphs(SetValue sv1, SetValue sv2, Scope scope, Coloring coloring) {
        SetType st = (SetType)sv1.getType();
        if (sv1.card() != sv1.card()) {
            return false;
        }
        if (showMappings) {
            outFile.println("Testing isomorphism of");
            outFile.println(sv1.toString());
            outFile.println(sv2.toString());
        }
        FunctionGenerator genMap = IsoTester.findBijGen(scope, st.elemType(), coloring);
        genMap.reset();
        SetValue scr1 = new SetValue(st, scope);
        while (genMap.hasMoreElements()) {
            FunctionValue map = genMap.nextFunction();
            if (showMappings) {
                outFile.println("Mapping with " + map.toString());
            }
            map.image(sv1, scr1);
            if (!scr1.equals(sv2)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            Value baseValue;
            Value isoValue;
            RelationType rt;
            TypeList tl = new TypeList();
            GivenType typeA = new GivenType("A");
            typeA.setPrefix("a");
            tl.addType(typeA);
            GivenType typeB = new GivenType("B");
            typeB.setPrefix("b");
            tl.addType(typeB);
            LadyBug.init();
            Scope scope = new Scope(tl);
            Variable var = new Variable("x", null, null, SourceLoc.noLoc);
            VariableList vars = new VariableList(var);
            boolean doFuncs = false;
            boolean doSets = false;
            boolean doRels = false;
            boolean doChains = false;
            boolean sameTypes = false;
            showIsoFree = false;
            showMappings = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].substring(0, 1).equals("#")) {
                    String tname = args[i].substring(1, 2);
                    GivenType t = tname.equals("A") ? typeA : typeB;
                    scope.setBound(t, Integer.valueOf(args[i].substring(2)));
                }
                ++i;
            }
            if (args.length == 0) {
                rt = new RelationType(typeA, typeB, true, false, false, false, false);
                var.setType(rt);
                isoValue = new FunctionValue(rt, scope);
                baseValue = new FunctionValue(rt, scope);
                doFuncs = true;
            } else if (args[0].equals("A->B")) {
                rt = new RelationType(typeA, typeB, true, false, false, false, false);
                var.setType(rt);
                isoValue = new FunctionValue(rt, scope);
                baseValue = new FunctionValue(rt, scope);
                doFuncs = true;
            } else if (args[0].equals("A->A")) {
                rt = new RelationType(typeA, typeA, true, false, false, false, false);
                var.setType(rt);
                baseValue = new FunctionValue(rt, scope);
                isoValue = new FunctionValue(rt, scope);
                sameTypes = true;
                doFuncs = true;
            } else if (args[0].equals("A<->B")) {
                rt = new RelationType(typeA, typeB, false, false, false, false, false);
                var.setType(rt);
                isoValue = new RelationValue(rt, scope);
                baseValue = new RelationValue(rt, scope);
                doRels = true;
            } else if (args[0].equals("A<->A")) {
                rt = new RelationType(typeA, typeA, false, false, false, false, false);
                var.setType(rt);
                baseValue = new RelationValue(rt, scope);
                isoValue = new RelationValue(rt, scope);
                sameTypes = true;
                doRels = true;
            } else if (args[0].equals("setA")) {
                SetType st = new SetType(typeA);
                var.setType(st);
                baseValue = new SetValue(st, scope);
                isoValue = new SetValue(st, scope);
                doSets = true;
            } else if (args[0].equals("chainA")) {
                rt = new RelationType(typeA, typeA, true, false, false, false, false);
                var.setType(rt);
                baseValue = new FunctionValue(rt, scope);
                ((FunctionValue)baseValue).markChain();
                isoValue = new FunctionValue(rt, scope);
                ((FunctionValue)isoValue).markChain();
                sameTypes = true;
                doChains = true;
            } else {
                System.out.println("Unsupported type: " + args[0]);
                return;
            }
            AtomicColoring baseColoring = new AtomicColoring(var, vars.elements(), scope, null);
            String colorA = null;
            String colorB = null;
            int i2 = 1;
            while (i2 < args.length) {
                if (args[i2].equals("out")) {
                    outFile = new PrintStream(new FileOutputStream(new File(args[++i2])));
                } else if (args[i2].equals("showMaps")) {
                    showMappings = true;
                } else if (args[i2].equals("showIso")) {
                    showIsoFree = true;
                } else if (!args[i2].substring(0, 1).equals("#")) {
                    if (args[i2].equals("color")) {
                        ++i2;
                        if (baseColoring == null) {
                            baseColoring = new AtomicColoring(var, vars.elements(), scope, null);
                        }
                        if (args[i2].equals("A")) {
                            colorA = args[++i2];
                        } else {
                            colorB = args[++i2];
                        }
                    } else {
                        System.out.println("Unsupported option: " + args[i2]);
                    }
                }
                ++i2;
            }
            System.out.println("Testing " + (doFuncs ? "functions" : (doSets ? "sets" : (doRels ? "rels" : "??"))));
            outFile.println("For " + scope.toString());
            if (doFuncs) {
                Generator isoGen = sameTypes ? new FuncSameIsoGenerator((FunctionValue)isoValue, var, scope, baseColoring) : new FuncIsoGenerator((FunctionValue)isoValue, var, scope, baseColoring);
                FuncExhGenerator baseGen = new FuncExhGenerator((FunctionValue)baseValue, var, scope);
                if (sameTypes) {
                    String[] colors = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                    int i3 = 0;
                    while (i3 < colors.length) {
                        ((Coloring)baseColoring).reset();
                        IsoTester.setColoring(baseColoring, typeA, scope, colors[i3]);
                        outFile.println("with " + ((Coloring)baseColoring).dumpColors());
                        IsoTester.testGenerator(isoGen, baseGen, scope, (Coloring)baseColoring);
                        outFile.println();
                        ++i3;
                    }
                } else {
                    String[] colorsA = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                    String[] colorsB = colorB == null ? IsoTester.allColorings(typeB, scope) : new String[]{colorB};
                    int i4 = 0;
                    while (i4 < colorsA.length) {
                        int j = 0;
                        while (j < colorsB.length) {
                            ((Coloring)baseColoring).reset();
                            IsoTester.setColoring(baseColoring, typeA, scope, colorsA[i4]);
                            IsoTester.setColoring(baseColoring, typeB, scope, colorsB[j]);
                            outFile.println("with " + ((Coloring)baseColoring).dumpColors());
                            IsoTester.testGenerator(isoGen, baseGen, scope, (Coloring)baseColoring);
                            outFile.println();
                            ++j;
                        }
                        ++i4;
                    }
                }
            } else if (doRels) {
                RelIsoGenerator isoGen = sameTypes ? null : new RelIsoGenerator((RelationValue)isoValue, var, scope, baseColoring);
                RelExhGenerator baseGen = new RelExhGenerator((RelationValue)baseValue, var, scope);
                if (sameTypes) {
                    String[] colors = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                    int i5 = 0;
                    while (i5 < colors.length) {
                        ((Coloring)baseColoring).reset();
                        IsoTester.setColoring(baseColoring, typeA, scope, colors[i5]);
                        outFile.println("with " + ((Coloring)baseColoring).dumpColors());
                        IsoTester.testGenerator(isoGen, baseGen, scope, (Coloring)baseColoring);
                        outFile.println();
                        ++i5;
                    }
                } else {
                    String[] colorsA = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                    String[] colorsB = colorB == null ? IsoTester.allColorings(typeB, scope) : new String[]{colorB};
                    int i6 = 0;
                    while (i6 < colorsA.length) {
                        int j = 0;
                        while (j < colorsB.length) {
                            ((Coloring)baseColoring).reset();
                            IsoTester.setColoring(baseColoring, typeA, scope, colorsA[i6]);
                            IsoTester.setColoring(baseColoring, typeB, scope, colorsB[j]);
                            outFile.println("with " + ((Coloring)baseColoring).dumpColors());
                            IsoTester.testGenerator(isoGen, baseGen, scope, (Coloring)baseColoring);
                            outFile.println();
                            ++j;
                        }
                        ++i6;
                    }
                }
            } else if (doChains) {
                ChainIsoGenerator isoGen = new ChainIsoGenerator((FunctionValue)isoValue, var, scope, baseColoring);
                ChainExhGenerator baseGen = new ChainExhGenerator((FunctionValue)baseValue, var, scope);
                String[] colors = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                int i7 = 0;
                while (i7 < colors.length) {
                    ((Coloring)baseColoring).reset();
                    IsoTester.setColoring(baseColoring, typeA, scope, colors[i7]);
                    outFile.println("with " + ((Coloring)baseColoring).dumpColors());
                    IsoTester.testGenerator(isoGen, baseGen, scope, (Coloring)baseColoring);
                    outFile.println();
                    ++i7;
                }
            } else if (doSets) {
                SetIsoGenerator isoGen = new SetIsoGenerator((SetValue)isoValue, var, scope, baseColoring);
                SetExhGenerator baseGen = new SetExhGenerator((SetValue)baseValue, var, scope);
                String[] colors = colorA == null ? IsoTester.allColorings(typeA, scope) : new String[]{colorA};
                int i8 = 0;
                while (i8 < colors.length) {
                    ((Coloring)baseColoring).reset();
                    IsoTester.setColoring(baseColoring, typeA, scope, colors[i8]);
                    outFile.println("with " + ((Coloring)baseColoring).dumpColors());
                    IsoTester.testGenerator(isoGen, baseGen, scope, (Coloring)baseColoring);
                    outFile.println();
                    ++i8;
                }
            }
            System.out.println("Finished test");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testGenerator(FunctionGenerator isoFree, FunctionGenerator baseLine, Scope scope, Coloring coloring) {
        RelationType rt = (RelationType)isoFree.typeGenerated();
        SetValue dom = new SetValue(new SetType(rt.domain()), scope);
        SetValue ran = new SetValue(new SetType(rt.range()), scope);
        Vector[][] isoFunctions = new Vector[(int)rt.domain().numValues(scope) + 1][(int)rt.range().numValues(scope) + 1];
        int d = 0;
        while ((long)d <= rt.domain().numValues(scope)) {
            int r = 0;
            while ((long)r <= rt.range().numValues(scope)) {
                if (r <= d) {
                    isoFunctions[d][r] = new Vector();
                }
                ++r;
            }
            ++d;
        }
        FunctionValue[] isoFreeValues = IsoTester.isoFreeSet(isoFree, scope, true, coloring, isoFunctions);
        outFile.println("Found " + String.valueOf(isoFreeValues.length) + " isomorph-free values");
        baseLine.reset();
        int numUnmatched = 0;
        block2: while (baseLine.hasMoreElements()) {
            FunctionValue fv = baseLine.nextFunction();
            fv.domain(dom);
            int d2 = dom.card();
            fv.range(ran);
            int r = ran.card();
            Enumeration fe = isoFunctions[d2][r].elements();
            while (fe.hasMoreElements()) {
                FunctionValue fv2 = (FunctionValue)fe.nextElement();
                if (IsoTester.areIsomorphs(fv, fv2, scope, coloring)) continue block2;
            }
            outFile.println("unmatched function " + fv.toString());
            ++numUnmatched;
        }
        if (numUnmatched > 0) {
            outFile.println("Found " + String.valueOf(numUnmatched) + " unmatched values");
        }
    }

    private static FunctionValue[] isoFreeSet(FunctionGenerator gen, Scope scope, boolean reportDups, Coloring coloring, Vector[][] isoFunctions) {
        gen.reset();
        int max = (int)gen.totalGenValues();
        FunctionValue[] isoFree = new FunctionValue[max];
        int numIsoFree = 0;
        RelationType rt = (RelationType)gen.typeGenerated();
        SetValue dom = new SetValue(new SetType(rt.domain()), scope);
        SetValue ran = new SetValue(new SetType(rt.range()), scope);
        block0: while (gen.hasMoreElements()) {
            FunctionValue fv = gen.nextFunction();
            fv.domain(dom);
            int d = dom.card();
            fv.range(ran);
            int r = ran.card();
            Enumeration fe = isoFunctions[d][r].elements();
            while (fe.hasMoreElements()) {
                FunctionValue fv2 = (FunctionValue)fe.nextElement();
                if (!IsoTester.areIsomorphs(fv, fv2, scope, coloring)) continue;
                if (!reportDups) continue block0;
                outFile.println("Isomorphic function discovered");
                outFile.println(fv.toString());
                outFile.println(fv2.toString());
                continue block0;
            }
            if (showIsoFree) {
                outFile.println(fv.toString());
            }
            fv = (FunctionValue)fv.copy();
            isoFree[numIsoFree++] = fv;
            isoFunctions[d][r].insertElementAt(fv, 0);
        }
        if (numIsoFree == max) {
            return isoFree;
        }
        FunctionValue[] justFree = new FunctionValue[numIsoFree];
        int i = 0;
        while (i < numIsoFree) {
            justFree[i] = isoFree[i];
            ++i;
        }
        return justFree;
    }

    public static void testGenerator(RelationGenerator isoFree, RelationGenerator baseLine, Scope scope, Coloring coloring) {
        RelationType rt = (RelationType)isoFree.typeGenerated();
        SetValue dom = new SetValue(new SetType(rt.domain()), scope);
        SetValue ran = new SetValue(new SetType(rt.range()), scope);
        Vector[][] isoRels = new Vector[(int)rt.domain().numValues(scope) + 1][(int)rt.range().numValues(scope) + 1];
        int d = 0;
        while ((long)d <= rt.domain().numValues(scope)) {
            int r = 0;
            while ((long)r <= rt.range().numValues(scope)) {
                isoRels[d][r] = new Vector();
                ++r;
            }
            ++d;
        }
        RelationValue[] isoFreeValues = IsoTester.isoFreeSet(isoFree, scope, true, coloring, isoRels);
        outFile.println("Found " + String.valueOf(isoFreeValues.length) + " isomorph-free values");
        baseLine.reset();
        int numUnmatched = 0;
        block2: while (baseLine.hasMoreElements()) {
            RelationValue rv = baseLine.nextRelation();
            rv.domain(dom);
            int d2 = dom.card();
            rv.range(ran);
            int r = ran.card();
            Enumeration re = isoRels[d2][r].elements();
            while (re.hasMoreElements()) {
                RelationValue rv2 = (RelationValue)re.nextElement();
                if (IsoTester.areIsomorphs(rv, rv2, scope, coloring)) continue block2;
            }
            outFile.println("unmatched function " + rv.toString());
            ++numUnmatched;
        }
        if (numUnmatched > 0) {
            outFile.println("Found " + String.valueOf(numUnmatched) + " unmatched values");
        }
    }

    private static RelationValue[] isoFreeSet(RelationGenerator gen, Scope scope, boolean reportDups, Coloring coloring, Vector[][] isoRels) {
        gen.reset();
        int max = (int)gen.totalGenValues();
        RelationValue[] isoFree = new RelationValue[max];
        int numIsoFree = 0;
        RelationType rt = (RelationType)gen.typeGenerated();
        SetValue dom = new SetValue(new SetType(rt.domain()), scope);
        SetValue ran = new SetValue(new SetType(rt.range()), scope);
        block0: while (gen.hasMoreElements()) {
            RelationValue rv = gen.nextRelation();
            rv.domain(dom);
            int d = dom.card();
            rv.range(ran);
            int r = ran.card();
            Enumeration re = isoRels[d][r].elements();
            while (re.hasMoreElements()) {
                RelationValue rv2 = (RelationValue)re.nextElement();
                if (!IsoTester.areIsomorphs(rv, rv2, scope, coloring)) continue;
                if (!reportDups) continue block0;
                outFile.println("Isomorphic relation discovered");
                outFile.println(rv.toString());
                outFile.println(rv2.toString());
                continue block0;
            }
            if (showIsoFree) {
                outFile.println(rv.toString());
            }
            rv = (RelationValue)rv.copy();
            isoFree[numIsoFree++] = rv;
            isoRels[d][r].insertElementAt(rv, 0);
        }
        if (numIsoFree == max) {
            return isoFree;
        }
        RelationValue[] justFree = new RelationValue[numIsoFree];
        int i = 0;
        while (i < numIsoFree) {
            justFree[i] = isoFree[i];
            ++i;
        }
        return justFree;
    }

    public static void testGenerator(SetGenerator isoFree, SetGenerator baseLine, Scope scope, Coloring coloring) {
        SetValue[] isoFreeValues = IsoTester.isoFreeSet(isoFree, scope, true, coloring);
        outFile.println("Found " + String.valueOf(isoFreeValues.length) + " isomorph-free values");
        baseLine.reset();
        int numUnmatched = 0;
        block0: while (baseLine.hasMoreElements()) {
            SetValue sv = baseLine.nextSet();
            int i = 0;
            while (i < isoFreeValues.length) {
                if (IsoTester.areIsomorphs(sv, isoFreeValues[i], scope, coloring)) continue block0;
                ++i;
            }
            outFile.println("unmatched function " + sv.toString());
            ++numUnmatched;
        }
        if (numUnmatched > 0) {
            outFile.println("Found " + String.valueOf(numUnmatched) + " unmatched values");
        }
    }

    private static SetValue[] isoFreeSet(SetGenerator gen, Scope scope, boolean reportDups, Coloring coloring) {
        int i;
        gen.reset();
        int max = (int)gen.totalGenValues();
        SetValue[] isoFree = new SetValue[max];
        int numIsoFree = 0;
        block0: while (gen.hasMoreElements()) {
            SetValue sv = gen.nextSet();
            i = 0;
            while (i < numIsoFree) {
                if (IsoTester.areIsomorphs(sv, isoFree[i], scope, coloring)) {
                    if (!reportDups) continue block0;
                    outFile.println("Isomorphic function discovered");
                    outFile.println(sv.toString());
                    outFile.println(isoFree[i].toString());
                    continue block0;
                }
                ++i;
            }
            if (showIsoFree) {
                outFile.println(sv.toString());
            }
            isoFree[numIsoFree++] = (SetValue)sv.copy();
        }
        if (numIsoFree == max) {
            return isoFree;
        }
        SetValue[] justFree = new SetValue[numIsoFree];
        i = 0;
        while (i < numIsoFree) {
            justFree[i] = isoFree[i];
            ++i;
        }
        return justFree;
    }

    private static FunctionGenerator findBijGen(Scope scope, ScalarType elemType, Coloring coloring) {
        RelationType rt = new RelationType(elemType, elemType, true, true, true, true, false);
        FunctionValue map = new FunctionValue(rt, scope);
        Variable v = null;
        try {
            v = new Variable("x", rt, null, SourceLoc.noLoc);
        }
        catch (ParseError parseError) {}
        int[] colors = coloring.coloring(elemType);
        int numColors = 1;
        int i = 1;
        while (i < map.domainMax()) {
            if (colors[i] != colors[i - 1]) {
                ++numColors;
            }
            ++i;
        }
        if (numColors == 1) {
            return new FuncBijExhGenerator(map, v, scope);
        }
        return new ColorMapper(map, v, scope, colors, numColors);
    }

    private static String[] allColorings(ScalarType t, Scope scope) {
        return IsoTester.allColorings((int)t.numValues(scope));
    }

    private static String[] allColorings(int max) {
        if (max < 1) {
            return null;
        }
        if (max <= allColors.size()) {
            return (String[])allColors.elementAt(max - 1);
        }
        if (max == 1) {
            String[] newColorings = new String[]{"0"};
            allColors.insertElementAt(newColorings, max - 1);
            return newColorings;
        }
        String[] prevColorings = IsoTester.allColorings(max - 1);
        String[] newColorings = new String[prevColorings.length * 2];
        int i = 0;
        while (i < prevColorings.length) {
            String str = prevColorings[i];
            int color = Integer.valueOf(str.substring(max - 2));
            newColorings[i * 2] = String.valueOf(str) + String.valueOf(color);
            newColorings[i * 2 + 1] = String.valueOf(str) + String.valueOf(color + 1);
            ++i;
        }
        allColors.insertElementAt(newColorings, max - 1);
        return newColorings;
    }

    private static void setColoring(Coloring baseColoring, ScalarType t, Scope scope, String coloringString) {
        SetValue sv = new SetValue(new SetType(t), scope);
        sv.init();
        sv.addElement(0);
        int j = 1;
        while (j < coloringString.length()) {
            if (coloringString.charAt(j - 1) != coloringString.charAt(j)) {
                baseColoring.distinguish(sv);
                sv.init();
            }
            sv.addElement(j);
            ++j;
        }
        baseColoring.distinguish(sv);
    }
}

