/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Variable;
import ladybug.selenum.Coloring;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Generator;
import ladybug.selenum.SetGenerator;
import ladybug.selenum.SetIsoGenerator;

public class FuncSameIsoGenerator
extends Generator
implements FunctionGenerator {
    private Coloring rangeColoring;
    private Coloring domainColoring;
    private ScalarType _dcolorType;
    private ScalarType _rcolorType;
    private SetValue _range;
    private FunctionValue val;
    private FunctionValue scratch;
    private FunctionValue result;
    private FunctionValue rangeMap;
    private SetValue usedDomain;
    private SetValue genDomain;
    private SetGenerator domGen;
    private int[] _dcolors;
    private int[][] _rcolors;
    private int[] _numColors;
    private int[] _edgesGenerated;
    private int[] domElems;
    private long nextIndex;
    private long maxIndex;
    private int domSize;
    private int ranSize;
    private int numElems;
    private int numDomElems;
    private boolean mapResult;
    private boolean hasDomain;
    private boolean sameTypes;

    public FuncSameIsoGenerator(FunctionValue value, Variable var, Scope scope, Coloring baseColoring) {
        super(var, var.getType());
        RelationType rt = (RelationType)var.getType();
        this._dcolorType = rt.domain();
        this._rcolorType = rt.range();
        this.sameTypes = this._dcolorType.equals(this._rcolorType);
        this.nextIndex = 0L;
        this.domSize = (int)this._dcolorType.numValues(scope);
        this.ranSize = (int)this._rcolorType.numValues(scope);
        this._rcolors = new int[this.domSize][this.ranSize];
        this._numColors = new int[this.domSize];
        this._edgesGenerated = new int[this.domSize];
        this._dcolors = new int[this.domSize];
        this.domElems = new int[this.domSize];
        this.genDomain = new SetValue(new SetType(this._dcolorType), this.domSize);
        this.usedDomain = new SetValue(new SetType(this._dcolorType), this.domSize);
        this.domGen = new SetIsoGenerator(this.genDomain, null, this.genDomain.getType(), scope, baseColoring);
        this.result = value;
        this.mapResult = false;
        this.numElems = this.domSize;
        this.maxIndex = this.domSize;
        this.rangeMap = new FunctionValue(new RelationType(this._rcolorType, this._rcolorType, true, true, false, false, false), this.domSize, this.domSize);
        this.scratch = new FunctionValue(new RelationType(this._dcolorType, this._rcolorType, true, false, false, false, false), this.domSize, this.ranSize);
        this.val = this.result;
        this.domainColoring = baseColoring.extend(var);
        this.domGen.setColoring(this.domainColoring);
        this.rangeColoring = this.domainColoring.extend(var);
        rt = new RelationType(this._dcolorType, this._rcolorType);
        rt.setFunction(true);
        this.setTypeGenerated(rt);
        this.terminate();
    }

    public void setValue(FunctionValue value) {
        this.result = value;
        if (!this.mapResult) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        this.domGen.setDomain(dom);
        this.reset();
    }

    public void setRange(SetValue ran) {
        this.numElems = ran.card();
        if (this.numElems == 0) {
            this.ranSize = 0;
            this.mapResult = false;
            this._range = null;
            this.val = this.result;
            this.reset();
            return;
        }
        this.ranSize = ran.maxElem() + 1;
        if (this.ranSize == this.numElems) {
            this.mapResult = false;
            this._range = null;
            this.val = this.result;
        } else {
            this.mapResult = true;
            this._range = ran;
            this.val = this.scratch;
            int i = 0;
            int j = 0;
            while (i < this.domSize) {
                if (ran.hasElement(i)) {
                    this.rangeMap.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        }
        this.reset();
    }

    public void reset() {
        this._dcolors = this.domainColoring.coloring(this._dcolorType);
        this.nextIndex = 0L;
        this.hasDomain = false;
        this.domGen.reset();
        if (this.ranSize == 0) {
            this.maxIndex = 0L;
            return;
        }
        this.maxIndex = Generator.pow(this.ranSize + 1, this.domSize);
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        if (this.nextIndex >= this.maxIndex) {
            return false;
        }
        if (this.hasDomain) {
            return true;
        }
        return this.domGen.hasMoreElements();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextFunction();
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        if (!this.hasDomain) {
            if (!this.domGen.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            this.domGen.nextSet();
            this.hasDomain = true;
            boolean hasMoreEdges = false;
            this.numDomElems = 0;
            int i = 0;
            while (i < this.domSize) {
                if (this.genDomain.hasElement(i)) {
                    this.domElems[this.numDomElems] = i;
                    ++this.numDomElems;
                }
                ++i;
            }
            this.val.init();
            this.usedDomain.init();
            if (this.numDomElems > 0) {
                int j;
                this.usedDomain.addElement(this.domElems[0]);
                this.domainColoring.distinguish(this.usedDomain);
                int[] allColors = this.domainColoring.coloring(this._rcolorType);
                if (this.mapResult) {
                    i = 0;
                    j = 0;
                    while (i < this.ranSize) {
                        if (this._range.hasElement(i)) {
                            this._rcolors[0][j++] = allColors[i];
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < this.ranSize) {
                        this._rcolors[0][i] = allColors[i];
                        ++i;
                    }
                }
                this._numColors[0] = 1;
                i = 1;
                while (i < this.numElems) {
                    if (this._rcolors[0][i - 1] != this._rcolors[0][i]) {
                        this._numColors[0] = this._numColors[0] + 1;
                    }
                    ++i;
                }
                this.val.addMapping(this.domElems[0], 0);
                this._edgesGenerated[0] = 1;
                if (this._numColors[0] > 1) {
                    hasMoreEdges = true;
                }
                int edge = 1;
                while (edge < this.numDomElems) {
                    if (this._dcolors[this.domElems[edge - 1]] != this._dcolors[this.domElems[edge]]) {
                        this.usedDomain.init();
                    }
                    this.usedDomain.addElement(this.domElems[edge]);
                    if (this.mapResult) {
                        this.val.compose(this.rangeMap, this.result);
                        this.rangeColoring.updateColoring(this.result);
                        this.rangeColoring.distinguish(this.usedDomain);
                        allColors = this.rangeColoring.coloring(this._rcolorType);
                        i = 0;
                        j = 0;
                        while (i < this.ranSize) {
                            if (this._range.hasElement(i)) {
                                this._rcolors[edge][j++] = allColors[i];
                            }
                            ++i;
                        }
                    } else {
                        this.rangeColoring.updateColoring(this.result);
                        this.rangeColoring.distinguish(this.usedDomain);
                        allColors = this.rangeColoring.coloring(this._rcolorType);
                        i = 0;
                        while (i < this.ranSize) {
                            this._rcolors[edge][i] = allColors[i];
                            ++i;
                        }
                    }
                    this._numColors[edge] = 1;
                    i = 1;
                    while (i < this.numElems) {
                        if (this._rcolors[edge][i - 1] != this._rcolors[edge][i]) {
                            int n = edge;
                            this._numColors[n] = this._numColors[n] + 1;
                        }
                        ++i;
                    }
                    this.val.addMapping(this.domElems[edge], 0);
                    this._edgesGenerated[edge] = 1;
                    if (this._numColors[edge] > 1) {
                        hasMoreEdges = true;
                    }
                    ++edge;
                }
            }
            ++this.nextIndex;
            if (this.mapResult) {
                this.val.compose(this.rangeMap, this.result);
            }
            if (this._coloring != null) {
                this._coloring.updateColoring(this.result);
            }
            if (!hasMoreEdges) {
                this.hasDomain = false;
                if (!this.domGen.hasMoreElements()) {
                    this.maxIndex = this.nextIndex;
                }
            }
            return this.result;
        }
        for (int edge = this.numDomElems - 1; edge >= 0; --edge) {
            int prev = this.val.mapsTo(this.domElems[edge]);
            this.val.removeMapping(this.domElems[edge], prev);
            if (this._edgesGenerated[edge] >= this._numColors[edge]) {
                continue;
            }
            this.usedDomain.init();
            this.usedDomain.addElement(this.domElems[0]);
            int i = 1;
            while (i <= edge) {
                if (this._dcolors[this.domElems[i - 1]] != this._dcolors[this.domElems[i]]) {
                    this.usedDomain.init();
                }
                this.usedDomain.addElement(this.domElems[i]);
                ++i;
            }
            int to = prev + 1;
            while (to < this.numElems) {
                if (this._rcolors[edge][to - 1] != this._rcolors[edge][to]) break;
                ++to;
            }
            this.val.addMapping(this.domElems[edge], to);
            int n = edge++;
            this._edgesGenerated[n] = this._edgesGenerated[n] + 1;
            while (edge < this.numDomElems) {
                int[] allColors;
                if (this._dcolors[this.domElems[edge - 1]] != this._dcolors[this.domElems[edge]]) {
                    this.usedDomain.init();
                }
                this.usedDomain.addElement(this.domElems[edge]);
                if (this.mapResult) {
                    this.val.compose(this.rangeMap, this.result);
                    this.rangeColoring.updateColoring(this.result);
                    this.rangeColoring.distinguish(this.usedDomain);
                    allColors = this.rangeColoring.coloring(this._rcolorType);
                    i = 0;
                    int j = 0;
                    while (i < this.ranSize) {
                        if (this._range.hasElement(i)) {
                            this._rcolors[edge][j++] = allColors[i];
                        }
                        ++i;
                    }
                } else {
                    this.rangeColoring.updateColoring(this.result);
                    this.rangeColoring.distinguish(this.usedDomain);
                    allColors = this.rangeColoring.coloring(this._rcolorType);
                    i = 0;
                    while (i < this.ranSize) {
                        this._rcolors[edge][i] = allColors[i];
                        ++i;
                    }
                }
                this._numColors[edge] = 1;
                i = 1;
                while (i < this.numElems) {
                    if (this._rcolors[edge][i - 1] != this._rcolors[edge][i]) {
                        int n2 = edge;
                        this._numColors[n2] = this._numColors[n2] + 1;
                    }
                    ++i;
                }
                if (this._dcolors[this.domElems[edge]] != this._dcolors[this.domElems[edge - 1]]) {
                    to = 0;
                    this._edgesGenerated[edge] = 1;
                } else if (this.sameTypes && this._rcolors[edge] != this._rcolors[edge - 1]) {
                    to = 0;
                    this._edgesGenerated[edge] = 1;
                } else {
                    this._edgesGenerated[edge] = this._edgesGenerated[edge - 1];
                }
                this.val.addMapping(this.domElems[edge], to);
                ++edge;
            }
            ++this.nextIndex;
            if (this.mapResult) {
                this.val.compose(this.rangeMap, this.result);
            }
            if (this._coloring != null) {
                this._coloring.updateColoring(this.result);
            }
            boolean hasMoreEdges = false;
            i = 0;
            while (i < this.numDomElems) {
                if (this._edgesGenerated[i] < this._numColors[i]) {
                    hasMoreEdges = true;
                    break;
                }
                ++i;
            }
            if (!hasMoreEdges) {
                this.hasDomain = false;
                if (!this.domGen.hasMoreElements()) {
                    this.maxIndex = this.nextIndex;
                }
            }
            return this.result;
        }
        throw new NoSuchElementException();
    }

    public double pctCompleted() {
        if (this.maxIndex == 0L) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0L) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }
}

