/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Variable;
import ladybug.selenum.Coloring;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Generator;
import ladybug.selenum.SetGenerator;
import ladybug.selenum.SetIsoGenerator;

public class FuncIsoGenerator
extends Generator
implements FunctionGenerator {
    private Coloring rangeColoring;
    private Coloring domainColoring;
    private ScalarType _dcolorType;
    private ScalarType _rcolorType;
    private SetValue _range;
    private FunctionValue val;
    private FunctionValue scratch;
    private FunctionValue result;
    private FunctionValue rangeMap;
    private SetValue genDomain;
    private SetGenerator domGen;
    private int[] _dcolors;
    private int[][] _rcolors;
    private int[][] _rmax;
    private int[][] _rdegree;
    private int[] _numColors;
    private int[] _edgesGenerated;
    private int[] domElems;
    private long nextIndex;
    private long maxIndex;
    private int domSize;
    private int ranSize;
    private int numElems;
    private int numDomElems;
    private boolean mapResult;
    private boolean computed;
    private boolean sameTypes;

    public FuncIsoGenerator(FunctionValue value, Variable var, Scope scope, Coloring baseColoring) {
        super(var, var.getType());
        RelationType rt = (RelationType)var.getType();
        this._dcolorType = rt.domain();
        this._rcolorType = rt.range();
        this.nextIndex = 0L;
        this.domSize = (int)this._dcolorType.numValues(scope);
        this.ranSize = (int)this._rcolorType.numValues(scope);
        this._rcolors = new int[this.domSize][this.ranSize];
        this._rmax = new int[this.domSize][this.ranSize];
        this._rdegree = new int[this.domSize][this.ranSize];
        this._numColors = new int[this.domSize];
        this._edgesGenerated = new int[this.domSize];
        this._dcolors = new int[this.domSize];
        this.domElems = new int[this.domSize];
        this.genDomain = new SetValue(new SetType(this._dcolorType), this.domSize);
        this.domGen = new SetIsoGenerator(this.genDomain, null, this.genDomain.getType(), scope, baseColoring);
        this.result = value;
        this.mapResult = false;
        this.numElems = this.ranSize;
        this.maxIndex = this.domSize;
        this.rangeMap = new FunctionValue(new RelationType(this._rcolorType, this._rcolorType, true, true, false, false, false), this.domSize, this.domSize);
        this.scratch = new FunctionValue(new RelationType(this._dcolorType, this._rcolorType, true, false, false, false, false), this.domSize, this.ranSize);
        this.val = this.result;
        this.domainColoring = baseColoring.extend(var);
        this.domGen.setColoring(this.domainColoring);
        this.rangeColoring = this.domainColoring.extend(var);
        rt = new RelationType(this._dcolorType, this._rcolorType);
        rt.setFunction(true);
        this.setTypeGenerated(rt);
        this.terminate();
    }

    public void setValue(FunctionValue value) {
        this.result = value;
        if (!this.mapResult) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        this.domGen.setDomain(dom);
        this.terminate();
    }

    public void setRange(SetValue ran) {
        this.numElems = ran.card();
        if (this.numElems == 0) {
            this.ranSize = 0;
            this.mapResult = false;
            this._range = null;
            this.val = this.result;
            this.reset();
            return;
        }
        this.ranSize = ran.maxElem() + 1;
        if (this.ranSize == this.numElems) {
            this.mapResult = false;
            this._range = null;
            this.val = this.result;
        } else {
            this.mapResult = true;
            this._range = ran;
            this.val = this.scratch;
            int i = 0;
            int j = 0;
            while (i < this.domSize) {
                if (ran.hasElement(i)) {
                    this.rangeMap.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        }
        this.terminate();
    }

    public void reset() {
        this.nextIndex = 0L;
        this.domGen.reset();
        if (!this.domGen.hasMoreElements()) {
            this.maxIndex = 0L;
            return;
        }
        if (this.ranSize == 0) {
            this.maxIndex = 0L;
            return;
        }
        this._dcolors = this.domainColoring.coloring(this._dcolorType);
        if (!this.newDomain()) {
            this.computed = false;
            this.maxIndex = 0L;
            return;
        }
        this.computed = true;
        if (this.mapResult) {
            this.val.compose(this.rangeMap, this.result);
        }
        this.maxIndex = Generator.pow(this.ranSize + 1, this.domSize);
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        if (this.nextIndex >= this.maxIndex) {
            return false;
        }
        return this.computeNextFunction();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextFunction();
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        if (!this.computeNextFunction()) {
            throw new NoSuchElementException();
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        this.computed = false;
        ++this.nextIndex;
        return this.result;
    }

    private boolean computeNextFunction() {
        if (this.computed) {
            return true;
        }
        if (this.chooseNextEdge()) {
            this.computed = true;
            if (this.mapResult) {
                this.val.compose(this.rangeMap, this.result);
            }
            return true;
        }
        if (!this.newDomain()) {
            this.computed = false;
            this.maxIndex = this.nextIndex;
            return false;
        }
        this.computed = true;
        if (this.mapResult) {
            this.val.compose(this.rangeMap, this.result);
        }
        return true;
    }

    private boolean newDomain() {
        int j;
        if (!this.domGen.hasMoreElements()) {
            return false;
        }
        this.domGen.nextSet();
        this.numDomElems = 0;
        int i = 0;
        while (i < this.domSize) {
            if (this.genDomain.hasElement(i)) {
                this.domElems[this.numDomElems] = i;
                ++this.numDomElems;
            }
            ++i;
        }
        this.val.init();
        if (this.numDomElems == 0) {
            return true;
        }
        this.rangeColoring.reset();
        this.rangeColoring.distinguish(this.domElems[0], this._dcolorType);
        int[] allColors = this.rangeColoring.coloring(this._rcolorType);
        if (this.mapResult) {
            i = 0;
            j = 0;
            while (i < this.ranSize) {
                if (this._range.hasElement(i)) {
                    this._rcolors[0][j++] = allColors[i];
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.ranSize) {
                this._rcolors[0][i] = allColors[i];
                ++i;
            }
        }
        this.val.addMapping(this.domElems[0], 0);
        this._edgesGenerated[0] = 1;
        this._rdegree[this._dcolors[this.domElems[0]]][0] = 1;
        this._rmax[0][0] = this.numDomElems;
        this._numColors[0] = 1;
        i = 1;
        while (i < this.numElems) {
            if (this._rcolors[0][i - 1] != this._rcolors[0][i]) {
                this._numColors[0] = this._numColors[0] + 1;
                this._rmax[0][i] = this.numDomElems;
                this._rdegree[this._dcolors[this.domElems[0]]][i] = 0;
            } else {
                this._rmax[0][i] = this._rdegree[this._dcolors[this.domElems[0]]][i - 1];
                this._rdegree[this._dcolors[this.domElems[0]]][i] = 0;
            }
            ++i;
        }
        int edge = 1;
        while (edge < this.numDomElems) {
            if (this.mapResult) {
                this.val.compose(this.rangeMap, this.result);
                this.rangeColoring.updateColoring(this.result);
                this.rangeColoring.distinguish(this.domElems[edge], this._dcolorType);
                allColors = this.rangeColoring.coloring(this._rcolorType);
                i = 0;
                j = 0;
                while (i < this.ranSize) {
                    if (this._range.hasElement(i)) {
                        this._rcolors[edge][j++] = allColors[i];
                    }
                    ++i;
                }
            } else {
                this.rangeColoring.updateColoring(this.result);
                this.rangeColoring.distinguish(this.domElems[edge], this._dcolorType);
                allColors = this.rangeColoring.coloring(this._rcolorType);
                i = 0;
                while (i < this.ranSize) {
                    this._rcolors[edge][i] = allColors[i];
                    ++i;
                }
            }
            this._numColors[edge] = 1;
            i = 1;
            while (i < this.numElems) {
                if (this._rcolors[edge][i - 1] != this._rcolors[edge][i]) {
                    int n = edge;
                    this._numColors[n] = this._numColors[n] + 1;
                }
                ++i;
            }
            if (this._dcolors[this.domElems[edge]] != this._dcolors[this.domElems[edge - 1]]) {
                i = 0;
                while (i < this.numElems) {
                    this._rdegree[this._dcolors[this.domElems[edge]]][i] = 0;
                    ++i;
                }
            }
            this._rmax[edge][0] = this.numDomElems;
            i = 1;
            while (i < this.numElems) {
                this._rmax[edge][i] = this._rcolors[edge][i - 1] != this._rcolors[edge][i] ? this.numDomElems : 0;
                ++i;
            }
            this.val.addMapping(this.domElems[edge], 0);
            int[] nArray = this._rdegree[this._dcolors[this.domElems[edge]]];
            nArray[0] = nArray[0] + 1;
            if (this.numElems > 1 && this._rcolors[edge][0] == this._rcolors[edge][1]) {
                this._rmax[edge][1] = this._rdegree[this._dcolors[this.domElems[edge]]][0];
            }
            this._edgesGenerated[edge] = 1;
            ++edge;
        }
        return true;
    }

    private boolean chooseNextEdge() {
        int edge = this.numDomElems - 1;
        block0: while (edge >= 0) {
            int prev = this.val.mapsTo(this.domElems[edge]);
            this.val.removeMapping(this.domElems[edge], prev);
            int[] nArray = this._rdegree[this._dcolors[this.domElems[edge]]];
            int n = prev;
            nArray[n] = nArray[n] - 1;
            if (prev + 1 < this.numElems && this._rcolors[edge][prev] == this._rcolors[edge][prev + 1]) {
                this._rmax[edge][prev + 1] = this._rdegree[this._dcolors[this.domElems[edge]]][prev];
            }
            if (this._edgesGenerated[edge] >= this._numColors[edge]) {
                --edge;
                continue;
            }
            block1: while (true) {
                int to = prev + 1;
                while (to < this.numElems) {
                    if (this._rcolors[edge][to - 1] != this._rcolors[edge][to]) {
                        if (this._rdegree[this._dcolors[this.domElems[edge]]][to] != this._rmax[edge][to]) break;
                        int n2 = edge;
                        this._edgesGenerated[n2] = this._edgesGenerated[n2] + 1;
                    }
                    ++to;
                }
                if (to >= this.numElems) {
                    --edge;
                    continue block0;
                }
                this.val.addMapping(this.domElems[edge], to);
                int n3 = edge;
                this._edgesGenerated[n3] = this._edgesGenerated[n3] + 1;
                int[] nArray2 = this._rdegree[this._dcolors[this.domElems[edge]]];
                int n4 = to;
                nArray2[n4] = nArray2[n4] + 1;
                if (to + 1 < this.numElems && this._rcolors[edge][to] == this._rcolors[edge][to + 1]) {
                    this._rmax[edge][to + 1] = this._rdegree[this._dcolors[this.domElems[edge]]][to];
                }
                prev = to;
                ++edge;
                while (edge < this.numDomElems) {
                    int i;
                    int[] allColors;
                    if (this.mapResult) {
                        this.val.compose(this.rangeMap, this.result);
                        this.rangeColoring.updateColoring(this.result);
                        this.rangeColoring.distinguish(this.domElems[edge], this._dcolorType);
                        allColors = this.rangeColoring.coloring(this._rcolorType);
                        i = 0;
                        int j = 0;
                        while (i < this.ranSize) {
                            if (this._range.hasElement(i)) {
                                this._rcolors[edge][j++] = allColors[i];
                            }
                            ++i;
                        }
                    } else {
                        this.rangeColoring.updateColoring(this.result);
                        this.rangeColoring.distinguish(this.domElems[edge], this._dcolorType);
                        allColors = this.rangeColoring.coloring(this._rcolorType);
                        i = 0;
                        while (i < this.ranSize) {
                            this._rcolors[edge][i] = allColors[i];
                            ++i;
                        }
                    }
                    this._numColors[edge] = 1;
                    i = 1;
                    while (i < this.numElems) {
                        if (this._rcolors[edge][i - 1] != this._rcolors[edge][i]) {
                            int n5 = edge;
                            this._numColors[n5] = this._numColors[n5] + 1;
                        }
                        ++i;
                    }
                    this._rmax[edge][0] = this.numDomElems;
                    i = 1;
                    while (i < this.numElems) {
                        this._rmax[edge][i] = this._rcolors[edge][i - 1] != this._rcolors[edge][i] ? this.numDomElems : 0;
                        ++i;
                    }
                    if (this._dcolors[this.domElems[edge]] != this._dcolors[this.domElems[edge - 1]]) {
                        to = 0;
                        this._edgesGenerated[edge] = 1;
                        i = 0;
                        while (i < this.numElems) {
                            this._rdegree[this._dcolors[this.domElems[edge]]][i] = 0;
                            ++i;
                        }
                    } else {
                        if (this._rdegree[this._dcolors[this.domElems[edge]]][to] == this._rmax[edge][to]) {
                            ++to;
                            while (to < this.numElems) {
                                if (this._rcolors[edge][to - 1] != this._rcolors[edge][to]) {
                                    if (this._rdegree[this._dcolors[this.domElems[edge]]][to] != this._rmax[edge][to]) break;
                                    int n6 = edge;
                                    this._edgesGenerated[n6] = this._edgesGenerated[n6] + 1;
                                }
                                ++to;
                            }
                            if (to >= this.numElems) continue block1;
                        }
                        this._edgesGenerated[edge] = this._edgesGenerated[edge - 1];
                    }
                    this.val.addMapping(this.domElems[edge], to);
                    int[] nArray3 = this._rdegree[this._dcolors[this.domElems[edge]]];
                    int n7 = to;
                    nArray3[n7] = nArray3[n7] + 1;
                    if (to + 1 < this.numElems && this._rcolors[edge][to] == this._rcolors[edge][to + 1]) {
                        this._rmax[edge][to + 1] = this._rdegree[this._dcolors[this.domElems[edge]]][to];
                    }
                    ++edge;
                }
                break;
            }
            if (this.mapResult) {
                this.val.compose(this.rangeMap, this.result);
            }
            return true;
        }
        return false;
    }

    public double pctCompleted() {
        if (this.maxIndex == 0L) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex <= 0L) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }
}

