/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.Variable;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Generator;

public class FuncExhGenerator
extends Generator
implements FunctionGenerator {
    private FunctionValue valScratch;
    private FunctionValue domScratch;
    private FunctionValue ranScratch;
    private FunctionValue val;
    private FunctionValue domResult;
    private FunctionValue ranSource;
    private FunctionValue result;
    private int nextIndex = 0;
    private int maxIndex;
    private int domSize;
    private int ranSize;
    private FunctionValue domMap;
    private FunctionValue ranMap;
    private boolean mapDomain;
    private boolean mapRange;

    public FuncExhGenerator(FunctionValue value, Variable var, Scope scope) {
        super(var, var.getType());
        this.result = value;
        RelationType rt = (RelationType)var.getType();
        this.domSize = (int)rt.domain().numValues(scope);
        this.ranSize = (int)rt.range().numValues(scope);
        this.mapDomain = false;
        this.mapRange = false;
        this.domMap = new FunctionValue(new RelationType(rt.domain(), rt.domain(), true, true, false, false, false), this.domSize, this.domSize);
        this.ranMap = new FunctionValue(new RelationType(rt.range(), rt.range(), true, true, false, false, false), this.ranSize, this.ranSize);
        this.val = this.result;
        this.domScratch = new FunctionValue(rt, this.domSize, this.ranSize);
        this.ranScratch = new FunctionValue(rt, this.domSize, this.ranSize);
        this.valScratch = new FunctionValue(rt, this.domSize, this.ranSize);
        this.computeMax();
        rt = new RelationType(rt.domain(), rt.range());
        rt.setFunction(true);
        this.setTypeGenerated(rt);
        this.terminate();
    }

    public void reset() {
        this.nextIndex = 0;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
    }

    public boolean hasMoreElements() {
        return this.nextIndex < this.maxIndex;
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextFunction();
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        int bits = this.nextIndex;
        this.val.init();
        int i = 0;
        while (i < this.domSize) {
            int to = bits % (this.ranSize + 1);
            if (to != 0) {
                this.val.addMapping(i, to - 1);
            }
            bits /= this.ranSize + 1;
            ++i;
        }
        ++this.nextIndex;
        if (this.mapDomain) {
            this.domMap.compose(this.val, this.domResult);
        }
        if (this.mapRange) {
            this.ranSource.compose(this.ranMap, this.result);
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    public void setValue(FunctionValue value) {
        this.result = value;
        if (!this.mapRange) {
            if (this.mapDomain) {
                this.domResult = this.result;
            } else {
                this.val = value;
            }
        }
    }

    public void setDomain(SetValue dom) {
        this.domSize = dom.card();
        int maxe = dom.maxElem() + 1;
        if (this.domSize < maxe) {
            this.mapDomain = true;
            this.val = this.valScratch;
            if (this.mapRange) {
                this.domResult = this.domScratch;
                this.ranSource = this.domScratch;
            } else {
                this.domResult = this.result;
            }
            this.domMap.init();
            int i = 0;
            int j = 0;
            while (i < maxe) {
                if (dom.hasElement(i)) {
                    this.domMap.addMapping(i, j);
                    ++j;
                }
                ++i;
            }
        } else if (this.mapDomain) {
            this.mapDomain = false;
            if (this.mapRange) {
                this.ranSource = this.val;
            } else {
                this.val = this.result;
            }
        }
        this.computeMax();
    }

    public void setRange(SetValue ran) {
        this.ranSize = ran.card();
        int maxe = ran.maxElem() + 1;
        if (this.ranSize < maxe) {
            this.mapRange = true;
            this.val = this.valScratch;
            if (this.mapDomain) {
                this.ranSource = this.domScratch;
                this.domResult = this.domScratch;
            } else {
                this.ranSource = this.val;
            }
            this.ranMap.init();
            int i = 0;
            int j = 0;
            while (i < maxe) {
                if (ran.hasElement(i)) {
                    this.ranMap.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        } else if (this.mapRange) {
            this.mapRange = false;
            if (this.mapDomain) {
                this.domResult = this.result;
            } else {
                this.val = this.result;
            }
        }
        this.computeMax();
    }

    public double pctCompleted() {
        if (this.maxIndex == 0) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex == 0) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }

    private void computeMax() {
        this.maxIndex = (int)Generator.pow(this.ranSize + 1, this.domSize);
    }
}

