/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.engine.ValueError;
import ladybug.parse.RelationType;
import ladybug.parse.SetType;
import ladybug.parse.Variable;
import ladybug.selenum.Coloring;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Generator;

public class FuncBndGenerator
extends Generator
implements FunctionGenerator {
    private FunctionValue val;
    private boolean initialized;
    private boolean anyElements;
    private boolean isInjective;
    private long maxIndex;
    private int domSize;
    private SetValue domSet;
    private SetValue domEnum;
    private SetValue reqDom;
    private int ranSize;
    private SetValue ranSet;
    private SetValue ranEnum;
    private SetValue reqRan;
    private FunctionValue genValue;
    private FunctionValue req;
    private SetValue rForb;
    private SetValue dForb;
    private SetValue dForb2;
    private SetValue rForb2;
    private FunctionGenerator gen;

    public FuncBndGenerator(FunctionValue value, Variable var, Scope scope, FunctionGenerator gen2, SetValue domForbidden, SetValue ranForbidden, FunctionValue required) {
        super(var, var.getType());
        RelationType rt = (RelationType)var.getType();
        this.isInjective = rt.isInjection();
        this.dForb = domForbidden;
        this.rForb = ranForbidden;
        this.req = required;
        this.gen = gen2;
        this.initialized = false;
        this.domSize = (int)rt.domain().numValues(scope);
        this.domSet = new SetValue(new SetType(rt.domain()), this.domSize);
        this.domSet.fullSet();
        this.domEnum = new SetValue(new SetType(rt.domain()), this.domSize);
        this.ranSize = (int)rt.range().numValues(scope);
        this.ranSet = new SetValue(new SetType(rt.range()), this.ranSize);
        this.ranSet.fullSet();
        this.ranEnum = new SetValue(new SetType(rt.range()), this.ranSize);
        if (required != null) {
            this.genValue = new FunctionValue(new RelationType(rt.domain(), rt.range()), scope);
            this.val = value;
            this.reqDom = new SetValue(new SetType(rt.domain()), this.domSize);
            if (domForbidden != null) {
                this.dForb2 = new SetValue(new SetType(rt.domain()), this.domSize);
            }
            if (this.isInjective) {
                this.reqRan = new SetValue(new SetType(rt.range()), this.ranSize);
                if (ranForbidden != null) {
                    this.rForb2 = new SetValue(new SetType(rt.range()), this.ranSize);
                }
            } else {
                this.rForb2 = this.rForb;
            }
        } else {
            this.val = this.genValue = value;
            this.dForb2 = this.dForb;
            this.rForb2 = this.rForb;
        }
        this.gen.setValue(this.genValue);
        this.setTypeGenerated(gen2.typeGenerated());
        this.maxIndex = this.gen.totalValues();
    }

    public void setColoring(Coloring c) {
        super.setColoring(c);
    }

    public void setValue(FunctionValue value) {
        if (this.req == null) {
            this.genValue = value;
            this.gen.setValue(value);
        }
        this.val = value;
    }

    public void setDomain(SetValue dom) {
        this.domSet = dom;
        this.domSize = dom.maxElem() + 1;
        this.reset();
    }

    public void setRange(SetValue ran) {
        this.ranSet = ran;
        this.ranSize = ran.maxElem() + 1;
        this.reset();
    }

    public void reset() {
        this.initialized = false;
        this.gen.reset();
    }

    public void terminate() {
        this.gen.terminate();
    }

    public boolean hasMoreElements() {
        if (!this.initialized) {
            this.initializeBounds();
        }
        if (!this.anyElements) {
            return false;
        }
        return this.gen.hasMoreElements();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextFunction();
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (!this.initialized) {
            this.initializeBounds();
        }
        if (!this.anyElements) {
            throw new NoSuchElementException();
        }
        this.gen.nextFunction();
        if (this.req != null) {
            try {
                this.genValue.union(this.req, this.val);
            }
            catch (ValueError valueError) {
                return null;
            }
        }
        if (this._coloring != null) {
            this._coloring.updateColoring(this.val);
        }
        return this.val;
    }

    public double pctCompleted() {
        return this.gen.pctCompleted();
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        return this.gen.totalGenValues();
    }

    public long valuesGend() {
        return this.gen.valuesGend();
    }

    private void initializeBounds() {
        this.initialized = true;
        if (this.dForb != null) {
            if (this.req != null) {
                this.req.domain(this.reqDom);
                this.reqDom.intersect(this.dForb, this.domEnum);
                if (this.domEnum.card() > 0) {
                    this.anyElements = false;
                    return;
                }
                this.reqDom.union(this.dForb, this.dForb2);
            }
            this.domSet.diff(this.dForb2, this.domEnum);
            this.gen.setDomain(this.domEnum);
        } else if (this.req != null) {
            this.req.domain(this.reqDom);
            this.domSet.diff(this.reqDom, this.domEnum);
            this.gen.setDomain(this.domEnum);
        }
        if (this.rForb != null) {
            if (this.isInjective && this.req != null) {
                this.req.range(this.reqRan);
                this.reqRan.intersect(this.rForb, this.ranEnum);
                if (this.ranEnum.card() > 0) {
                    this.anyElements = false;
                    return;
                }
                this.reqRan.union(this.rForb, this.rForb2);
            }
            this.ranSet.diff(this.rForb2, this.ranEnum);
            this.gen.setRange(this.ranEnum);
        } else if (this.isInjective && this.req != null) {
            this.req.range(this.reqRan);
            this.ranSet.diff(this.reqRan, this.ranEnum);
            this.gen.setRange(this.ranEnum);
        }
        this.anyElements = true;
        this.gen.reset();
    }
}

