/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ladybug.engine.BadPeerClass;
import ladybug.engine.DerivedVars;
import ladybug.engine.EnumVars;
import ladybug.engine.FormulaSolver;
import ladybug.engine.Scope;
import ladybug.engine.Value;
import ladybug.engine.VarOrder;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;
import ladybug.parse.FormulaList;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;
import ladybug.parse.TermList;
import ladybug.parse.TermSet;
import ladybug.parse.Type;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.selenum.BoundedGenInfo;
import ladybug.selenum.Computation;
import ladybug.selenum.Generator;
import ladybug.selenum.SelEnumSolver;
import ladybug.selenum.TermCompiler;
import ladybug.selenum.Tester;
import ladybug.selenum.VariableSet;

public class ExecEnv {
    long[] valuesGenerated;
    long[] casesGenerated;
    private Generator[] _generators;
    private Generator[] _baseGenerators;
    private Tester[] _testers;
    private Computation[] _comps;
    private SelEnumSolver solver;
    private EnumVars enums;
    private DerivedVars derived;
    private TermSet comps;
    private Scope scope;
    private Value[] values;
    private VariableSet[] depends;
    private Computation constants;
    private VariableList genBounds;
    private Hashtable derivedVarSets;
    private Hashtable derivedValues;
    private Vector termsComputed;
    private String linesep = System.getProperty("line.separator");

    ExecEnv(SelEnumSolver solvr) {
        if (this.linesep == null) {
            this.linesep = "\n";
        }
        this.solver = solvr;
        this.enums = solvr.getFormulaSolver().getEnumVars();
        this.derived = solvr.getFormulaSolver().getDerivedVars();
        this.derivedVarSets = new Hashtable();
        this.derivedValues = new Hashtable();
        this.comps = new TermSet();
        this.scope = solvr.getFormulaSolver().getParent().getScope();
        this._generators = new Generator[this.enums.numVars()];
        this._baseGenerators = new Generator[this.enums.numVars()];
        this._comps = new Computation[this.enums.numVars()];
        this._testers = new Tester[this.enums.numVars()];
        this.valuesGenerated = new long[this.enums.numVars()];
        this.casesGenerated = new long[this.enums.numVars()];
        this.genBounds = new VariableList();
        this.constants = null;
        this.termsComputed = new Vector();
        this.values = new Value[this.enums.numVars()];
        int i = 0;
        while (i < this.enums.numVars()) {
            Variable v = this.enums.findVar(i);
            Type ty = v.getType();
            this.values[i] = Value.createValue(ty, this.scope);
            this.values[i].setDescr(v.toString());
            ++i;
        }
        this.depends = new VariableSet[this.enums.numVars()];
        i = 0;
        while (i < this.enums.numVars()) {
            this.depends[i] = new VariableSet(this);
            ++i;
        }
    }

    void reset() {
        int i = 0;
        while (i < this.enums.numVars()) {
            this._generators[i].reset();
            this.valuesGenerated[i] = 0L;
            this.casesGenerated[i] = 0L;
            ++i;
        }
    }

    SelEnumSolver solver() {
        return this.solver;
    }

    Computation termValue(TermCompiler t) {
        if (this.comps.contains(t.getSource())) {
            return (Computation)this.comps.tag(t.getSource());
        }
        Computation comp = t.compile(this);
        this.comps.putTerm(t.getSource(), comp);
        int index = comp.highestIndex();
        this.addComputation(comp, index);
        this.termsComputed.addElement(t);
        if (index >= 0) {
            this.depends[index].unionInPlace(this.varSet(t.getSource()));
            this.depends[index].removeIndexInPlace(index);
        }
        return comp;
    }

    DerivedVars getDerivedVars() {
        return this.derived;
    }

    EnumVars getEnumVars() {
        return this.enums;
    }

    Scope getScope() {
        return this.scope;
    }

    VariableList getGenBounds() {
        return this.genBounds;
    }

    void setVarOrder(FormulaSolver fs, VarOrder ordering) {
        int num = this.enums.numVars();
        Value[] newValues = new Value[num];
        Generator[] newGenerators = new Generator[num];
        Tester[] newTesters = new Tester[num];
        Computation[] newComps = new Computation[num];
        VariableSet[] newDepends = new VariableSet[num];
        int i = 0;
        while (i < num) {
            Variable v = this.enums.findVar(i);
            int ix = ordering.indexOf(v);
            newValues[ix] = this.values[i];
            newGenerators[ix] = this._generators[i];
            newTesters[ix] = this._testers[i];
            newComps[ix] = this._comps[i];
            newDepends[ix] = this.depends[i];
            ++i;
        }
        this.depends = newDepends;
        this._comps = newComps;
        this._testers = newTesters;
        this._generators = newGenerators;
        this.values = newValues;
        fs.setVarOrder(ordering);
    }

    Value getVarValue(Variable var) {
        if (this.enums.isEnumerated(var)) {
            int i = this.enums.findPosition(var);
            return this.values[i];
        }
        if (this.derived.isDerived(var)) {
            if (this.derivedValues.containsKey(var)) {
                return (Value)this.derivedValues.get(var);
            }
            Term t = this.derived.findEquiv(var);
            TermCompiler tc = null;
            try {
                tc = (TermCompiler)((Object)t.createPeer(this.solver.getPeerTable()));
            }
            catch (BadPeerClass badPeerClass) {
                return null;
            }
            Computation comp = this.termValue(tc);
            Value v = comp.getValue();
            int ix = this.varIndex(var);
            if (!(ix >= 0 && v == this.values[ix] || this.derivedValues.contains(v))) {
                v.setDescr(var.toString());
            }
            this.derivedValues.put(var, v);
            return v;
        }
        return null;
    }

    int varIndex(Variable var) {
        if (this.enums.isEnumerated(var)) {
            return this.enums.findPosition(var);
        }
        if (this.derived.isDerived(var)) {
            VariableSet vset = this.varSet(var);
            return vset.highestIndex();
        }
        return 0;
    }

    VariableSet varSet(Variable var) {
        if (this.enums.isEnumerated(var)) {
            return new VariableSet(this, this.enums.findPosition(var));
        }
        if (this.derived.isDerived(var)) {
            if (this.derivedVarSets.containsKey(var)) {
                return (VariableSet)this.derivedVarSets.get(var);
            }
            Term t = this.derived.findEquiv(var);
            VariableList vl = t.vars();
            VariableSet vset = new VariableSet(this);
            VarEnumeration e = vl.elements();
            while (e.hasMoreElements()) {
                Variable v = e.nextVar();
                vset.unionInPlace(this.varSet(v));
            }
            this.derivedVarSets.put(var, vset);
            return vset;
        }
        return null;
    }

    VariableSet varSet(Term term) {
        VariableList vars = term.vars();
        VariableSet vs = new VariableSet(this);
        VarEnumeration e = vars.elements();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            vs.unionInPlace(this.varSet(v));
        }
        FormulaList constrains = term.constraints();
        FormulaEnumeration fe = constrains.elements();
        while (fe.hasMoreElements()) {
            Formula f = fe.nextFormula();
            vars = f.vars(null);
            e = vars.elements();
            while (e.hasMoreElements()) {
                vs.unionInPlace(this.varSet(e.nextVar()));
            }
        }
        return vs;
    }

    int varIndex(Term term) {
        VariableList vars = term.vars();
        int highest = -1;
        VarEnumeration e = vars.elements();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            if (this.varIndex(v) <= highest) continue;
            highest = this.varIndex(v);
        }
        return highest;
    }

    int varIndex(Formula f) {
        VariableList vars = f.vars(null);
        int highest = -1;
        VarEnumeration e = vars.elements();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            if (this.varIndex(v) <= highest) continue;
            highest = this.varIndex(v);
        }
        return highest;
    }

    boolean valueForVar(Value val) {
        if (this.derivedValues.contains(val)) {
            return true;
        }
        int i = 0;
        while (i < this.enums.numVars()) {
            if (this.values[i] == val) {
                return true;
            }
            ++i;
        }
        return false;
    }

    VariableSet[] getDepends() {
        return this.depends;
    }

    public String dumpTranslation() {
        String s = "Translation for " + this.solver.getController().getName() + this.linesep;
        s = String.valueOf(s) + this.dumpEnums() + this.linesep;
        s = String.valueOf(s) + this.linesep + this.solver.getController().dumpDerived() + this.linesep;
        s = String.valueOf(s) + this.linesep + this.dumpGens() + this.linesep;
        s = String.valueOf(s) + this.linesep + this.dumpGenBounds() + this.linesep;
        s = String.valueOf(s) + this.linesep + this.dumpTerms() + this.linesep;
        s = String.valueOf(s) + this.linesep + this.dumpComps() + this.linesep;
        s = String.valueOf(s) + this.linesep + this.dumpTests() + this.linesep;
        return s;
    }

    String dumpEnums() {
        String s = "Enumerated Variables" + this.linesep + this.linesep;
        int index = 0;
        VarEnumeration e = this.enums.elements();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            s = String.valueOf(s) + String.valueOf(index) + ") " + v.toString() + "\t\t: " + v.getType().toString() + this.linesep;
            ++index;
        }
        return s;
    }

    String dumpGenBounds() {
        String s = "Bounded Generation Bounds" + this.linesep + this.linesep;
        VarEnumeration e = this.genBounds.elements();
        while (e.hasMoreElements()) {
            Term t;
            TermEnumeration et;
            Variable v = e.nextVar();
            BoundedGenInfo bgi = (BoundedGenInfo)this.genBounds.tag(v);
            int index = this.varIndex(v);
            s = String.valueOf(s) + v.toString() + " : " + v.getType().toString() + this.depends[index].toString() + this.linesep;
            TermList tl = bgi.getDRequired();
            if (tl != null) {
                et = tl.elements();
                s = String.valueOf(s) + "\tMust include:" + this.linesep;
                while (et.hasMoreElements()) {
                    t = et.nextTerm();
                    s = String.valueOf(s) + "\t  " + t.toString() + this.linesep;
                }
            }
            if ((tl = bgi.getDForbidden()) != null) {
                et = tl.elements();
                s = String.valueOf(s) + "\tDomain must exclude:" + this.linesep;
                while (et.hasMoreElements()) {
                    t = et.nextTerm();
                    s = String.valueOf(s) + "\t  " + t.toString() + this.linesep;
                }
            }
            if ((tl = bgi.getRForbidden()) == null) continue;
            et = tl.elements();
            s = String.valueOf(s) + "\tRange must exclude:" + this.linesep;
            while (et.hasMoreElements()) {
                t = et.nextTerm();
                s = String.valueOf(s) + "\t  " + t.toString() + this.linesep;
            }
        }
        return s;
    }

    String dumpGens() {
        String s = "Generators:" + this.linesep + this.linesep;
        int i = 0;
        while (i < this.enums.numVars()) {
            Generator gen = this._generators[i];
            Variable v = this.enums.findVar(i);
            s = String.valueOf(s) + "[" + String.valueOf(i) + "] (" + v.toString() + ": " + v.getType().toString() + ") ";
            s = String.valueOf(s) + gen.getClass().getName();
            if (gen != this._baseGenerators[i]) {
                s = String.valueOf(s) + " (" + this._baseGenerators[i].getClass().getName() + ")";
            }
            s = String.valueOf(s) + " " + String.valueOf(gen.totalGenValues()) + "/" + String.valueOf(gen.totalValues()) + this.linesep;
            ++i;
        }
        return s;
    }

    String dumpTerms() {
        String s = "Terms Computed:" + this.linesep + this.linesep;
        Enumeration e = this.termsComputed.elements();
        while (e.hasMoreElements()) {
            TermCompiler tc = (TermCompiler)e.nextElement();
            Computation c = (Computation)this.comps.tag(tc.getSource());
            Value v = c.getValue();
            if (this.valueForVar(v)) continue;
            s = String.valueOf(s) + v.getDescr() + ": " + v.getType().toString() + " = " + tc.toString() + this.linesep;
        }
        return s;
    }

    String dumpComps() {
        String s = "Computations" + this.linesep + this.linesep;
        if (this.constants != null) {
            s = String.valueOf(s) + "[constants] " + this.linesep + this.constants.toString();
        }
        int i = 0;
        while (i < this.enums.numVars()) {
            Computation comp = this._comps[i];
            Variable v = this.enums.findVar(i);
            s = String.valueOf(s) + "[" + String.valueOf(i) + "] (" + v.toString() + ")" + this.linesep;
            if (comp != null) {
                s = String.valueOf(s) + comp.toString();
            }
            ++i;
        }
        return s;
    }

    String dumpTests() {
        String s = "Tests" + this.linesep + this.linesep;
        int i = 0;
        while (i < this.enums.numVars()) {
            Tester test = this._testers[i];
            Variable v = this.enums.findVar(i);
            s = String.valueOf(s) + "[" + String.valueOf(i) + "] (" + v.toString() + ")";
            s = String.valueOf(s) + " [-" + this.depends[i].toString() + "]" + this.linesep;
            if (test != null) {
                s = String.valueOf(s) + test.toString();
            }
            ++i;
        }
        return s;
    }

    String dumpAverages() {
        String s = "Average values generated" + this.linesep + this.linesep;
        int i = 0;
        while (i < this.enums.numVars()) {
            Variable v = this.enums.findVar(i);
            s = String.valueOf(s) + v.getName() + " : ";
            s = i == 0 ? String.valueOf(s) + String.valueOf(this.valuesGenerated[i]) : String.valueOf(s) + String.valueOf((double)this.valuesGenerated[i] / (double)this.casesGenerated[i - 1]);
            s = String.valueOf(s) + " (" + String.valueOf(this.valuesGenerated[i]) + " : " + String.valueOf(this.casesGenerated[i]) + ")" + this.linesep;
            ++i;
        }
        return s;
    }

    Generator[] generators() {
        return this._generators;
    }

    Generator[] baseGenerators() {
        return this._baseGenerators;
    }

    void setGenerator(Generator gen, int i) {
        this._generators[i] = gen;
    }

    Computation getConstantComps() {
        return this.constants;
    }

    Computation[] computations() {
        return this._comps;
    }

    void addComputation(Computation c, int i) {
        if (i == -1) {
            if (this.constants == null) {
                this.constants = c;
            } else {
                this.constants.link(c);
            }
            return;
        }
        if (this._comps[i] == null) {
            this._comps[i] = c;
        } else {
            this._comps[i].link(c);
        }
    }

    Tester[] testers() {
        return this._testers;
    }

    void setTester(Tester test, int i) {
        this._testers[i] = test;
    }
}

