/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import ladybug.engine.Scope;
import ladybug.engine.Value;
import ladybug.engine.ValueError;
import ladybug.parse.RelationType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.AddElem;
import ladybug.selenum.AddFuncMapping;
import ladybug.selenum.AddRelMapping;
import ladybug.selenum.CompCommand;
import ladybug.selenum.ExecEnv;
import ladybug.selenum.FuncAppl;
import ladybug.selenum.FuncCard;
import ladybug.selenum.FuncCast;
import ladybug.selenum.FuncClear;
import ladybug.selenum.FuncClosure;
import ladybug.selenum.FuncDom;
import ladybug.selenum.FuncDomRestr;
import ladybug.selenum.FuncFuncCompose;
import ladybug.selenum.FuncFuncDiff;
import ladybug.selenum.FuncFuncInter;
import ladybug.selenum.FuncFuncOverride;
import ladybug.selenum.FuncFuncTranspose;
import ladybug.selenum.FuncFuncUnion;
import ladybug.selenum.FuncHead;
import ladybug.selenum.FuncImage;
import ladybug.selenum.FuncNegDomRestr;
import ladybug.selenum.FuncNegRanRestr;
import ladybug.selenum.FuncRClosure;
import ladybug.selenum.FuncRan;
import ladybug.selenum.FuncRanRestr;
import ladybug.selenum.FuncRelCompose;
import ladybug.selenum.FuncRelDiff;
import ladybug.selenum.FuncRelInter;
import ladybug.selenum.FuncRelOverride;
import ladybug.selenum.FuncRelTranspose;
import ladybug.selenum.FuncTail;
import ladybug.selenum.IntMinus;
import ladybug.selenum.IntPlus;
import ladybug.selenum.InvalidAssignment;
import ladybug.selenum.RelAppl;
import ladybug.selenum.RelCard;
import ladybug.selenum.RelClear;
import ladybug.selenum.RelClosure;
import ladybug.selenum.RelDom;
import ladybug.selenum.RelDomRestr;
import ladybug.selenum.RelFuncCompose;
import ladybug.selenum.RelFuncDiff;
import ladybug.selenum.RelFuncOverride;
import ladybug.selenum.RelFuncTranspose;
import ladybug.selenum.RelFuncUnion;
import ladybug.selenum.RelHead;
import ladybug.selenum.RelImage;
import ladybug.selenum.RelNegDomRestr;
import ladybug.selenum.RelNegRanRestr;
import ladybug.selenum.RelRClosure;
import ladybug.selenum.RelRan;
import ladybug.selenum.RelRanRestr;
import ladybug.selenum.RelRelCompose;
import ladybug.selenum.RelRelDiff;
import ladybug.selenum.RelRelInter;
import ladybug.selenum.RelRelOverride;
import ladybug.selenum.RelRelTranspose;
import ladybug.selenum.RelRelUnion;
import ladybug.selenum.RelTail;
import ladybug.selenum.SetCard;
import ladybug.selenum.SetClear;
import ladybug.selenum.SetDiff;
import ladybug.selenum.SetInter;
import ladybug.selenum.SetUnion;

public class Computation {
    static String linesep;
    private Value val;
    private ExecEnv _env;
    private CompCommand firstComp;
    private CompCommand lastComp;
    private int highestIx;

    Computation(ExecEnv env, Type ty, Scope scope) {
        if (linesep == null && (linesep = System.getProperty("line.separator")) == null) {
            linesep = "\n";
        }
        this._env = env;
        this.val = Value.createValue(ty, scope);
        this.firstComp = null;
        this.lastComp = null;
        this.highestIx = -1;
    }

    Computation(ExecEnv env, Value value) {
        if (linesep == null && (linesep = System.getProperty("line.separator")) == null) {
            linesep = "\n";
        }
        this._env = env;
        this.val = value;
        this.firstComp = null;
        this.lastComp = null;
        this.highestIx = -1;
    }

    Computation(ExecEnv env, Variable var) {
        if (linesep == null && (linesep = System.getProperty("line.separator")) == null) {
            linesep = "\n";
        }
        this._env = env;
        this.val = env.getVarValue(var);
        this.firstComp = null;
        this.lastComp = null;
        this.highestIx = env.varIndex(var);
    }

    int highestIndex() {
        return this.highestIx;
    }

    Value getValue() {
        return this.val;
    }

    void link(Computation c) {
        if (c.firstComp != null) {
            if (this.firstComp == null) {
                this.firstComp = c.firstComp;
            } else {
                this.lastComp.next = c.firstComp;
            }
            this.lastComp = c.lastComp;
            if (c.highestIx > this.highestIx) {
                this.highestIx = c.highestIx;
            }
        }
    }

    void evaluate() throws InvalidAssignment {
        try {
            CompCommand comp = this.firstComp;
            while (comp != null) {
                comp.evaluate();
                comp = comp.next;
            }
        }
        catch (ValueError ve) {
            throw new InvalidAssignment(ve.getMessage());
        }
    }

    public String toString() {
        String s = "";
        CompCommand comp = this.firstComp;
        while (comp != null) {
            s = String.valueOf(s) + comp.toString();
            comp = comp.next;
        }
        return s;
    }

    private void addComp(CompCommand comp) {
        if (this.firstComp == null) {
            this.firstComp = comp;
            this.lastComp = comp;
        } else {
            this.lastComp.next = comp;
            this.lastComp = comp;
        }
    }

    void addMapping(Computation from, Computation to, String comment) {
        RelationType rtype = (RelationType)this.val.getType();
        if (from.highestIndex() > this.highestIx) {
            this.highestIx = from.highestIndex();
        }
        if (to.highestIndex() > this.highestIx) {
            this.highestIx = to.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new AddFuncMapping(this.val, from.getValue(), to.getValue(), comment));
        } else {
            this.addComp(new AddRelMapping(this.val, from.getValue(), to.getValue(), comment));
        }
    }

    void doCompose(Computation l, Computation r, String comment) {
        RelationType rtypel = (RelationType)l.getValue().getType();
        RelationType rtyper = (RelationType)r.getValue().getType();
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        if (rtypel.isFunction()) {
            if (rtyper.isFunction()) {
                this.addComp(new FuncFuncCompose(this.val, l.getValue(), r.getValue(), comment));
            } else {
                this.addComp(new FuncRelCompose(this.val, l.getValue(), r.getValue(), comment));
            }
        } else if (rtyper.isFunction()) {
            this.addComp(new RelFuncCompose(this.val, l.getValue(), r.getValue(), comment));
        } else {
            this.addComp(new RelRelCompose(this.val, l.getValue(), r.getValue(), comment));
        }
    }

    void doClosure(Computation ch, String comment) {
        RelationType rtype = (RelationType)ch.getValue().getType();
        if (ch.highestIndex() > this.highestIx) {
            this.highestIx = ch.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncClosure(this.val, ch.getValue(), comment));
        } else {
            this.addComp(new RelClosure(this.val, ch.getValue(), comment));
        }
    }

    void doRelClear(String comment) {
        RelationType rtype = (RelationType)this.val.getType();
        if (rtype.isFunction()) {
            this.addComp(new FuncClear(this.val, comment));
        } else {
            this.addComp(new RelClear(this.val, comment));
        }
    }

    void doReflClosure(Computation ch, String comment) {
        RelationType rtype = (RelationType)ch.getValue().getType();
        if (ch.highestIndex() > this.highestIx) {
            this.highestIx = ch.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncRClosure(this.val, ch.getValue(), comment));
        } else {
            this.addComp(new RelRClosure(this.val, ch.getValue(), comment));
        }
    }

    void doTranspose(Computation ch, String comment) {
        RelationType rtype = (RelationType)this.getValue().getType();
        RelationType rtypech = (RelationType)ch.getValue().getType();
        if (ch.highestIndex() > this.highestIx) {
            this.highestIx = ch.highestIndex();
        }
        if (rtypech.isFunction()) {
            if (rtype.isFunction()) {
                this.addComp(new FuncFuncTranspose(this.val, ch.getValue(), comment));
            } else {
                this.addComp(new FuncRelTranspose(this.val, ch.getValue(), comment));
            }
        } else if (rtype.isFunction()) {
            this.addComp(new RelFuncTranspose(this.val, ch.getValue(), comment));
        } else {
            this.addComp(new RelRelTranspose(this.val, ch.getValue(), comment));
        }
    }

    void doOverride(Computation l, Computation r, String comment) {
        RelationType rtypel = (RelationType)l.getValue().getType();
        RelationType rtyper = (RelationType)r.getValue().getType();
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        if (rtypel.isFunction()) {
            if (rtyper.isFunction()) {
                this.addComp(new FuncFuncOverride(this.val, l.getValue(), r.getValue(), comment));
            } else {
                this.addComp(new FuncRelOverride(this.val, l.getValue(), r.getValue(), comment));
            }
        } else if (rtyper.isFunction()) {
            this.addComp(new RelFuncOverride(this.val, l.getValue(), r.getValue(), comment));
        } else {
            this.addComp(new RelRelOverride(this.val, l.getValue(), r.getValue(), comment));
        }
    }

    void doRelUnion(Computation l, Computation r, String comment) {
        RelationType rtypel = (RelationType)l.getValue().getType();
        RelationType rtyper = (RelationType)r.getValue().getType();
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        if (rtypel.isFunction()) {
            if (rtyper.isFunction()) {
                this.addComp(new FuncFuncUnion(this.val, l.getValue(), r.getValue(), comment));
            } else {
                this.addComp(new RelFuncUnion(this.val, r.getValue(), l.getValue(), comment));
            }
        } else if (rtyper.isFunction()) {
            this.addComp(new RelFuncUnion(this.val, l.getValue(), r.getValue(), comment));
        } else {
            this.addComp(new RelRelUnion(this.val, l.getValue(), r.getValue(), comment));
        }
    }

    void doRelInter(Computation l, Computation r, String comment) {
        RelationType rtypel = (RelationType)l.getValue().getType();
        RelationType rtyper = (RelationType)r.getValue().getType();
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        if (rtypel.isFunction()) {
            if (rtyper.isFunction()) {
                this.addComp(new FuncFuncInter(this.val, l.getValue(), r.getValue(), comment));
            } else {
                this.addComp(new FuncRelInter(this.val, l.getValue(), r.getValue(), comment));
            }
        } else if (rtyper.isFunction()) {
            this.addComp(new FuncRelInter(this.val, r.getValue(), l.getValue(), comment));
        } else {
            this.addComp(new RelRelInter(this.val, l.getValue(), r.getValue(), comment));
        }
    }

    void doRelDiff(Computation l, Computation r, String comment) {
        RelationType rtypel = (RelationType)l.getValue().getType();
        RelationType rtyper = (RelationType)r.getValue().getType();
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        if (rtypel.isFunction()) {
            if (rtyper.isFunction()) {
                this.addComp(new FuncFuncDiff(this.val, l.getValue(), r.getValue(), comment));
            } else {
                this.addComp(new FuncRelDiff(this.val, l.getValue(), r.getValue(), comment));
            }
        } else if (rtyper.isFunction()) {
            this.addComp(new RelFuncDiff(this.val, l.getValue(), r.getValue(), comment));
        } else {
            this.addComp(new RelRelDiff(this.val, l.getValue(), r.getValue(), comment));
        }
    }

    void doDomRestr(Computation l, Computation r, String comment) {
        RelationType rtype = (RelationType)l.getValue().getType();
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncDomRestr(this.val, l.getValue(), r.getValue(), comment));
        } else {
            this.addComp(new RelDomRestr(this.val, l.getValue(), r.getValue(), comment));
        }
    }

    void doNegDomRestr(Computation l, Computation r, String comment) {
        RelationType rtype = (RelationType)l.getValue().getType();
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncNegDomRestr(this.val, l.getValue(), r.getValue(), comment));
        } else {
            this.addComp(new RelNegDomRestr(this.val, l.getValue(), r.getValue(), comment));
        }
    }

    void doRanRestr(Computation l, Computation r, String comment) {
        RelationType rtype = (RelationType)l.getValue().getType();
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncRanRestr(this.val, l.getValue(), r.getValue(), comment));
        } else {
            this.addComp(new RelRanRestr(this.val, l.getValue(), r.getValue(), comment));
        }
    }

    void doNegRanRestr(Computation l, Computation r, String comment) {
        RelationType rtype;
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        if ((rtype = (RelationType)l.getValue().getType()).isFunction()) {
            this.addComp(new FuncNegRanRestr(this.val, l.getValue(), r.getValue(), comment));
        } else {
            this.addComp(new RelNegRanRestr(this.val, l.getValue(), r.getValue(), comment));
        }
    }

    void doDomain(Computation ch, String comment) {
        RelationType rtype = (RelationType)ch.getValue().getType();
        if (ch.highestIndex() > this.highestIx) {
            this.highestIx = ch.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncDom(this.val, ch.getValue(), comment));
        } else {
            this.addComp(new RelDom(this.val, ch.getValue(), comment));
        }
    }

    void doRange(Computation ch, String comment) {
        RelationType rtype = (RelationType)ch.getValue().getType();
        if (ch.highestIndex() > this.highestIx) {
            this.highestIx = ch.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncRan(this.val, ch.getValue(), comment));
        } else {
            this.addComp(new RelRan(this.val, ch.getValue(), comment));
        }
    }

    void doHead(Computation ch, String comment) {
        RelationType rtype = (RelationType)ch.getValue().getType();
        if (ch.highestIndex() > this.highestIx) {
            this.highestIx = ch.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncHead(this.val, ch.getValue(), comment));
        } else {
            this.addComp(new RelHead(this.val, ch.getValue(), comment));
        }
    }

    void doTail(Computation ch, String comment) {
        RelationType rtype = (RelationType)ch.getValue().getType();
        if (ch.highestIndex() > this.highestIx) {
            this.highestIx = ch.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncTail(this.val, ch.getValue(), comment));
        } else {
            this.addComp(new RelTail(this.val, ch.getValue(), comment));
        }
    }

    void doFuncCast(Computation ch, String comment) {
        RelationType rtype = (RelationType)ch.getValue().getType();
        if (ch.highestIndex() > this.highestIx) {
            this.highestIx = ch.highestIndex();
        }
        if (!rtype.isFunction()) {
            this.addComp(new FuncCast(this.val, ch.getValue(), comment));
        } else {
            this.val = ch.getValue();
        }
    }

    void doRelCard(Computation ch, String comment) {
        RelationType rtype = (RelationType)ch.getValue().getType();
        if (ch.highestIndex() > this.highestIx) {
            this.highestIx = ch.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncCard(this.val, ch.getValue(), comment));
        } else {
            this.addComp(new RelCard(this.val, ch.getValue(), comment));
        }
    }

    void doRelImage(Computation l, Computation r, String comment) {
        RelationType rtype = (RelationType)l.getValue().getType();
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncImage(this.val, l.getValue(), r.getValue(), comment));
        } else {
            this.addComp(new RelImage(this.val, l.getValue(), r.getValue(), comment));
        }
    }

    void doFunAppl(Computation l, Computation r, String comment) {
        RelationType rtype = (RelationType)l.getValue().getType();
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        if (rtype.isFunction()) {
            this.addComp(new FuncAppl(this.val, l.getValue(), r.getValue(), comment));
        } else {
            this.addComp(new RelAppl(this.val, l.getValue(), r.getValue(), comment));
        }
    }

    void addElement(Computation elem, String comment) {
        if (elem.highestIndex() > this.highestIx) {
            this.highestIx = elem.highestIndex();
        }
        this.addComp(new AddElem(this.val, elem.getValue(), comment));
    }

    void doSetUnion(Computation l, Computation r, String comment) {
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        this.addComp(new SetUnion(this.val, l.getValue(), r.getValue(), comment));
    }

    void doSetInter(Computation l, Computation r, String comment) {
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        this.addComp(new SetInter(this.val, l.getValue(), r.getValue(), comment));
    }

    void doSetDiff(Computation l, Computation r, String comment) {
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        this.addComp(new SetDiff(this.val, l.getValue(), r.getValue(), comment));
    }

    void doSetCard(Computation ch, String comment) {
        if (ch.highestIndex() > this.highestIx) {
            this.highestIx = ch.highestIndex();
        }
        this.addComp(new SetCard(this.val, ch.getValue(), comment));
    }

    void doSetClear(String comment) {
        this.addComp(new SetClear(this.val, comment));
    }

    void doPlus(Computation l, Computation r, String comment) {
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        this.addComp(new IntPlus(this.val, l.getValue(), r.getValue(), comment));
    }

    void doMinus(Computation l, Computation r, String comment) {
        if (l.highestIndex() > this.highestIx) {
            this.highestIx = l.highestIndex();
        }
        if (r.highestIndex() > this.highestIx) {
            this.highestIx = r.highestIndex();
        }
        this.addComp(new IntMinus(this.val, l.getValue(), r.getValue(), comment));
    }
}

