/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ladybug.engine.BadPeerClass;
import ladybug.engine.DerivedVars;
import ladybug.engine.EnumVars;
import ladybug.engine.FactSet;
import ladybug.engine.FormulaPattern;
import ladybug.engine.FormulaSolver;
import ladybug.engine.FunctionValue;
import ladybug.engine.LadyBug;
import ladybug.engine.RelationValue;
import ladybug.engine.RuleEnumeration;
import ladybug.engine.RuleSuite;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.engine.Translator;
import ladybug.engine.Value;
import ladybug.parse.AssocTerm;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;
import ladybug.parse.FormulaList;
import ladybug.parse.Predicate;
import ladybug.parse.RelationType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.UnaryOperator;
import ladybug.parse.UnaryTerm;
import ladybug.parse.VarEnumeration;
import ladybug.parse.VarTerm;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.selenum.AtomicColoring;
import ladybug.selenum.BoundedGenInfo;
import ladybug.selenum.BoundedGenRule;
import ladybug.selenum.ChainExhGenerator;
import ladybug.selenum.ChainIsoGenerator;
import ladybug.selenum.ChainTotExhGenerator;
import ladybug.selenum.Coloring;
import ladybug.selenum.Computation;
import ladybug.selenum.ExecEnv;
import ladybug.selenum.FormulaCompiler;
import ladybug.selenum.FuncBijExhGenerator;
import ladybug.selenum.FuncBndGenerator;
import ladybug.selenum.FuncExhGenerator;
import ladybug.selenum.FuncIsoGenerator;
import ladybug.selenum.FuncSameIsoGenerator;
import ladybug.selenum.FuncTotExhGenerator;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Generator;
import ladybug.selenum.OrderConstraint;
import ladybug.selenum.OrderConstraintList;
import ladybug.selenum.RelBndGenerator;
import ladybug.selenum.RelExhGenerator;
import ladybug.selenum.RelInjExhGenerator;
import ladybug.selenum.RelIsoGenerator;
import ladybug.selenum.RelationGenerator;
import ladybug.selenum.ScalarBndGenerator;
import ladybug.selenum.ScalarExhGenerator;
import ladybug.selenum.ScalarGenerator;
import ladybug.selenum.ScalarIsoGenerator;
import ladybug.selenum.SelEnumSolver;
import ladybug.selenum.SetBndGenerator;
import ladybug.selenum.SetExhGenerator;
import ladybug.selenum.SetGenerator;
import ladybug.selenum.SetIsoGenerator;
import ladybug.selenum.SimpleBGenRule;
import ladybug.selenum.TermCompiler;
import ladybug.selenum.Tester;
import ladybug.selenum.VariableSet;

public class Compiler
extends Translator {
    private SelEnumSolver _solver;
    private int numFacts;
    private int factsProcessed;
    private RuleSuite _opps;

    public Compiler(SelEnumSolver solver) {
        super(solver);
        this._solver = solver;
        this.numFacts = 1;
        this.factsProcessed = 0;
    }

    public void translate() {
        this._solver.reset();
        FormulaSolver fs = this._solver.getFormulaSolver();
        FactSet facts = fs.getFacts();
        if (this._solver.debugTimes) {
            fs.getParent().setStatus("Getting derived variables");
        }
        DerivedVars derived = fs.getDerivedVars();
        Hashtable peerTypes = this._solver.getPeerTable();
        ExecEnv env = this._solver.getEnv();
        VariableList bounded = env.getGenBounds();
        if (this._solver.debugTimes) {
            fs.getParent().setStatus("Getting enumerated variables");
        }
        EnumVars enums = env.getEnumVars();
        OrderConstraintList ocl = new OrderConstraintList();
        Scope scope = fs.getParent().getScope();
        facts = facts.copy();
        if (derived != null) {
            VarEnumeration dve = derived.derivedVars();
            while (dve.hasMoreElements()) {
                Variable dv = dve.nextVar();
                Term eq = derived.findEquiv(dv);
                FormulaList fl = eq.constraints();
                FormulaEnumeration fe = fl.elements();
                while (fe.hasMoreElements()) {
                    facts.addFact(fe.nextFormula());
                }
            }
        }
        this.numFacts = facts.size() + 4;
        this.factsProcessed = 1;
        if (this._solver.useSC && this._solver.constraintOrder) {
            this.numFacts += 3;
            if (this._solver.debugTimes) {
                fs.getParent().setStatus("Computing short circuiting ordering constraints");
            }
            ocl.merge(this.shortCircOrderings(env, facts, scope));
            ++this.factsProcessed;
        }
        if (this._solver.useBGen) {
            RuleSuite opps = this.getBoundedOpps(bounded);
            if (this._solver.debugTimes) {
                fs.getParent().setStatus("Computing bounded gen opportunities");
            }
            opps.close(facts);
            ++this.factsProcessed;
            if (this._solver.constraintOrder) {
                if (this._solver.debugTimes) {
                    fs.getParent().setStatus("Computing bounded gen ordering constraints");
                }
                ocl.merge(this.boundedGenOrderings(bounded, env, facts, scope));
                ++this.factsProcessed;
            }
        }
        if (this._solver.constraintOrder) {
            if (this._solver.debugTimes) {
                fs.getParent().setStatus("Computing optimal ordering");
            }
            env.setVarOrder(fs, ocl.computeOrdering(enums, derived, scope));
            ++this.factsProcessed;
        }
        this.resolveBounds(bounded, enums, facts, env);
        this.chooseGenerators(fs, env, bounded, facts);
        ++this.factsProcessed;
        if (this._solver.debugTimes) {
            fs.getParent().setStatus("Checking types");
        }
        this.checkEnums(facts, enums, env.generators());
        ++this.factsProcessed;
        this.checkDerived(facts, derived);
        ++this.factsProcessed;
        if (this._solver.debugTimes) {
            fs.getParent().setStatus("Compiling facts");
        }
        FormulaEnumeration e = facts.facts();
        Tester[] testers = env.testers();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            boolean wasTested = this.checkTested(f, facts, env, env.varIndex(f), new FormulaList());
            if (wasTested) {
                ++this.factsProcessed;
                continue;
            }
            try {
                FormulaCompiler fc = (FormulaCompiler)((Object)f.createPeer(peerTypes));
                Tester t = fc.compile(env);
                int index = t.highestIndex();
                if (index < 0) {
                    index = 0;
                }
                testers[index] = testers[index] == null ? t : testers[index].and(t);
            }
            catch (BadPeerClass bpc) {
                LadyBug.consoleMessage("Error in translation: " + bpc.getMessage());
            }
            ++this.factsProcessed;
        }
    }

    private void chooseGenerators(FormulaSolver fs, ExecEnv env, VariableList bounds, FactSet facts) {
        EnumVars enums = env.getEnumVars();
        VarEnumeration e = enums.elements();
        Generator[] generators = env.generators();
        Generator[] bgens = env.baseGenerators();
        Scope scope = fs.getParent().getScope();
        Simplifier simple = fs.getParent().getSimplifier();
        AtomicColoring ac = null;
        if (this._solver.debugTimes) {
            fs.getParent().setStatus("Choosing generators");
        }
        while (e.hasMoreElements()) {
            Generator gen;
            Variable v = e.nextVar();
            int index = enums.findPosition(v);
            AtomicColoring c = ac;
            if (env.solver().useIsoElim && c == null) {
                c = new AtomicColoring(v, enums, scope, null);
            }
            bgens[index] = gen = this.chooseBaseGenerator(env, v, facts, scope, c);
            if (bounds.contains(v)) {
                BoundedGenInfo bgi = (BoundedGenInfo)bounds.tag(v);
                gen = this.chooseBoundedGen(env, gen, v, bgi, index, scope, facts, simple);
            }
            if (env.solver().useIsoElim && e.hasMoreElements()) {
                ac = new AtomicColoring(v, enums, scope, ac);
                gen.setColoring(ac);
            }
            generators[index] = gen;
        }
    }

    private Generator chooseBaseGenerator(ExecEnv env, Variable v, FactSet facts, Scope scope, Coloring c) {
        Generator gen;
        Type ty = v.getType();
        Value val = env.getVarValue(v);
        if (ty.isScalarType()) {
            gen = env.solver().useIsoElim ? new ScalarIsoGenerator((ScalarValue)val, v, scope, c) : new ScalarExhGenerator((ScalarValue)val, v, scope);
        } else if (ty.isSet()) {
            gen = env.solver().useIsoElim ? new SetIsoGenerator((SetValue)val, v, scope, c) : new SetExhGenerator((SetValue)val, v, scope);
        } else {
            RelationType rt = (RelationType)ty;
            if (rt.isFunction()) {
                Predicate fact = new Predicate(UnaryOperator.findOperator(62), new VarTerm(v), SourceLoc.noLoc);
                if (rt.isChain() || facts.containsEquiv(fact)) {
                    if (env.solver().useIsoElim) {
                        facts.markTested(fact);
                        gen = new ChainIsoGenerator((FunctionValue)val, v, scope, c);
                    } else {
                        fact = new Predicate(UnaryOperator.totalOp(), new VarTerm(v), SourceLoc.noLoc);
                        if (facts.containsEquiv(fact)) {
                            gen = new ChainTotExhGenerator((FunctionValue)val, v, scope);
                            facts.markTested(fact);
                        } else {
                            gen = new ChainExhGenerator((FunctionValue)val, v, scope);
                        }
                    }
                } else {
                    fact = new Predicate(UnaryOperator.totalOp(), new VarTerm(v), SourceLoc.noLoc);
                    if (facts.containsEquiv(fact)) {
                        if (env.solver().useIsoElim) {
                            gen = rt.domain().equals(rt.range()) ? new FuncSameIsoGenerator((FunctionValue)val, v, scope, c) : new FuncIsoGenerator((FunctionValue)val, v, scope, c);
                        } else {
                            facts.markTested(fact);
                            fact = new Predicate(UnaryOperator.injOp(), new VarTerm(v), SourceLoc.noLoc);
                            if (facts.containsEquiv(fact)) {
                                facts.markTested(fact);
                                gen = new FuncBijExhGenerator((FunctionValue)val, v, scope);
                            } else {
                                gen = new FuncTotExhGenerator((FunctionValue)val, v, scope);
                            }
                        }
                    } else {
                        gen = env.solver().useIsoElim ? (rt.domain().equals(rt.range()) ? new FuncSameIsoGenerator((FunctionValue)val, v, scope, c) : new FuncIsoGenerator((FunctionValue)val, v, scope, c)) : new FuncExhGenerator((FunctionValue)val, v, scope);
                    }
                }
            } else if (env.solver().useIsoElim) {
                gen = rt.domain().equals(rt.range()) ? new RelIsoGenerator((RelationValue)val, v, scope, c) : new RelIsoGenerator((RelationValue)val, v, scope, c);
            } else {
                Predicate fact = new Predicate(UnaryOperator.injOp(), new VarTerm(v), SourceLoc.noLoc);
                if (facts.containsEquiv(fact)) {
                    gen = new RelInjExhGenerator((RelationValue)val, v, scope);
                    facts.markTested(fact);
                } else {
                    gen = new RelExhGenerator((RelationValue)val, v, scope);
                }
            }
        }
        return gen;
    }

    private Generator chooseBoundedGen(ExecEnv env, Generator gen, Variable v, BoundedGenInfo bgi, int index, Scope scope, FactSet facts, Simplifier simple) {
        Type ty = v.getType();
        Value val = env.getVarValue(v);
        VariableSet[] depends = env.getDepends();
        SelEnumSolver solver = env.solver();
        if (ty.isScalarType()) {
            Term unioned = null;
            TermList tl = bgi.getDForbidden();
            if (tl != null) {
                TermEnumeration et = tl.elements();
                boolean first = true;
                while (et.hasMoreElements()) {
                    Term t = et.nextTerm();
                    Formula covered = (Formula)tl.tag(t);
                    if (covered != null) {
                        facts.markTested(covered);
                    }
                    depends[index].unionInPlace(env.varSet(t));
                    if (first) {
                        first = false;
                        unioned = t;
                        continue;
                    }
                    unioned = new AssocTerm(unioned, t, BinaryOperator.findOperator(35));
                }
                try {
                    unioned = simple.simplifyTerm(unioned);
                    Computation c = env.termValue((TermCompiler)((Object)unioned.createPeer(solver.getPeerTable())));
                    SetValue dForbidden = (SetValue)c.getValue();
                    dForbidden.setDescr("BndGen-" + v.getName());
                    return new ScalarBndGenerator((ScalarValue)val, v, scope, (ScalarGenerator)((Object)gen), dForbidden);
                }
                catch (BadPeerClass badPeerClass) {}
            }
        } else {
            if (ty.isSet()) {
                SetValue dForbidden;
                SetValue sRequired;
                Computation c;
                Formula covered;
                Term t;
                TermEnumeration et;
                Term unioned = null;
                TermList tl = bgi.getDRequired();
                boolean first = true;
                if (tl != null) {
                    et = tl.elements();
                    while (et.hasMoreElements()) {
                        t = et.nextTerm();
                        covered = (Formula)tl.tag(t);
                        if (covered != null) {
                            facts.markTested(covered);
                        }
                        depends[index].unionInPlace(env.varSet(t));
                        if (first) {
                            first = false;
                            unioned = t;
                            continue;
                        }
                        unioned = new AssocTerm(unioned, t, BinaryOperator.findOperator(35));
                    }
                    try {
                        unioned = simple.simplifyTerm(unioned);
                        c = env.termValue((TermCompiler)((Object)unioned.createPeer(solver.getPeerTable())));
                        sRequired = (SetValue)c.getValue();
                        sRequired.setDescr("BndGen+" + v.getName());
                    }
                    catch (BadPeerClass badPeerClass) {
                        sRequired = null;
                    }
                } else {
                    sRequired = null;
                }
                first = true;
                unioned = null;
                tl = bgi.getDForbidden();
                if (tl != null) {
                    et = tl.elements();
                    while (et.hasMoreElements()) {
                        t = et.nextTerm();
                        covered = (Formula)tl.tag(t);
                        if (covered != null) {
                            facts.markTested(covered);
                        }
                        depends[index].unionInPlace(env.varSet(t));
                        if (first) {
                            first = false;
                            unioned = t;
                            continue;
                        }
                        unioned = new AssocTerm(unioned, t, BinaryOperator.findOperator(35));
                    }
                    try {
                        unioned = simple.simplifyTerm(unioned);
                        c = env.termValue((TermCompiler)((Object)unioned.createPeer(solver.getPeerTable())));
                        dForbidden = (SetValue)c.getValue();
                        dForbidden.setDescr("BndGen-" + v.getName());
                    }
                    catch (BadPeerClass badPeerClass) {
                        dForbidden = null;
                    }
                } else {
                    dForbidden = null;
                }
                return new SetBndGenerator((SetValue)val, v, scope, (SetGenerator)((Object)gen), dForbidden, sRequired);
            }
            if (ty.isRelation()) {
                SetValue rForbidden;
                SetValue dForbidden;
                Computation c;
                Formula covered;
                Term t;
                TermEnumeration et;
                RelationType rt = (RelationType)ty;
                if (rt.isFunction()) {
                    SetValue rForbidden2;
                    SetValue dForbidden2;
                    FunctionValue fRequired;
                    Computation c2;
                    Formula covered2;
                    Term t2;
                    TermEnumeration et2;
                    Term req = null;
                    Term unioned = null;
                    boolean first = true;
                    TermList tl = bgi.getDRequired();
                    if (tl != null) {
                        et2 = tl.elements();
                        while (et2.hasMoreElements()) {
                            t2 = et2.nextTerm();
                            covered2 = (Formula)tl.tag(t2);
                            if (covered2 != null) {
                                facts.markTested(covered2);
                            }
                            depends[index].unionInPlace(env.varSet(t2));
                            if (first) {
                                first = false;
                                unioned = t2;
                                continue;
                            }
                            unioned = new AssocTerm(unioned, t2, BinaryOperator.findOperator(35));
                        }
                        try {
                            req = unioned = simple.simplifyTerm(unioned);
                            unioned = new UnaryTerm(unioned, UnaryOperator.funcCastOp(), SourceLoc.noLoc);
                            c2 = env.termValue((TermCompiler)((Object)unioned.createPeer(solver.getPeerTable())));
                            fRequired = (FunctionValue)c2.getValue();
                            fRequired.setDescr("BndGen+" + v.getName());
                        }
                        catch (BadPeerClass badPeerClass) {
                            fRequired = null;
                        }
                    } else {
                        fRequired = null;
                    }
                    if ((tl = bgi.getDForbidden()) != null) {
                        unioned = null;
                        first = true;
                        et2 = tl.elements();
                        while (et2.hasMoreElements()) {
                            t2 = et2.nextTerm();
                            covered2 = (Formula)tl.tag(t2);
                            if (covered2 != null) {
                                facts.markTested(covered2);
                            }
                            depends[index].unionInPlace(env.varSet(t2));
                            if (first) {
                                first = false;
                                unioned = t2;
                                continue;
                            }
                            unioned = new AssocTerm(unioned, t2, BinaryOperator.findOperator(35));
                        }
                        try {
                            unioned = simple.simplifyTerm(unioned);
                            c2 = env.termValue((TermCompiler)((Object)unioned.createPeer(solver.getPeerTable())));
                            dForbidden2 = (SetValue)c2.getValue();
                            dForbidden2.setDescr("BndGen-dom " + v.getName());
                        }
                        catch (BadPeerClass badPeerClass) {
                            dForbidden2 = null;
                        }
                    } else {
                        dForbidden2 = null;
                    }
                    if (!rt.isChain()) {
                        tl = bgi.getRForbidden();
                        if (tl != null) {
                            unioned = null;
                            first = true;
                            et2 = tl.elements();
                            while (et2.hasMoreElements()) {
                                t2 = et2.nextTerm();
                                covered2 = (Formula)tl.tag(t2);
                                if (covered2 != null) {
                                    facts.markTested(covered2);
                                }
                                depends[index].unionInPlace(env.varSet(t2));
                                if (first) {
                                    first = false;
                                    unioned = t2;
                                    continue;
                                }
                                unioned = new AssocTerm(unioned, t2, BinaryOperator.findOperator(35));
                            }
                            try {
                                unioned = simple.simplifyTerm(unioned);
                                c2 = env.termValue((TermCompiler)((Object)unioned.createPeer(solver.getPeerTable())));
                                rForbidden2 = (SetValue)c2.getValue();
                                rForbidden2.setDescr("BndGen-ran " + v.getName());
                            }
                            catch (BadPeerClass badPeerClass) {
                                rForbidden2 = null;
                            }
                        } else {
                            rForbidden2 = null;
                        }
                    } else {
                        rForbidden2 = null;
                    }
                    return new FuncBndGenerator((FunctionValue)val, v, scope, (FunctionGenerator)((Object)gen), dForbidden2, rForbidden2, fRequired);
                }
                Term unioned = null;
                boolean first = true;
                TermList tl = bgi.getDForbidden();
                if (tl != null) {
                    et = tl.elements();
                    while (et.hasMoreElements()) {
                        t = et.nextTerm();
                        covered = (Formula)tl.tag(t);
                        if (covered != null) {
                            facts.markTested(covered);
                        }
                        depends[index].unionInPlace(env.varSet(t));
                        if (first) {
                            first = false;
                            unioned = t;
                            continue;
                        }
                        unioned = new AssocTerm(unioned, t, BinaryOperator.findOperator(35));
                    }
                    try {
                        unioned = simple.simplifyTerm(unioned);
                        c = env.termValue((TermCompiler)((Object)unioned.createPeer(solver.getPeerTable())));
                        dForbidden = (SetValue)c.getValue();
                        dForbidden.setDescr("BndGen-dom " + v.getName());
                    }
                    catch (BadPeerClass badPeerClass) {
                        dForbidden = null;
                    }
                } else {
                    dForbidden = null;
                }
                if ((tl = bgi.getRForbidden()) != null) {
                    unioned = null;
                    first = true;
                    et = tl.elements();
                    while (et.hasMoreElements()) {
                        t = et.nextTerm();
                        covered = (Formula)tl.tag(t);
                        if (covered != null) {
                            facts.markTested(covered);
                        }
                        depends[index].unionInPlace(env.varSet(t));
                        if (first) {
                            first = false;
                            unioned = t;
                            continue;
                        }
                        unioned = new AssocTerm(unioned, t, BinaryOperator.findOperator(35));
                    }
                    try {
                        unioned = simple.simplifyTerm(unioned);
                        c = env.termValue((TermCompiler)((Object)unioned.createPeer(solver.getPeerTable())));
                        rForbidden = (SetValue)c.getValue();
                        rForbidden.setDescr("BndGen-ran " + v.getName());
                    }
                    catch (BadPeerClass badPeerClass) {
                        rForbidden = null;
                    }
                } else {
                    rForbidden = null;
                }
                return new RelBndGenerator((RelationValue)val, v, scope, (RelationGenerator)((Object)gen), dForbidden, rForbidden);
            }
        }
        return gen;
    }

    private boolean checkTested(Formula f, FactSet facts, ExecEnv env, int vi, FormulaList checked) {
        if (facts.isTested(f)) {
            return true;
        }
        if (checked.containsEquiv(f)) {
            return false;
        }
        Vector impl = facts.isImpliedBy(f);
        if (impl == null) {
            return false;
        }
        checked.addFormula(f);
        Enumeration e = impl.elements();
        block0: while (e.hasMoreElements()) {
            FormulaList fl = (FormulaList)e.nextElement();
            FormulaEnumeration ef = fl.elements();
            while (ef.hasMoreElements()) {
                Formula im = ef.nextFormula();
                if (env.varIndex(im) > vi && !this.checkTested(im, facts, env, vi, checked)) continue block0;
            }
            checked.removeFormula(f);
            return true;
        }
        checked.removeFormula(f);
        return false;
    }

    public double pctCompleted() {
        if (this.factsProcessed >= this.numFacts) {
            return 1.0;
        }
        if (this.numFacts == 0) {
            return 0.0;
        }
        return (double)this.factsProcessed / (double)this.numFacts;
    }

    private void checkEnums(FactSet facts, EnumVars enums, Generator[] generators) {
        VarEnumeration e = enums.elements();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            this.checkVarType(facts, v, generators[enums.findPosition(v)].typeGenerated());
        }
    }

    private void checkDerived(FactSet facts, DerivedVars derived) {
        if (derived == null) {
            return;
        }
        VarEnumeration e = derived.derivedVars();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            Term equiv = derived.findEquiv(v);
            this.checkVarType(facts, v, equiv.getType());
        }
    }

    private void checkVarType(FactSet facts, Variable v, Type t) {
        if (t.isRelation()) {
            Predicate f;
            RelationType rt = (RelationType)t;
            RelationType vrt = (RelationType)v.getType();
            if (vrt.isFunction() && rt.isFunction()) {
                f = new Predicate(UnaryOperator.findOperator(51), new VarTerm(v), SourceLoc.noLoc);
                facts.markTested(f);
            }
            if (vrt.isInjection() && rt.isInjection()) {
                f = new Predicate(UnaryOperator.findOperator(52), new VarTerm(v), SourceLoc.noLoc);
                facts.markTested(f);
            }
            if (vrt.isTotal() && rt.isTotal()) {
                f = new Predicate(UnaryOperator.findOperator(53), new VarTerm(v), SourceLoc.noLoc);
                facts.markTested(f);
            }
            if (vrt.isOnto() && rt.isOnto()) {
                f = new Predicate(UnaryOperator.findOperator(54), new VarTerm(v), SourceLoc.noLoc);
                facts.markTested(f);
            }
        } else if (t.isSet()) {
            SetType st = (SetType)t;
            SetType vst = (SetType)v.getType();
            if (vst.hasMaxCard() && vst.maxCard() == 1 && st.hasMaxCard() && st.maxCard() == 1) {
                Predicate f = new Predicate(UnaryOperator.findOperator(50), new VarTerm(v), SourceLoc.noLoc);
                facts.markTested(f);
            }
        }
    }

    private RuleSuite getBoundedOpps(VariableList bounded) {
        if (this._opps == null) {
            this._opps = new RuleSuite("Bounded Gen Opps", false, this._solver.getFormulaSolver().getParent().getSimplifier());
            this._opps.addRule(new SimpleBGenRule(FormulaPattern.parsePattern("S1 <= SV0"), TermPattern.parsePattern("S1"), bounded, 0, true, true, true));
            this._opps.addRule(new SimpleBGenRule(FormulaPattern.parsePattern("R1 <= RV0"), TermPattern.parsePattern("R1"), bounded, 0, true, true, true));
            this._opps.addRule(new SimpleBGenRule(FormulaPattern.parsePattern("SV0 <= S1"), TermPattern.parsePattern("SUn \\ S1"), bounded, 0, false, true, true));
            this._opps.addRule(new SimpleBGenRule(FormulaPattern.parsePattern("(dom RV0) <= S1"), TermPattern.parsePattern("SUn \\ S1"), bounded, 0, false, true, false));
            this._opps.addRule(new SimpleBGenRule(FormulaPattern.parsePattern("(ran RV0) <= S1"), TermPattern.parsePattern("SUn \\ S1"), bounded, 0, false, false, false));
            this._opps.addRule(new SimpleBGenRule(FormulaPattern.parsePattern("not GV0 = G1"), TermPattern.parsePattern("{ G1 }"), bounded, 0, false, true, true));
            this._opps.addRule(new SimpleBGenRule(FormulaPattern.parsePattern("not GV0 in S1"), TermPattern.parsePattern("S1"), bounded, 0, false, true, true));
            this._opps.addRule(new SimpleBGenRule(FormulaPattern.parsePattern("GV0 in S1"), TermPattern.parsePattern("SUn \\ S1"), bounded, 0, false, true, true));
            this._opps.addRule(new SimpleBGenRule(FormulaPattern.parsePattern("not G1 in SV0"), TermPattern.parsePattern("{ G1 }"), bounded, 0, false, true, true));
            this._opps.addRule(new SimpleBGenRule(FormulaPattern.parsePattern("G1 in SV0"), TermPattern.parsePattern("{ G1 }"), bounded, 0, true, true, true));
            return this._opps;
        }
        RuleEnumeration e = this._opps.rules();
        while (e.hasMoreElements()) {
            BoundedGenRule bgr = (BoundedGenRule)((Object)e.nextRule());
            bgr.setBounds(bounded);
        }
        return this._opps;
    }

    private void resolveBounds(VariableList bounds, EnumVars enums, FactSet facts, ExecEnv env) {
        VarEnumeration e = bounds.elements();
        VariableList removes = new VariableList();
        while (e.hasMoreElements()) {
            Variable v2;
            VarEnumeration ev;
            VariableList vl;
            Term t;
            TermEnumeration et;
            RelationType rtype;
            Variable v = e.nextVar();
            Type ty = v.getType();
            if (!enums.isEnumerated(v)) {
                removes.addVar(v);
                continue;
            }
            BoundedGenInfo bgi = (BoundedGenInfo)bounds.tag(v);
            TermList dreq = bgi.getDRequired();
            TermList dforb = bgi.getDForbidden();
            TermList rreq = bgi.getRRequired();
            TermList rforb = bgi.getRForbidden();
            if ((dreq != null || rreq != null) && ty.isRelation() && !(rtype = (RelationType)ty).isFunction()) {
                if (rforb == null && dforb == null) {
                    removes.addVar(v);
                    continue;
                }
                dreq = null;
                rreq = null;
                bgi.clearRequired();
            }
            int varIndex = env.varIndex(v);
            if (dreq != null) {
                et = dreq.elements();
                block1: while (et.hasMoreElements()) {
                    t = et.nextTerm();
                    vl = t.vars();
                    ev = vl.elements();
                    while (ev.hasMoreElements()) {
                        v2 = ev.nextVar();
                        if (env.varIndex(v2) < varIndex) continue;
                        bgi.removeDRequired(t);
                        continue block1;
                    }
                }
            }
            if (rreq != null) {
                et = rreq.elements();
                block3: while (et.hasMoreElements()) {
                    t = et.nextTerm();
                    vl = t.vars();
                    ev = vl.elements();
                    while (ev.hasMoreElements()) {
                        v2 = ev.nextVar();
                        if (env.varIndex(v2) < varIndex) continue;
                        bgi.removeRRequired(t);
                        continue block3;
                    }
                }
            }
            if (dforb != null) {
                et = dforb.elements();
                block5: while (et.hasMoreElements()) {
                    t = et.nextTerm();
                    vl = t.vars();
                    ev = vl.elements();
                    while (ev.hasMoreElements()) {
                        v2 = ev.nextVar();
                        if (env.varIndex(v2) < varIndex) continue;
                        bgi.removeDForbidden(t);
                        continue block5;
                    }
                }
            }
            if (rforb != null) {
                et = rforb.elements();
                block7: while (et.hasMoreElements()) {
                    t = et.nextTerm();
                    vl = t.vars();
                    ev = vl.elements();
                    while (ev.hasMoreElements()) {
                        v2 = ev.nextVar();
                        if (env.varIndex(v2) < varIndex) continue;
                        bgi.removeRForbidden(t);
                        continue block7;
                    }
                }
            }
            if (!bgi.isEmpty()) continue;
            removes.addVar(v);
        }
        e = removes.elements();
        while (e.hasMoreElements()) {
            bounds.removeVar(e.nextVar());
        }
    }

    private OrderConstraintList shortCircOrderings(ExecEnv env, FactSet facts, Scope scope) {
        OrderConstraintList ocl = new OrderConstraintList();
        DerivedVars derived = env.getDerivedVars();
        FormulaEnumeration fe = facts.facts();
        block0: while (fe.hasMoreElements()) {
            Vector impls;
            Formula f = fe.nextFormula();
            VariableList vars = f.vars(null);
            if (derived != null) {
                vars = derived.extractVars(vars);
            }
            if ((impls = facts.isImpliedBy(f)) != null) {
                Enumeration e = impls.elements();
                while (e.hasMoreElements()) {
                    FormulaList fl = (FormulaList)e.nextElement();
                    VariableList implVars = new VariableList();
                    FormulaEnumeration fle = fl.elements();
                    while (fle.hasMoreElements()) {
                        Formula fimpl = fle.nextFormula();
                        implVars.union(fimpl.vars(null));
                    }
                    if (derived != null) {
                        implVars = derived.extractVars(implVars);
                    }
                    if (implVars.size() == vars.size()) continue block0;
                }
            }
            double weight = 1.0 - f.probability(scope);
            VarEnumeration ve = vars.elements();
            while (ve.hasMoreElements()) {
                Variable v = ve.nextVar();
                VariableList vl2 = vars.copy();
                vl2.removeVar(v);
                ocl.addConstraint(new OrderConstraint(v, vl2, weight, false));
            }
        }
        if (this._solver.debugOrder) {
            LadyBug.logMessage("ShCirc constraints" + Tree.linesep() + ocl.toString());
        }
        return ocl;
    }

    private OrderConstraintList boundedGenOrderings(VariableList bounded, ExecEnv env, FactSet facts, Scope scope) {
        OrderConstraintList ocl = new OrderConstraintList();
        DerivedVars derived = env.getDerivedVars();
        VarEnumeration ve = bounded.elements();
        block0: while (ve.hasMoreElements()) {
            int bound;
            RelationType rt;
            int i;
            double weight;
            VariableList tvars;
            Term t;
            TermEnumeration te;
            BoundedGenInfo bgi = (BoundedGenInfo)bounded.tag(ve.nextVar());
            Variable v = bgi.getVariable();
            TermList tl = bgi.getDForbidden();
            if (tl != null) {
                te = tl.elements();
                while (te.hasMoreElements()) {
                    t = te.nextTerm();
                    tvars = t.vars();
                    if (derived != null) {
                        tvars = derived.extractVars(tvars);
                    }
                    if (tvars.contains(v)) continue;
                    if (v.getType().isScalarType()) {
                        weight = 0.5;
                    } else if (v.getType().isSet()) {
                        weight = 1.0;
                        i = (int)((SetType)v.getType()).elemType().numValues(scope) / 2;
                        while (i >= 0) {
                            weight *= 0.5;
                            --i;
                        }
                    } else {
                        rt = (RelationType)v.getType();
                        if (rt.isFunction()) {
                            weight = 1.0;
                            bound = (int)rt.range().numValues(scope);
                            if (!rt.isTotal()) {
                                ++bound;
                            }
                            i = (int)rt.domain().numValues(scope) / 2;
                            while (i >= 0) {
                                weight /= (double)bound;
                                --i;
                            }
                        } else {
                            weight = 1.0;
                            bound = 1 << (int)rt.range().numValues(scope);
                            if (rt.isTotal()) {
                                --bound;
                            }
                            i = (int)rt.domain().numValues(scope) / 2;
                            while (i >= 0) {
                                weight /= (double)bound;
                                --i;
                            }
                        }
                    }
                    ocl.addConstraint(new OrderConstraint(v, tvars, weight, true));
                }
            }
            if ((tl = bgi.getRForbidden()) != null) {
                te = tl.elements();
                while (te.hasMoreElements()) {
                    t = te.nextTerm();
                    tvars = t.vars();
                    if (derived != null) {
                        tvars = derived.extractVars(tvars);
                    }
                    if (tvars.contains(v)) continue;
                    if (!v.getType().isRelation()) break;
                    rt = (RelationType)v.getType();
                    if (rt.isFunction()) {
                        weight = 1.0;
                        bound = (int)rt.range().numValues(scope);
                        if (!rt.isTotal()) {
                            ++bound;
                        }
                        i = (int)rt.domain().numValues(scope) / 2;
                        while (i >= 0) {
                            weight /= (double)bound;
                            --i;
                        }
                    } else {
                        weight = 1.0;
                        bound = 1 << (int)rt.range().numValues(scope);
                        if (rt.isTotal()) {
                            --bound;
                        }
                        i = (int)rt.domain().numValues(scope) / 2;
                        while (i >= 0) {
                            weight /= (double)bound;
                            --i;
                        }
                    }
                    ocl.addConstraint(new OrderConstraint(v, tvars, weight, true));
                }
            }
            if ((tl = bgi.getDRequired()) == null) continue;
            te = tl.elements();
            while (te.hasMoreElements()) {
                t = te.nextTerm();
                tvars = t.vars();
                if (derived != null) {
                    tvars = derived.extractVars(tvars);
                }
                if (tvars.contains(v)) continue;
                if (v.getType().isSet()) {
                    weight = 1.0;
                    i = (int)((SetType)v.getType()).elemType().numValues(scope) / 2;
                    while (i >= 0) {
                        weight *= 0.5;
                        --i;
                    }
                } else {
                    if (!v.getType().isRelation()) continue block0;
                    rt = (RelationType)v.getType();
                    if (rt.isFunction()) {
                        weight = 1.0;
                        bound = (int)rt.range().numValues(scope);
                        if (!rt.isTotal()) {
                            ++bound;
                        }
                        i = (int)rt.domain().numValues(scope) / 2;
                        while (i >= 0) {
                            weight /= (double)bound;
                            --i;
                        }
                    } else {
                        weight = 1.0;
                        bound = 1 << (int)rt.range().numValues(scope);
                        if (rt.isTotal()) {
                            --bound;
                        }
                        i = (int)rt.domain().numValues(scope) / 2;
                        while (i >= 0) {
                            weight /= (double)bound;
                            --i;
                        }
                    }
                }
                ocl.addConstraint(new OrderConstraint(v, tvars, weight, true));
            }
        }
        if (this._solver.debugOrder) {
            LadyBug.logMessage("BGen constraints" + Tree.linesep() + ocl.toString());
        }
        return ocl;
    }
}

