/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import ladybug.engine.BadPeerClass;
import ladybug.engine.ComparisonPeer;
import ladybug.selenum.Computation;
import ladybug.selenum.ExecEnv;
import ladybug.selenum.FormulaCompiler;
import ladybug.selenum.TermCompiler;
import ladybug.selenum.Tester;
import ladybug.selenum.VariableSet;

public class ComparisonSEPeer
extends ComparisonPeer
implements FormulaCompiler {
    public VariableSet varSet(ExecEnv env) {
        return new VariableSet(env, this.getSource().vars(env.solver().getController().getSchema()));
    }

    public Tester compile(ExecEnv env) {
        TermCompiler lc = (TermCompiler)((Object)this.left);
        TermCompiler rc = (TermCompiler)((Object)this.right);
        VariableSet vset = lc.varSet(env).union(rc.varSet(env));
        Tester t = new Tester(env, vset);
        Computation l = env.termValue(lc);
        Computation r = env.termValue(rc);
        String comment = this.getSource().toString();
        switch (this.op.symbol) {
            case 20: {
                if (this.left.getType().isSet()) {
                    t.checkSetSubset(l, r, this.isNegated(), comment);
                    break;
                }
                t.checkRelSubset(l, r, this.isNegated(), comment);
                break;
            }
            case 22: {
                if (this.left.getType().isSet()) {
                    t.checkSetSubset(r, l, this.isNegated(), comment);
                    break;
                }
                t.checkRelSubset(r, l, this.isNegated(), comment);
                break;
            }
            case 23: {
                t.checkElement(r, l, this.isNegated(), comment);
                break;
            }
            case 24: {
                if (this.left.getType().isSet()) {
                    t.checkSetEqual(l, r, this.isNegated(), comment);
                    break;
                }
                if (this.left.getType().isRelation()) {
                    t.checkRelEqual(l, r, this.isNegated(), comment);
                    break;
                }
                t.checkScalarEqual(l, r, this.isNegated(), comment);
                break;
            }
            case 21: {
                if (this.left.getType().isSet()) {
                    t.checkSetStrSubset(l, r, this.isNegated(), comment);
                    break;
                }
                t.checkRelStrSubset(l, r, this.isNegated(), comment);
                break;
            }
            case 66: {
                t.checkLessThan(l, r, this.isNegated(), comment);
                break;
            }
            case 67: {
                t.checkLTEqual(l, r, this.isNegated(), comment);
                break;
            }
            case 68: {
                t.checkLTEqual(r, l, this.isNegated(), comment);
                break;
            }
        }
        return t;
    }
}

