/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.Enumeration;
import ladybug.engine.FunctionValue;
import ladybug.engine.RelationValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeList;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;

public abstract class Coloring {
    protected Variable _var;
    protected TypeList _types;
    protected Scope _scope;
    private Coloring _prevColor;
    private Value _value;

    public Coloring(Variable var, VarEnumeration vars, Scope scope, Coloring prevColoring) {
        this._var = var;
        this._scope = scope;
        this._prevColor = prevColoring;
        this._types = new TypeList();
        while (vars.hasMoreElements()) {
            Type t = vars.nextVar().getType();
            if (t.isRelation()) {
                RelationType rt = (RelationType)t;
                if (!this._types.contains(rt.domain())) {
                    this._types.addType(rt.domain());
                }
                if (this._types.contains(rt.range())) continue;
                this._types.addType(rt.range());
                continue;
            }
            if (t.isSet()) {
                SetType st = (SetType)t;
                if (this._types.contains(st.elemType())) continue;
                this._types.addType(st.elemType());
                continue;
            }
            if (this._types.contains(t)) continue;
            this._types.addType(t);
        }
    }

    protected Coloring(Variable var, TypeList types, Scope scope, Coloring prevColoring) {
        this._var = var;
        this._scope = scope;
        this._prevColor = prevColoring;
        this._types = types.copy();
    }

    public abstract Coloring extend(Variable var1);

    public String dumpAllColors() {
        String s = String.valueOf(Tree.linesep()) + "Colorings:" + Tree.linesep();
        Enumeration te = this._types.elements();
        while (te.hasMoreElements()) {
            ScalarType t = (ScalarType)te.nextElement();
            s = String.valueOf(s) + Tree.linesep() + t.getName() + ":" + Tree.linesep();
            int[] colors = this.coloring(t);
            int i = 0;
            while (i < colors.length) {
                s = String.valueOf(s) + "  " + String.valueOf(colors[i]);
                ++i;
            }
            s = String.valueOf(s) + Tree.linesep();
        }
        return s;
    }

    public abstract String dumpColors();

    public abstract void reset();

    public abstract void distinguish(int var1, ScalarType var2);

    public abstract void distinguish(SetValue var1);

    public abstract void updateColoring(ScalarValue var1);

    public abstract void updateColoring(SetValue var1);

    public abstract void updateColoring(FunctionValue var1);

    public abstract void updateColoring(RelationValue var1);

    public abstract boolean modifies(ScalarType var1);

    public abstract int color(ScalarValue var1);

    public abstract int[] coloring(ScalarType var1);

    public int totalElements() {
        int n = 0;
        Enumeration te = this._types.elements();
        while (te.hasMoreElements()) {
            ScalarType t = (ScalarType)te.nextElement();
            n = (int)((long)n + t.numValues(this._scope));
        }
        return n;
    }

    public int totalElements(SetValue domain) {
        return this.totalElements(((SetType)domain.getType()).elemType());
    }

    public int totalElements(SetType dtype) {
        return this.totalElements(dtype.elemType());
    }

    public int totalElements(ScalarType st) {
        Enumeration te = this._types.elements();
        while (te.hasMoreElements()) {
            ScalarType t = (ScalarType)te.nextElement();
            if (!st.equals(t)) continue;
            return (int)t.numValues(this._scope);
        }
        return 0;
    }

    public Coloring getPrevColoring() {
        return this._prevColor;
    }

    public Value getValue() {
        return this._value;
    }

    protected void addValue(Value val) {
        this._value = val;
    }

    public Value[] getValues() {
        Value[] values;
        if (this._prevColor == null) {
            values = new Value[]{this._value};
        } else {
            Value[] prevValues = this._prevColor.getValues();
            values = new Value[prevValues.length + 1];
            int i = 0;
            while (i < prevValues.length) {
                values[i] = prevValues[i];
                ++i;
            }
            values[prevValues.length] = this._value;
        }
        return values;
    }
}

