/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.ValueError;
import ladybug.parse.RelationType;
import ladybug.parse.SetType;
import ladybug.parse.Type;
import ladybug.parse.Variable;
import ladybug.selenum.Coloring;
import ladybug.selenum.FuncBijExhGenerator;
import ladybug.selenum.FunctionGenerator;

class ColorMapper
implements FunctionGenerator {
    private int _numColors;
    private boolean first;
    private boolean[] empty;
    private boolean noMaps;
    private boolean allEmpty;
    private RelationType rt;
    private FunctionGenerator[] gens;
    private FunctionValue[] vals;
    private FunctionValue[] unions;
    private SetValue[] domains;
    private SetValue[] domainsUsed;
    private SetValue[] rangeUsed;
    private SetValue scratch;
    private SetValue domSet;
    private SetValue ranSet;

    ColorMapper(FunctionValue map, Variable v, Scope scope, int[] colors, int numColors) {
        this.gens = new FunctionGenerator[numColors];
        this.vals = new FunctionValue[numColors];
        this.unions = new FunctionValue[numColors];
        this.empty = new boolean[numColors];
        this.domains = new SetValue[numColors];
        this.domainsUsed = new SetValue[numColors];
        this.rangeUsed = new SetValue[numColors];
        this._numColors = numColors;
        this.rt = (RelationType)v.getType();
        SetType st = new SetType(this.rt.domain());
        this.domSet = new SetValue(st, scope);
        this.domSet.fullSet();
        this.ranSet = new SetValue(st, scope);
        this.ranSet.fullSet();
        this.scratch = new SetValue(st, scope);
        int i = 0;
        int c = 0;
        while (i < colors.length) {
            if (i == 0) {
                this.domains[c] = new SetValue(st, scope);
                this.domains[c].addElement(i);
                this.domainsUsed[c] = new SetValue(st, scope);
                this.rangeUsed[c] = new SetValue(st, scope);
                this.vals[c] = new FunctionValue(this.rt, scope);
                this.unions[c] = this.vals[c];
                this.gens[c] = new FuncBijExhGenerator(this.vals[c], v, scope);
                this.empty[c] = false;
            } else if (colors[i - 1] != colors[i]) {
                this.gens[c].setDomain(this.domains[c]);
                this.gens[c].setRange(this.domains[c]);
                this.domainsUsed[c].init(this.domains[c]);
                this.rangeUsed[c].init(this.domains[c]);
                this.domains[++c] = new SetValue(st, scope);
                this.domains[c].addElement(i);
                this.domainsUsed[c] = new SetValue(st, scope);
                this.rangeUsed[c] = new SetValue(st, scope);
                this.vals[c] = new FunctionValue(this.rt, scope);
                this.unions[c] = new FunctionValue(this.rt, scope);
                this.gens[c] = new FuncBijExhGenerator(this.vals[c], v, scope);
                this.empty[c] = false;
            } else {
                this.domains[c].addElement(i);
            }
            ++i;
        }
        this.gens[c].setDomain(this.domains[c]);
        this.gens[c].setRange(this.domains[c]);
        this.domainsUsed[c].init(this.domains[c]);
        this.rangeUsed[c].init(this.domains[c]);
        this.unions[c] = map;
        this.noMaps = false;
        this.allEmpty = false;
        this.reset();
    }

    public void reset() {
        this.first = true;
        int i = 0;
        while (i < this._numColors) {
            this.gens[i].reset();
            ++i;
        }
    }

    public void terminate() {
        this.first = false;
        int i = 0;
        while (i < this._numColors) {
            this.gens[i].terminate();
            ++i;
        }
    }

    public boolean hasMoreElements() {
        if (this.noMaps) {
            return false;
        }
        if (this.allEmpty && !this.first) {
            return false;
        }
        int i = 0;
        while (i < this._numColors) {
            if (this.gens[i].hasMoreElements()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (this.noMaps) {
            throw new NoSuchElementException();
        }
        if (this.allEmpty) {
            if (!this.first) {
                throw new NoSuchElementException();
            }
            this.first = false;
            this.unions[this._numColors - 1].init();
            return this.unions[this._numColors - 1];
        }
        if (this.first) {
            int i = 0;
            while (i < this._numColors) {
                if (this.empty[i]) {
                    this.vals[i].init();
                } else {
                    if (!this.gens[i].hasMoreElements()) {
                        this.terminate();
                        throw new NoSuchElementException();
                    }
                    this.gens[i].nextFunction();
                }
                if (i > 0) {
                    try {
                        this.vals[i].union(this.unions[i - 1], this.unions[i]);
                    }
                    catch (ValueError valueError) {}
                }
                ++i;
            }
            this.first = false;
            return this.unions[this._numColors - 1];
        }
        int i = this._numColors - 1;
        while (i < this._numColors) {
            if (!this.gens[i].hasMoreElements()) {
                if (i == 0) {
                    throw new NoSuchElementException();
                }
                i -= 2;
            } else {
                this.gens[i].nextFunction();
                if (i > 0) {
                    try {
                        this.unions[i - 1].union(this.vals[i], this.unions[i]);
                    }
                    catch (ValueError valueError) {}
                }
                if (i + 1 < this._numColors) {
                    this.gens[i + 1].reset();
                }
            }
            ++i;
        }
        return this.unions[this._numColors - 1];
    }

    public void setColoring(Coloring c) {
    }

    public void setValue(FunctionValue val) {
        this.unions[this._numColors - 1] = val;
    }

    public void setDomain(SetValue dom) {
        this.allEmpty = true;
        this.noMaps = false;
        int i = 0;
        while (i < this._numColors) {
            dom.intersect(this.domains[i], this.domainsUsed[i]);
            this.gens[i].setDomain(this.domainsUsed[i]);
            if (this.domainsUsed[i].card() == 0 && this.rangeUsed[i].card() == 0) {
                this.empty[i] = true;
            } else if (this.rangeUsed[i].card() != this.domainsUsed[i].card()) {
                this.noMaps = true;
            } else {
                this.empty[i] = false;
                this.allEmpty = false;
            }
            ++i;
        }
        this.domSet.init(dom);
    }

    public void setRange(SetValue ran) {
        this.allEmpty = true;
        this.noMaps = false;
        int i = 0;
        while (i < this._numColors) {
            ran.intersect(this.domains[i], this.rangeUsed[i]);
            this.gens[i].setRange(this.rangeUsed[i]);
            if (this.domainsUsed[i].card() == 0 && this.rangeUsed[i].card() == 0) {
                this.empty[i] = true;
            } else if (this.rangeUsed[i].card() != this.domainsUsed[i].card()) {
                this.noMaps = true;
            } else {
                this.empty[i] = false;
                this.allEmpty = false;
            }
            ++i;
        }
        this.ranSet.init(ran);
    }

    public double pctCompleted() {
        return 0.0;
    }

    public long totalValues() {
        return 0L;
    }

    public long totalGenValues() {
        return 0L;
    }

    public long valuesGend() {
        return 0L;
    }

    public Type typeGenerated() {
        return this.rt;
    }
}

