/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import java.util.NoSuchElementException;
import ladybug.engine.FunctionValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.ChainType;
import ladybug.parse.RelationType;
import ladybug.parse.SetType;
import ladybug.parse.Variable;
import ladybug.selenum.FunctionGenerator;
import ladybug.selenum.Generator;

public class ChainExhGenerator
extends Generator
implements FunctionGenerator {
    private FunctionValue valScratch;
    private FunctionValue mapScratch;
    private FunctionValue val;
    private FunctionValue result;
    private SetValue setScratch;
    private SetValue _ranSet;
    private SetValue _domSet;
    private int nextIndex = 0;
    private int maxIndex;
    private int domSize;
    private FunctionValue domMap;
    private FunctionValue ranMap;
    private boolean mapDomain;
    private boolean computed;
    private boolean checkRange;

    public ChainExhGenerator(FunctionValue value, Variable var, Scope scope) {
        super(var, var.getType());
        this.result = value;
        value.markChain();
        RelationType rt = (RelationType)var.getType();
        this.domSize = (int)rt.domain().numValues(scope);
        this.mapDomain = false;
        this.domMap = new FunctionValue(new RelationType(rt.domain(), rt.domain(), true, true, false, false, false), this.domSize, this.domSize);
        this.ranMap = new FunctionValue(new RelationType(rt.domain(), rt.domain(), true, true, false, false, false), this.domSize, this.domSize);
        this.val = this.result;
        this.valScratch = new FunctionValue(rt, this.domSize, this.domSize);
        this.mapScratch = new FunctionValue(rt, this.domSize, this.domSize);
        this.setScratch = new SetValue(new SetType(rt.domain()), this.domSize);
        this._ranSet = new SetValue(new SetType(rt.domain()), this.domSize);
        this._ranSet.fullSet();
        this._domSet = new SetValue(new SetType(rt.domain()), this.domSize);
        this._domSet.fullSet();
        this.checkRange = false;
        this.computeMax();
        rt = new ChainType(rt.domain());
        this.setTypeGenerated(rt);
        this.terminate();
    }

    public void reset() {
        this.nextIndex = 0;
        this.computed = false;
    }

    public void terminate() {
        this.nextIndex = this.maxIndex;
        this.computed = false;
    }

    public boolean hasMoreElements() {
        if (this.nextIndex >= this.maxIndex) {
            return false;
        }
        if (!this.checkRange) {
            return true;
        }
        return this.computeNextChain();
    }

    public Value nextValue() throws NoSuchElementException {
        return this.nextFunction();
    }

    public FunctionValue nextFunction() throws NoSuchElementException {
        if (this.nextIndex == this.maxIndex) {
            throw new NoSuchElementException();
        }
        if (!this.computeNextChain()) {
            throw new NoSuchElementException();
        }
        ++this.nextIndex;
        this.computed = false;
        if (this._coloring != null) {
            this._coloring.updateColoring(this.result);
        }
        return this.result;
    }

    private boolean computeNextChain() {
        if (this.nextIndex >= this.maxIndex) {
            return false;
        }
        if (this.computed) {
            return true;
        }
        this.val.init();
        if (this.nextIndex > 0) {
            if (this.nextIndex <= this.domSize) {
                if (this.checkRange && !this._ranSet.hasElement(this.nextIndex - 1)) {
                    this.computed = false;
                    ++this.nextIndex;
                    return this.computeNextChain();
                }
                this.val.markHead(this.nextIndex - 1);
                this.val.markTail(this.nextIndex - 1);
                this.val.addMapping(this.nextIndex - 1, this.nextIndex - 1);
            } else {
                int prev = (this.nextIndex - 1) % this.domSize;
                int bits = (this.nextIndex - 1) / this.domSize;
                int size = this.domSize - 1;
                this.setScratch.init();
                this.val.markHead(prev);
                block0: while (bits > 0) {
                    this.setScratch.addElement(prev);
                    int x = (bits - 1) % size;
                    bits = (bits - 1) / size;
                    --size;
                    int i = 0;
                    while (i < this.domSize) {
                        if (!this.setScratch.hasElement(i)) {
                            if (x == 0) {
                                if (this.checkRange && !this._ranSet.hasElement(i)) {
                                    this.computed = false;
                                    ++this.nextIndex;
                                    return this.computeNextChain();
                                }
                                this.val.addMapping(prev, i);
                                prev = i;
                                continue block0;
                            }
                            --x;
                        }
                        ++i;
                    }
                }
                this.val.addMapping(prev, prev);
                this.val.markTail(prev);
            }
            if (this.mapDomain) {
                this.domMap.compose(this.val, this.mapScratch);
                this.mapScratch.compose(this.ranMap, this.result);
            }
        }
        this.computed = true;
        return true;
    }

    public void setValue(FunctionValue value) {
        this.result = value;
        if (!this.mapDomain) {
            this.val = value;
        }
    }

    public void setDomain(SetValue dom) {
        this._domSet.init(dom);
        this.domSize = dom.card();
        int maxe = dom.maxElem() + 1;
        if (this.domSize < maxe) {
            this.mapDomain = true;
            this.val = this.valScratch;
            this.domMap.init();
            this.ranMap.init();
            int i = 0;
            int j = 0;
            while (i < maxe) {
                if (dom.hasElement(i)) {
                    this.domMap.addMapping(i, j);
                    this.ranMap.addMapping(j, i);
                    ++j;
                }
                ++i;
            }
        } else if (this.mapDomain) {
            this.mapDomain = false;
            this.val = this.result;
        }
        this.checkRange = this._ranSet.contains(this._domSet) ^ true;
        this.computeMax();
        this.terminate();
    }

    public void setRange(SetValue ran) {
        this._ranSet.init(ran);
        this.checkRange = this._ranSet.contains(this._domSet) ^ true;
        this.terminate();
    }

    public double pctCompleted() {
        if (this.maxIndex == 0) {
            return 1.0;
        }
        return (double)this.nextIndex / (double)this.maxIndex;
    }

    public long totalValues() {
        return this.maxIndex;
    }

    public long totalGenValues() {
        if (this.maxIndex == 0) {
            return 1L;
        }
        return this.maxIndex;
    }

    public long valuesGend() {
        return this.nextIndex;
    }

    private void computeMax() {
        int sum = 1;
        this.maxIndex = 1;
        int i = this.domSize;
        while (i > 0) {
            this.maxIndex += (sum *= i);
            --i;
        }
    }
}

