/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import ladybug.parse.Formula;
import ladybug.parse.Term;
import ladybug.parse.TermList;
import ladybug.parse.Variable;

public class BoundedGenInfo {
    private Variable var;
    private TermList dforbidden;
    private TermList rforbidden;
    private TermList drequired;
    private TermList rrequired;

    public BoundedGenInfo(Variable v) {
        this.var = v;
    }

    public Variable getVariable() {
        return this.var;
    }

    public boolean isEmpty() {
        if (this.drequired != null) {
            return false;
        }
        if (this.rrequired != null) {
            return false;
        }
        if (this.dforbidden != null) {
            return false;
        }
        return this.rforbidden == null;
    }

    public TermList getDRequired() {
        if (this.drequired == null) {
            return null;
        }
        return this.drequired.copy();
    }

    public TermList getDForbidden() {
        if (this.dforbidden == null) {
            return null;
        }
        return this.dforbidden.copy();
    }

    public TermList getRRequired() {
        if (this.rrequired == null) {
            return null;
        }
        return this.rrequired.copy();
    }

    public TermList getRForbidden() {
        if (this.rforbidden == null) {
            return null;
        }
        return this.rforbidden.copy();
    }

    public void addDRequired(Term value, Formula covered) {
        if (this.drequired == null) {
            this.drequired = new TermList();
        } else if (this.drequired.containsEquiv(value)) {
            return;
        }
        this.drequired.addTerm(value, covered);
    }

    public void addRRequired(Term value, Formula covered) {
        if (this.rrequired == null) {
            this.rrequired = new TermList();
        } else if (this.rrequired.containsEquiv(value)) {
            return;
        }
        this.rrequired.addTerm(value, covered);
    }

    public void addDForbidden(Term value, Formula covered) {
        if (this.dforbidden == null) {
            this.dforbidden = new TermList();
        } else if (this.dforbidden.containsEquiv(value)) {
            return;
        }
        this.dforbidden.addTerm(value, covered);
    }

    public void addRForbidden(Term value, Formula covered) {
        if (this.rforbidden == null) {
            this.rforbidden = new TermList();
        } else if (this.rforbidden.containsEquiv(value)) {
            return;
        }
        this.rforbidden.addTerm(value, covered);
    }

    public void removeDRequired(Term value) {
        this.drequired.removeTerm(value);
        if (this.drequired.isEmpty()) {
            this.drequired = null;
        }
    }

    public void removeRRequired(Term value) {
        this.rrequired.removeTerm(value);
        if (this.rrequired.isEmpty()) {
            this.rrequired = null;
        }
    }

    public void removeDForbidden(Term value) {
        this.dforbidden.removeTerm(value);
        if (this.dforbidden.isEmpty()) {
            this.dforbidden = null;
        }
    }

    public void removeRForbidden(Term value) {
        this.rforbidden.removeTerm(value);
        if (this.rforbidden.isEmpty()) {
            this.rforbidden = null;
        }
    }

    public void clearRequired() {
        this.drequired = null;
        this.rrequired = null;
    }

    public void clearForbidden() {
        this.dforbidden = null;
        this.rforbidden = null;
    }
}

