/*
 * Decompiled with CFR 0.152.
 */
package ladybug.selenum;

import ladybug.engine.EnumVars;
import ladybug.engine.FunctionValue;
import ladybug.engine.RelationValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.Tree;
import ladybug.parse.TypeList;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;
import ladybug.selenum.Coloring;

public class AtomicColoring
extends Coloring {
    private AtomicColoring _prev;
    private int _maxElem;
    private int[] _colors;
    private ScalarType _colorType;
    private ScalarValue _scratchElem;
    private boolean _colorPrev;
    private int _maxElemR;
    private int[] _rcolors;
    private ScalarType _rcolorType;
    private ScalarValue _scratchElemR;
    private boolean _rcolorPrev;

    public AtomicColoring(Variable var, VarEnumeration vars, Scope scope, AtomicColoring prevColoring) {
        super(var, vars, scope, (Coloring)prevColoring);
        this.init(var, prevColoring);
    }

    public AtomicColoring(Variable var, EnumVars vars, Scope scope, AtomicColoring prevColoring) {
        super(var, vars.elements(), scope, (Coloring)prevColoring);
        this.init(var, prevColoring);
    }

    private AtomicColoring(Variable v, TypeList types, Scope scope, AtomicColoring prev) {
        super(v, types, scope, (Coloring)prev);
        this.init(v, prev);
    }

    private void init(Variable var, AtomicColoring prevColoring) {
        this._prev = prevColoring;
        this._rcolors = null;
        this._rcolorType = null;
        if (var.getType().isRelation()) {
            RelationType rt = (RelationType)var.getType();
            this._colorType = rt.domain();
            this._maxElem = this.totalElements(this._colorType);
            this._colors = new int[this._maxElem];
            this._rcolorType = rt.range();
            if (this._rcolorType.equals(this._colorType)) {
                this._maxElemR = this._maxElem;
                this._rcolors = this._colors;
            } else {
                this._maxElemR = this.totalElements(this._rcolorType);
                this._rcolors = new int[this._maxElemR];
                this._scratchElemR = new ScalarValue(this._rcolorType, 0);
                this._rcolorPrev = this._prev != null ? this._prev.modifies(this._rcolorType) : false;
            }
        } else if (var.getType().isSet()) {
            SetType st = (SetType)var.getType();
            this._colorType = st.elemType();
            this._maxElem = this.totalElements(this._colorType);
            this._colors = new int[this._maxElem];
        } else {
            this._colorType = (ScalarType)var.getType();
            this._maxElem = this.totalElements(this._colorType);
            this._colors = new int[this._maxElem];
        }
        this._scratchElem = new ScalarValue(this._colorType, 0);
        this._colorPrev = this._prev != null ? this._prev.modifies(this._colorType) : false;
    }

    public Coloring extend(Variable var) {
        return new AtomicColoring(var, this._types, this._scope, this);
    }

    public String dumpColors() {
        String s = String.valueOf(Tree.linesep()) + "Colorings:" + Tree.linesep();
        s = String.valueOf(s) + Tree.linesep() + this._colorType.getName() + ":" + Tree.linesep();
        int i = 0;
        while (i < this._colors.length) {
            s = String.valueOf(s) + "  " + String.valueOf(this._colors[i]);
            ++i;
        }
        s = String.valueOf(s) + Tree.linesep();
        if (this._rcolorType != null && this._rcolorType != this._colorType) {
            s = String.valueOf(s) + Tree.linesep() + this._rcolorType.getName() + ":" + Tree.linesep();
            int i2 = 0;
            while (i2 < this._rcolors.length) {
                s = String.valueOf(s) + "  " + String.valueOf(this._rcolors[i2]);
                ++i2;
            }
            s = String.valueOf(s) + Tree.linesep();
        }
        return s;
    }

    public boolean modifies(ScalarType colorType) {
        if (this._colorType.equals(colorType)) {
            return true;
        }
        if (this._rcolorType != null && this._rcolorType.equals(colorType)) {
            return true;
        }
        if (this._prev != null) {
            return this._prev.modifies(colorType);
        }
        return false;
    }

    public void reset() {
        this.resetColors();
    }

    public void distinguish(int elem, ScalarType st) {
        block9: {
            int incr;
            block8: {
                incr = 0;
                if (!this._colorType.equals(st)) break block8;
                if (elem + 1 < this._colors.length && this._colors[elem + 1] == this._colors[elem]) {
                    ++incr;
                }
                if (elem > 0 && this._colors[elem - 1] == this._colors[elem]) {
                    int n = elem;
                    this._colors[n] = this._colors[n] + 1;
                    ++incr;
                }
                if (incr <= 0) break block9;
                int i = elem + 1;
                while (i < this._colors.length) {
                    int n = i++;
                    this._colors[n] = this._colors[n] + incr;
                }
                break block9;
            }
            if (this._rcolors != null && this._rcolorType.equals(st)) {
                if (elem + 1 < this._rcolors.length && this._rcolors[elem + 1] == this._rcolors[elem]) {
                    ++incr;
                }
                if (elem > 0 && this._rcolors[elem - 1] == this._rcolors[elem]) {
                    int n = elem;
                    this._rcolors[n] = this._rcolors[n] + 1;
                    ++incr;
                }
                if (incr > 0) {
                    int i = elem + 1;
                    while (i < this._rcolors.length) {
                        int n = i++;
                        this._rcolors[n] = this._rcolors[n] + incr;
                    }
                }
            }
        }
    }

    public void distinguish(SetValue value) {
        block5: {
            ScalarType st;
            int incr;
            block4: {
                incr = 0;
                st = ((SetType)value.getType()).elemType();
                if (!this._colorType.equals(st)) break block4;
                int index = 1;
                while (index < this._maxElem) {
                    if (this._colors[index] + incr == this._colors[index - 1] && value.hasElement(index) != value.hasElement(index - 1)) {
                        ++incr;
                    }
                    int n = index++;
                    this._colors[n] = this._colors[n] + incr;
                }
                break block5;
            }
            if (this._rcolors == null || !this._rcolorType.equals(st)) break block5;
            int index = 1;
            while (index < this._maxElemR) {
                if (this._rcolors[index] + incr == this._rcolors[index - 1] && value.hasElement(index) != value.hasElement(index - 1)) {
                    ++incr;
                }
                int n = index++;
                this._rcolors[n] = this._rcolors[n] + incr;
            }
        }
    }

    public void updateColoring(ScalarValue value) {
        this.addValue(value);
        this.resetColors();
        int index = value.getValue();
        int incr = 0;
        if (index + 1 < this._maxElem && this._colors[index] == this._colors[index + 1]) {
            ++incr;
        }
        if (index > 0 && this._colors[index - 1] == this._colors[index]) {
            ++incr;
            int n = index;
            this._colors[n] = this._colors[n] + 1;
        }
        if (incr > 0) {
            int i = index + 1;
            while (i < this._maxElem) {
                int n = i++;
                this._colors[n] = this._colors[n] + incr;
            }
        }
    }

    public void updateColoring(SetValue value) {
        this.addValue(value);
        this.resetColors();
        this.distinguish(value);
    }

    public void updateColoring(FunctionValue value) {
        this.addValue(value);
        this.resetColors();
        int incr = 0;
        int index = 1;
        while (index < this._maxElem) {
            if (this._colors[index] + incr == this._colors[index - 1] && (value.isMapped(index) || value.isMapped(index - 1))) {
                if (!value.isMapped(index) || value.isMapped(index - 1)) {
                    ++incr;
                } else if (value.mapsTo(index) != value.mapsTo(index - 1)) {
                    ++incr;
                }
            }
            int n = index++;
            this._colors[n] = this._colors[n] + incr;
        }
        incr = 0;
        index = 1;
        while (index < this._maxElemR) {
            if (this._rcolors[index] + incr == this._rcolors[index - 1]) {
                int j = 0;
                while (j < value.domainMax()) {
                    if (value.mapsTo(j) == index || value.mapsTo(j) == index - 1) {
                        ++incr;
                        break;
                    }
                    ++j;
                }
            }
            int n = index++;
            this._rcolors[n] = this._rcolors[n] + incr;
        }
    }

    public void updateColoring(RelationValue value) {
        this.addValue(value);
        this.resetColors();
        int incr = 0;
        int index = 1;
        while (index < this._maxElem) {
            if (this._colors[index] + incr == this._colors[index - 1] && value.mapping(index) != value.mapping(index - 1)) {
                ++incr;
            }
            int n = index++;
            this._colors[n] = this._colors[n] + incr;
        }
        incr = 0;
        index = 1;
        while (index < this._maxElemR) {
            if (this._rcolors[index] + incr == this._rcolors[index - 1]) {
                int j = 0;
                while (j < value.domainMax()) {
                    if (value.hasMapping(j, index) != value.hasMapping(j, index - 1)) {
                        ++incr;
                        break;
                    }
                    ++j;
                }
            }
            int n = index++;
            this._rcolors[n] = this._rcolors[n] + incr;
        }
    }

    public int color(ScalarValue elem) {
        if (elem.getType().equals(this._colorType)) {
            return this._colors[elem.getValue()];
        }
        if (this._rcolorType != null && elem.getType().equals(this._rcolorType)) {
            return this._rcolors[elem.getValue()];
        }
        if (this._prev != null) {
            return this._prev.color(elem);
        }
        return 0;
    }

    public int[] coloring(ScalarType st) {
        if (st.equals(this._colorType)) {
            return this._colors;
        }
        if (this._rcolorType != null && st.equals(this._rcolorType)) {
            return this._rcolors;
        }
        if (this._prev != null) {
            return this._prev.coloring(st);
        }
        int[] colors = new int[this.totalElements(st)];
        int i = 0;
        while (i < colors.length) {
            colors[i] = 0;
            ++i;
        }
        return colors;
    }

    private void resetColors() {
        int i;
        if (this._colorPrev) {
            i = 0;
            while (i < this._maxElem) {
                this._scratchElem.setValue(i);
                this._colors[i] = this._prev.color(this._scratchElem);
                ++i;
            }
        } else {
            i = 0;
            while (i < this._maxElem) {
                this._colors[i] = 0;
                ++i;
            }
        }
        if (this._rcolors == null || this._rcolors == this._colors) {
            return;
        }
        if (this._rcolorPrev) {
            i = 0;
            while (i < this._maxElemR) {
                this._scratchElemR.setValue(i);
                this._rcolors[i] = this._prev.color(this._scratchElemR);
                ++i;
            }
        } else {
            i = 0;
            while (i < this._maxElemR) {
                this._rcolors[i] = 0;
                ++i;
            }
        }
    }
}

