/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Enumeration;
import java.util.Vector;
import ladybug.parse.SimpleVarEnum;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;

public final class VariableList {
    private Variable[] _vars = new Variable[20];
    private int _numVars = 0;
    private int _allocVars = 20;
    private static final int allocSize = 20;
    private Vector _tags = null;

    public VariableList() {
    }

    public VariableList(Variable v) {
        this();
        this.addVar(v);
    }

    public VariableList copy() {
        VariableList vl = new VariableList();
        vl._vars = new Variable[this._allocVars];
        vl._allocVars = this._allocVars;
        int i = 0;
        while (i < this._numVars) {
            vl._vars[i] = this._vars[i];
            ++i;
        }
        vl._numVars = this._numVars;
        if (this._tags != null) {
            vl._tags = (Vector)this._tags.clone();
        } else {
            this._tags = null;
        }
        return vl;
    }

    public VariableList union(VariableList other) {
        VariableList vl = this.copy();
        VarEnumeration e = other.elements();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            if (vl.contains(v)) continue;
            Object tagObj = vl.tag(v);
            vl.append(v, tagObj);
        }
        return vl;
    }

    public boolean contains(Variable v) {
        int i = 0;
        while (i < this._numVars) {
            if (this._vars[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object tag(Variable v) {
        if (this._tags == null) {
            return null;
        }
        int i = 0;
        while (i < this._numVars) {
            if (this._vars[i] == v) {
                return this._tags.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public void setTag(Variable v, Object tag) {
        if (this._tags == null) {
            this._tags = new Vector();
            int j = 0;
            while (j < this._numVars) {
                this._tags.setElementAt(null, j);
                ++j;
            }
        }
        int i = 0;
        while (i < this._numVars) {
            if (this._vars[i] == v) {
                this._tags.setElementAt(tag, i);
                return;
            }
            ++i;
        }
        this.addVar(v, tag);
    }

    public void addVar(Variable v) {
        this.append(v, null);
    }

    public void append(Variable v) {
        this.append(v, null);
    }

    public void insertBefore(Variable v, Variable target) {
        this.insertBefore(v, target, null);
    }

    public void addVar(Variable v, Object tag) {
        this.append(v, tag);
    }

    public void append(Variable v, Object tag) {
        if (this._numVars >= this._allocVars) {
            Variable[] old = this._vars;
            this._allocVars += 20;
            this._vars = new Variable[this._allocVars];
            int i = 0;
            while (i < this._numVars) {
                this._vars[i] = old[i];
                ++i;
            }
        }
        if (this._tags == null) {
            if (tag != null) {
                this._tags = new Vector();
                int j = 0;
                while (j < this._numVars) {
                    this._tags.setElementAt(null, j);
                    ++j;
                }
                this._tags.insertElementAt(tag, this._numVars);
            }
        } else {
            this._tags.insertElementAt(tag, this._numVars);
        }
        this._vars[this._numVars] = v;
        ++this._numVars;
    }

    public void insertBefore(Variable v, Variable target, Object tag) {
        if (this._numVars >= this._allocVars) {
            Variable[] old = this._vars;
            this._allocVars += 20;
            this._vars = new Variable[this._allocVars];
            int i = 0;
            while (i < this._numVars) {
                this._vars[i] = old[i];
                ++i;
            }
        }
        int j = 0;
        while (j < this._numVars) {
            if (this._vars[j] == target) {
                int k = this._numVars;
                while (k > j) {
                    this._vars[k] = this._vars[k - 1];
                    --k;
                }
                if (this._tags == null) {
                    if (tag != null) {
                        this._tags = new Vector();
                        int j2 = 0;
                        while (j2 < this._numVars) {
                            this._tags.setElementAt(null, j2);
                            ++j2;
                        }
                        this._tags.insertElementAt(tag, j);
                    }
                } else {
                    this._tags.insertElementAt(tag, j);
                }
                this._vars[j] = v;
                ++this._numVars;
                return;
            }
            ++j;
        }
        if (this._tags == null) {
            if (tag != null) {
                this._tags = new Vector();
                int j3 = 0;
                while (j3 < this._numVars) {
                    this._tags.setElementAt(null, j3);
                    ++j3;
                }
                this._tags.insertElementAt(tag, this._numVars);
            }
        } else {
            this._tags.insertElementAt(tag, this._numVars);
        }
        this._vars[this._numVars] = v;
        ++this._numVars;
    }

    public void removeVar(Variable v) {
        int i = this._numVars - 1;
        while (i >= 0) {
            if (this._vars[i] == v) {
                if (this._tags != null) {
                    this._tags.removeElementAt(i);
                }
                --this._numVars;
                while (i < this._numVars) {
                    this._vars[i] = this._vars[i + 1];
                    ++i;
                }
                return;
            }
            --i;
        }
    }

    public int size() {
        return this._numVars;
    }

    public boolean isEmpty() {
        return this._numVars == 0;
    }

    public VarEnumeration elements() {
        return new SimpleVarEnum(this._vars, this._numVars);
    }

    public Enumeration tags() {
        return this._tags.elements();
    }

    public Variable findVar(String name) {
        VarEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            if (!v.getName().equals(name)) continue;
            return v;
        }
        return null;
    }

    public Variable findVar(Variable var) {
        Variable base = var.baseDef();
        VarEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            if (v.baseDef() != base) continue;
            return v;
        }
        return null;
    }

    public String toString() {
        String s = "{";
        int i = 0;
        while (i < this._numVars) {
            if (i > 0) {
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + " " + this._vars[i].getName();
            ++i;
        }
        return String.valueOf(s) + " }";
    }
}

