/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.ErrorReporter;
import ladybug.parse.PartitionType;
import ladybug.parse.RelationType;
import ladybug.parse.Schema;
import ladybug.parse.SourceLoc;
import ladybug.parse.SourceObject;
import ladybug.parse.Transition;
import ladybug.parse.Type;
import ladybug.parse.VarConflict;

public final class Variable
extends SourceObject {
    private String name;
    private Type type;
    private boolean primed;
    private boolean constant;
    private boolean param;
    private Variable primedVar;
    private Variable baseVar;
    private Variable original;
    private Schema schema;
    private boolean silent;
    private int intermed;

    public Variable(String n, Type t, Schema sch, SourceLoc loc) throws VarConflict {
        this(n, t, sch);
        this.location = loc;
        if (t != null) {
            t.varUsesType(this);
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type t) throws VarConflict {
        if (this.type == t) {
            return;
        }
        if (t == null) {
            return;
        }
        this.type = t;
        if (t != null) {
            t.varUsesType(this);
        }
    }

    void assignType(Type t) {
        this.type = t;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Variable originallyDefinedAs() {
        return this.original;
    }

    public Variable baseDef() {
        if (this.original == null) {
            return this;
        }
        return this.original.baseDef();
    }

    public boolean isPrime() {
        return this.primed;
    }

    public boolean isPrimable() {
        return (this.primed || this.constant || this.intermed != 0) ^ true;
    }

    public Variable prime() {
        if (this.primedVar == null) {
            if (!this.isPrimable()) {
                return this;
            }
            Type t2 = this.type;
            boolean isPartFunc = false;
            if (this.type != null) {
                if (this.type.isPartition()) {
                    t2 = null;
                } else if (this.type.isRelation() && ((RelationType)this.type).isPartitioning()) {
                    t2 = null;
                    isPartFunc = true;
                }
            }
            this.primedVar = new Variable(String.valueOf(this.name) + "'", t2, this.schema);
            this.primedVar.primed = true;
            this.primedVar.baseVar = this;
            if (isPartFunc) {
                PartitionType ptype = ((RelationType)this.type).partitioningType();
                ptype.prime(this.primedVar);
            }
        }
        return this.primedVar;
    }

    public Variable createIntermed(int number) {
        if (this.isPrime()) {
            return this.baseVar.createIntermed(number);
        }
        Type t2 = this.type;
        boolean isPartFunc = false;
        if (this.type != null) {
            if (this.type.isPartition()) {
                t2 = null;
            } else if (this.type.isRelation() && ((RelationType)this.type).isPartitioning()) {
                t2 = null;
                isPartFunc = true;
            }
        }
        Variable newvar = new Variable(String.valueOf(this.name) + "#" + String.valueOf(number), t2, this.schema);
        newvar.intermed = number;
        newvar.baseVar = this;
        if (isPartFunc) {
            ErrorReporter.internalError(SourceLoc.noLoc, "intermediate versions of partitioning are not currently supported.");
        }
        return newvar;
    }

    public Variable unprime() {
        return this.baseVar;
    }

    public boolean isIntermed() {
        return this.intermed > 0;
    }

    public int intermedNumber() {
        return this.intermed;
    }

    public boolean isConst() {
        return this.constant;
    }

    public boolean isConstable() {
        return !this.isPrime() && this.primedVar == null;
    }

    public void makeConst() {
        if (this.isConstable()) {
            this.constant = true;
        }
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean isSil) {
        this.silent = isSil;
    }

    public boolean isParam() {
        return this.param;
    }

    public void makeParam(Transition t) {
        this.param = true;
        this.makeConst();
        this.schema = t;
    }

    public Variable copyForSchema(Schema schema) {
        return this.copyForSchema(schema, "");
    }

    public Variable copyForSchema(Schema schema, String nameExtra) {
        PartitionType ptype;
        if (this.primed) {
            Variable unprimed = schema.findVar(this.baseVar);
            if (unprimed == null) {
                unprimed = this.baseVar.copyForSchema(schema, nameExtra);
            }
            return unprimed.prime();
        }
        if (this.isIntermed()) {
            Variable unprimed = schema.findVar(this.baseVar);
            if (unprimed == null) {
                unprimed = this.baseVar.copyForSchema(schema, nameExtra);
            }
            return unprimed.createIntermed(this.intermedNumber());
        }
        Type t2 = this.type;
        boolean isPartFunc = false;
        if (this.type != null) {
            if (this.type.isPartition()) {
                t2 = null;
            } else if (this.type.isRelation() && ((RelationType)this.type).isPartitioning()) {
                t2 = null;
                isPartFunc = true;
            }
        }
        Variable v = new Variable(String.valueOf(this.name) + nameExtra, t2, schema);
        v.original = this;
        v.constant = this.constant;
        if (isPartFunc) {
            ptype = ((RelationType)this.type).partitioningType();
            ptype.copyForSchema(v, schema);
        }
        if (!this.isPrimable() && this.primedVar != null) {
            v.primedVar = new Variable(String.valueOf(this.name) + nameExtra + "'", t2, schema);
            v.primedVar.primed = true;
            v.primedVar.baseVar = v;
            v.primedVar.original = this.primedVar;
            if (isPartFunc) {
                ptype = ((RelationType)v.getType()).partitioningType();
                ptype.prime(v.primedVar);
            }
        }
        return v;
    }

    private Variable(String n, Type t, Schema sch) {
        this.name = n;
        this.type = t;
        this.location = SourceLoc.noLoc;
        this.primed = false;
        this.intermed = 0;
        this.constant = false;
        this.original = null;
        this.schema = sch;
    }
}

