/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.engine.DerivedVars;
import ladybug.parse.FormulaList;
import ladybug.parse.Renaming;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

public final class UnivTerm
extends Term {
    public UnivTerm(Type t, SourceLoc loc) {
        super(loc, t);
        this.debug_init();
    }

    public int precedence() {
        return 0;
    }

    public VariableList vars() {
        return new VariableList();
    }

    public TermList terms() {
        return new TermList(this);
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        return false;
    }

    public FormulaList constraints() {
        return new FormulaList();
    }

    public Term copy() {
        return new UnivTerm(this.type, this.location);
    }

    public String toString() {
        if (this._str != null) {
            return this._str;
        }
        if (this.getType() != null && this.getType().isSet()) {
            SetType st = (SetType)this.getType();
            if (st.elemType() != null) {
                this._str = st.elemType().toString();
            }
        } else {
            this._str = "Un";
        }
        return this._str;
    }

    public Term rename(Renaming r) {
        return this.copy();
    }

    public boolean isPrime() {
        return false;
    }

    public boolean isPrimable() {
        return false;
    }

    public Term prime() {
        return this.copy();
    }

    public void setType(Type newType) throws TypeConflict {
        if (!newType.isRelation() && !newType.isSet()) {
            throw new TypeConflict(newType, null, "Invalid type %1 for universal term");
        }
        super.setType(newType);
    }

    public boolean equiv(Tree other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        UnivTerm ut = (UnivTerm)other;
        return this.type.equiv(ut.type);
    }

    public TermIndex index() {
        return new TermIndex(this);
    }

    int equivHashCode(int hashSize) {
        return 1;
    }
}

