/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.Operator;
import ladybug.parse.parser;

public class UnaryOperator
extends Operator {
    private boolean isPref;
    private static final UnaryOperator[] operators = new UnaryOperator[parser.highestSymbol + 1];
    private static final int[] symbols = new int[]{47, 45, 53, 62, 60, 61, 54, 48, 51, 46, 52, 44, 50, 32, 65, 73};
    private static final int[] precedences = new int[]{8, 4, 96, 96, 8, 8, 96, 8, 96, 4, 96, 4, 96, 108, 2, 8};
    private static final boolean[] prefix;
    private static final String[] names;
    private static final boolean[] spacing;

    public static final UnaryOperator notOp() {
        return UnaryOperator.findOperator(32);
    }

    public static final UnaryOperator oneOp() {
        return UnaryOperator.findOperator(50);
    }

    public static final UnaryOperator totalOp() {
        return UnaryOperator.findOperator(53);
    }

    public static final UnaryOperator sujOp() {
        return UnaryOperator.findOperator(54);
    }

    public static final UnaryOperator funcOp() {
        return UnaryOperator.findOperator(51);
    }

    public static final UnaryOperator injOp() {
        return UnaryOperator.findOperator(52);
    }

    public static final UnaryOperator ranOp() {
        return UnaryOperator.findOperator(48);
    }

    public static final UnaryOperator domOp() {
        return UnaryOperator.findOperator(47);
    }

    public static final UnaryOperator funcCastOp() {
        return UnaryOperator.findOperator(73);
    }

    public static UnaryOperator findOperator(int s) {
        if (s < 0 || s > parser.highestSymbol) {
            return null;
        }
        if (operators[s] != null) {
            return operators[s];
        }
        int i = 0;
        while (i < symbols.length) {
            if (symbols[i] == s) {
                return new UnaryOperator(i);
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperator findOperator(String n) {
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(n)) {
                if (operators[symbols[i]] != null) {
                    return operators[symbols[i]];
                }
                return new UnaryOperator(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isPrefix() {
        return this.isPref;
    }

    UnaryOperator(int sym2, int precedence, String n, boolean useSpaces, boolean pref) {
        super(sym2, precedence, n, useSpaces);
        this.isPref = pref;
        UnaryOperator.operators[sym2] = this;
    }

    UnaryOperator(int index) {
        super(symbols[index], precedences[index], names[index], spacing[index]);
        this.isPref = prefix[index];
        UnaryOperator.operators[this.symbol] = this;
    }

    static {
        boolean[] blArray = new boolean[16];
        blArray[0] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[10] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        prefix = blArray;
        names = new String[]{"dom", "+", "tot", "seq", "first", "last", "suj", "ran", "fun", "*", "inj", "~", "one", "not", "#", "(func)"};
        boolean[] blArray2 = new boolean[16];
        blArray2[0] = true;
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[8] = true;
        blArray2[10] = true;
        blArray2[12] = true;
        blArray2[13] = true;
        spacing = blArray2;
    }
}

