/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.Term;
import ladybug.parse.TermList;

public final class TermSet {
    private int hsize;
    private TermList[] table;
    private static final int defaultSize = 32;

    public TermSet(int hashSize) {
        this.hsize = hashSize;
        this.table = new TermList[this.hsize];
    }

    public TermSet() {
        this.hsize = 32;
        this.table = new TermList[this.hsize];
    }

    public void addTerm(Term t) {
        int h = t.equivHashCode(this.hsize) % this.hsize;
        if (this.table[h] == null) {
            this.table[h] = new TermList(t);
        } else {
            if (this.table[h].containsEquiv(t)) {
                return;
            }
            this.table[h].addTerm(t);
        }
    }

    public void putTerm(Term t, Object tag) {
        int h = t.equivHashCode(this.hsize) % this.hsize;
        if (this.table[h] == null) {
            this.table[h] = new TermList(t, tag);
        } else {
            if (this.table[h].containsEquiv(t)) {
                return;
            }
            this.table[h].addTerm(t, tag);
        }
    }

    public boolean contains(Term t) {
        int h = t.equivHashCode(this.hsize) % this.hsize;
        if (this.table[h] == null) {
            return false;
        }
        return this.table[h].containsEquiv(t);
    }

    public Object tag(Term t) {
        int h = t.equivHashCode(this.hsize) % this.hsize;
        if (this.table[h] == null) {
            return null;
        }
        return this.table[h].tagEquiv(t);
    }
}

