/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import ladybug.parse.Schema;
import ladybug.parse.SymbolEntry;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;

class SymbolTable {
    public static final int isType = 0;
    public static final int isStateSchema = 1;
    public static final int isTransSchema = 2;
    public static final int isVariable = 3;
    public static final int isValue = 4;
    private Hashtable table = new Hashtable(SIZE);
    private static int SIZE = 50;
    private Vector schemas = new Vector();
    private Vector prevHashes = new Vector();

    public void put(String key, Object val, int kind) throws NullPointerException {
        this.table.put(key, new SymbolEntry(key, val, kind));
    }

    public SymbolEntry get(String key) throws NullPointerException {
        Object o = this.table.get(key);
        if (o == null) {
            return null;
        }
        return (SymbolEntry)o;
    }

    public void push(Schema s) {
        int last = this.schemas.size();
        this.schemas.insertElementAt(s, last);
        this.prevHashes.insertElementAt(this.table, last);
        this.table = (Hashtable)this.table.clone();
        VarEnumeration e = s.vars();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            String name = v.getName();
            this.table.remove(name);
            this.table.put(name, new SymbolEntry(name, v, 3));
        }
    }

    public void update(Schema s) {
        VarEnumeration e = s.vars();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            String name = v.getName();
            if (this.table.get(name) == v) continue;
            this.table.put(name, new SymbolEntry(name, v, 3));
        }
    }

    public Schema pop() throws ArrayIndexOutOfBoundsException, NoSuchElementException {
        int last = this.schemas.size() - 1;
        this.table = (Hashtable)this.prevHashes.lastElement();
        this.prevHashes.removeElementAt(last);
        Schema s = (Schema)this.schemas.lastElement();
        this.schemas.removeElementAt(last);
        return s;
    }
}

