/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.io.File;
import java.util.Enumeration;
import ladybug.parse.GivenType;
import ladybug.parse.Schema;
import ladybug.parse.SchemaList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeList;

public class Specification {
    private File _file;
    private TypeList _types;
    private SchemaList _schemas;

    public Specification(File file, TypeList types, SchemaList schemas) {
        this._file = file;
        this._types = types;
        this._schemas = schemas;
        Enumeration e = this.types();
        while (e.hasMoreElements()) {
            GivenType gt = (GivenType)e.nextElement();
            String name = gt.getName();
            String prefix = "";
            int len = 1;
            block1: while (len <= name.length()) {
                prefix = name.substring(0, len);
                Enumeration e2 = this.types();
                while (e2.hasMoreElements()) {
                    String n2;
                    GivenType g2 = (GivenType)e2.nextElement();
                    if (g2 == gt || !prefix.equals((n2 = g2.getName()).substring(0, len))) {
                        continue;
                    }
                    ++len;
                    continue block1;
                }
                break block1;
            }
            gt.setPrefix(prefix.toLowerCase());
        }
    }

    public Enumeration types() {
        return this._types.elements();
    }

    public Enumeration schemas() {
        return this._schemas.elements();
    }

    public File file() {
        return this._file;
    }

    public String filename() {
        return this._file == null ? "<stdin>" : this._file.getName();
    }

    public String filePath() {
        return this._file == null ? "" : this._file.getPath();
    }

    public String fileAbsolute() {
        return this._file == null ? "" : this._file.getAbsolutePath();
    }

    public String toString() {
        String sch = "";
        Enumeration e = this.types();
        String ty = "[ ";
        boolean first = true;
        while (e.hasMoreElements()) {
            Type t = (Type)e.nextElement();
            if (first) {
                first = false;
            } else {
                ty = String.valueOf(ty) + ", ";
            }
            ty = String.valueOf(ty) + t.toString();
        }
        ty = first ? "" : String.valueOf(ty) + " ]" + Tree.linesep();
        first = true;
        e = this.schemas();
        while (e.hasMoreElements()) {
            Schema s = (Schema)e.nextElement();
            if (first) {
                first = false;
                sch = String.valueOf(s.toString()) + Tree.linesep();
                continue;
            }
            sch = String.valueOf(sch) + Tree.linesep() + Tree.linesep() + s.toString() + Tree.linesep();
        }
        return String.valueOf(ty) + sch;
    }
}

