/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.engine.Scope;
import ladybug.parse.ScalarType;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;

public class SetType
extends Type {
    private ScalarType etype;
    private boolean hasMax;
    private boolean hasMin;
    private int max;
    private int min;

    public SetType(ScalarType elemType) {
        this.etype = elemType;
        this.hasMax = false;
        this.hasMin = false;
    }

    public boolean isSet() {
        return true;
    }

    public int getTypeClass() {
        return 2;
    }

    public boolean isComplete() {
        return this.etype != null;
    }

    public ScalarType elemType() {
        return this.etype;
    }

    public void setElemType(ScalarType t) throws TypeConflict {
        this.etype = t;
    }

    public boolean hasMaxCard() {
        return this.hasMax;
    }

    public int maxCard() {
        if (this.hasMax) {
            return this.max;
        }
        return -1;
    }

    public void setMaxCard(int card) {
        this.hasMax = true;
        this.max = card;
    }

    public boolean hasMinCard() {
        return this.hasMin;
    }

    public int minCard() {
        if (this.hasMin) {
            return this.min;
        }
        return 0;
    }

    public void setMinCard(int card) {
        this.hasMin = true;
        this.min = card;
    }

    public boolean usesType(Type ty) {
        if (this.equiv(ty)) {
            return true;
        }
        return this.elemType() != null && this.elemType().usesType(ty);
    }

    public long numValues(Scope s) {
        int numElems = (int)this.elemType().numValues(s);
        if (!this.hasMinCard() && !this.hasMaxCard()) {
            return Type.pow(2L, numElems);
        }
        int mn = this.minCard();
        int mx = this.hasMaxCard() ? this.maxCard() : numElems;
        long answer = 1L;
        int j = this.minCard();
        while (j <= this.maxCard()) {
            long a = 1L;
            int i = numElems - j + 1;
            while (i <= numElems) {
                a *= (long)i;
                ++i;
            }
            answer += a;
            ++j;
        }
        return answer;
    }

    public String toString() {
        String s = this.elemType() == null ? "?" : this.elemType().toString();
        if (this.hasMaxCard() && this.maxCard() == 1) {
            return "one " + s;
        }
        return "set " + s;
    }

    public boolean equiv(Type other) {
        if (!other.isSet()) {
            return false;
        }
        if (other.isPartition()) {
            return false;
        }
        SetType st = (SetType)other;
        if (this.elemType() == null) {
            return st.elemType() == null;
        }
        if (st.elemType() == null) {
            return false;
        }
        if (st.hasMaxCard() != this.hasMaxCard()) {
            return false;
        }
        if (this.hasMaxCard() && this.maxCard() != st.maxCard()) {
            return false;
        }
        if (st.hasMinCard() != this.hasMinCard()) {
            return false;
        }
        if (this.hasMinCard() && this.minCard() != st.minCard()) {
            return false;
        }
        return this.elemType().equiv(st.elemType());
    }

    public boolean includes(Type other) {
        if (other == null) {
            return false;
        }
        if (!other.isSet()) {
            return false;
        }
        if (other.isPartition() && (this.hasMaxCard() || this.hasMinCard())) {
            return false;
        }
        SetType st = (SetType)other;
        if (this.elemType() == null) {
            return true;
        }
        if (st.elemType() == null) {
            return false;
        }
        if (this.hasMaxCard()) {
            if (!st.hasMaxCard()) {
                return false;
            }
            if (this.maxCard() < st.maxCard()) {
                return false;
            }
        }
        if (this.hasMinCard()) {
            if (!st.hasMinCard()) {
                return false;
            }
            if (this.minCard() > st.minCard()) {
                return false;
            }
        }
        return this.elemType().includes(st.elemType());
    }
}

