/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.engine.Scope;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Comparison;
import ladybug.parse.CompoundFormula;
import ladybug.parse.ErrorFormula;
import ladybug.parse.ErrorReporter;
import ladybug.parse.Formula;
import ladybug.parse.FormulaList;
import ladybug.parse.NormalizedFormula;
import ladybug.parse.Renaming;
import ladybug.parse.Schema;
import ladybug.parse.SchemaConflict;
import ladybug.parse.SourceLoc;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.UnaryOperator;
import ladybug.parse.VarEnumeration;
import ladybug.parse.VarTerm;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

class SchemaRef
extends Formula {
    private Schema schema;
    private NormalizedFormula _normalized;
    private boolean _normalizedNegated;
    private boolean _negated;

    public SchemaRef(Schema s, SourceLoc loc) throws SchemaConflict {
        if (s != null && s.isClaim()) {
            throw new SchemaConflict(s, null, "Illegal use of claim %1 in schema composition");
        }
        this.schema = s;
        this.location = loc;
        this._normalized = null;
        this._normalizedNegated = false;
        this._negated = false;
        this.debug_init();
    }

    public boolean isNegated() {
        return this._negated;
    }

    public int precedence() {
        return UnaryOperator.findOperator(32).precedence() - 1;
    }

    public VariableList vars(Schema s) {
        return this.instantiate(s).vars(s);
    }

    public TermList terms(Schema s) {
        return this.instantiate(s).terms(s);
    }

    public FormulaList facts(Schema s) {
        return this.instantiate(s).facts(s);
    }

    public Formula negated() {
        SchemaRef sr = (SchemaRef)this.copy();
        sr._negated = this._negated ^ true;
        return sr;
    }

    public Formula formula() {
        if (this.schema == null) {
            return new ErrorFormula(this.getLocation());
        }
        Formula f = this.schema.formula();
        if (this.isNegated()) {
            return f.negated();
        }
        return f;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String toString() {
        if (this.schema == null) {
            return "*ErrorSchema*";
        }
        if (this._str == null) {
            this._str = this.isNegated() ? "not " + this.schema.getName() : this.schema.getName();
        }
        return this._str;
    }

    public Formula rename(Renaming r) {
        return this.copy();
    }

    public Formula instantiate(Schema s) {
        Formula f;
        Formula extraConstraints = null;
        if (this.schema == null) {
            return new ErrorFormula(this.getLocation());
        }
        VarEnumeration e = this.schema.vars();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            if (v.isParam()) continue;
            Variable v2 = s.findVar(v.getName());
            if (v2 == null) {
                ErrorReporter.internalError(this.getLocation(), "No variable in enclosing schema for " + v.getName());
            }
            if (!s.isTransition() || !v2.isPrimable() || v.isPrimable() || !v.isConst()) continue;
            f = new Comparison(new VarTerm(v2.prime(), this.getLocation()), new VarTerm(v2, this.getLocation()), BinaryOperator.findOperator(24));
            extraConstraints = extraConstraints == null ? f : new CompoundFormula(extraConstraints, f, true);
        }
        f = this.formula().instantiate(s);
        if (extraConstraints != null) {
            return new CompoundFormula(f, extraConstraints, true);
        }
        return f;
    }

    public boolean isPrime() {
        if (this.schema == null) {
            return false;
        }
        return this.schema.isPrime();
    }

    public boolean isPrimable() {
        if (this.schema == null) {
            return false;
        }
        return !this.schema.isPrime() && !this.schema.isTransition();
    }

    public Formula prime() {
        if (this.schema == null) {
            return this.copy();
        }
        try {
            return new SchemaRef(this.schema.prime(), this.location);
        }
        catch (SchemaConflict sc) {
            ErrorReporter.internalError(this.getLocation(), sc);
            return null;
        }
    }

    public Formula copy() {
        try {
            SchemaRef sr = new SchemaRef(this.schema, this.location);
            return sr;
        }
        catch (SchemaConflict sc) {
            ErrorReporter.internalError(this.getLocation(), sc);
            return null;
        }
    }

    public boolean equiv(Tree other) {
        if (this.schema == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            SchemaRef otherSR = (SchemaRef)other;
            if (this.isNegated() == otherSR.isNegated() && this.schema == otherSR.getSchema()) {
                return true;
            }
            return otherSR.formula().equiv(this.formula());
        }
        return other.equiv(this.formula());
    }

    public NormalizedFormula normalize(boolean negate) {
        if (this._normalized == null || this._normalizedNegated != negate) {
            this._normalized = this.formula().normalize(negate);
            this._normalizedNegated = negate;
        }
        return this._normalized;
    }

    public double probability(Scope scope) {
        return this.formula().probability(scope);
    }

    int equivHashCode(int hashSize) {
        if (this.eqHashCode < 0) {
            this.eqHashCode = this.formula().equivHashCode(hashSize);
        }
        return this.eqHashCode;
    }
}

