/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.engine.DerivedVars;
import ladybug.parse.FormulaList;
import ladybug.parse.Renaming;
import ladybug.parse.ScalarType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

public final class ScalarConstTerm
extends Term {
    private int value;

    public ScalarConstTerm(int value, ScalarType type, SourceLoc loc) {
        super(loc, type);
        this.value = value;
        this.debug_init();
    }

    public int precedence() {
        return 0;
    }

    public VariableList vars() {
        return new VariableList();
    }

    public TermList terms() {
        return new TermList(this);
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        return false;
    }

    public FormulaList constraints() {
        return new FormulaList();
    }

    public Term copy() {
        return new ScalarConstTerm(this.value, (ScalarType)this.getType(), this.getLocation());
    }

    public int getValue() {
        return this.value;
    }

    public boolean isPrime() {
        return false;
    }

    public boolean isPrimable() {
        return false;
    }

    public String toString() {
        if (this._str == null) {
            this._str = ((ScalarType)this.getType()).getElementName(this.value);
        }
        return this._str;
    }

    public void setType(Type newType) throws TypeConflict {
        if (!this.getType().equiv(newType)) {
            throw new TypeConflict(this.getType(), newType, "resetting the type of " + this.toString() + " from %1 to %2");
        }
    }

    public void setDomain(Type newType) throws TypeConflict {
        throw new TypeConflict(this.getType(), newType, "resetting the domain of " + this.toString() + " from %1 to %2");
    }

    public void setRange(Type newType) throws TypeConflict {
        throw new TypeConflict(this.getType(), newType, "resetting the range of " + this.toString() + " from %1 to %2");
    }

    public void setElemType(Type newType) throws TypeConflict {
        throw new TypeConflict(this.getType(), newType, "resetting the element type of " + this.toString() + " from %1 to %2");
    }

    public Term rename(Renaming r) {
        return this.copy();
    }

    public Term prime() {
        return this.copy();
    }

    public boolean equiv(Tree other) {
        if (!(other instanceof ScalarConstTerm)) {
            return false;
        }
        ScalarConstTerm otherSC = (ScalarConstTerm)other;
        if (!otherSC.getType().equiv(this.getType())) {
            return false;
        }
        return otherSC.getValue() == this.getValue();
    }

    public TermIndex index() {
        return new TermIndex(this);
    }

    int equivHashCode(int hashSize) {
        return this.value % hashSize;
    }
}

