/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.ErrorReporter;
import ladybug.parse.GivenType;
import ladybug.parse.ParseError;
import ladybug.parse.RelationType;
import ladybug.parse.Schema;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Type;
import ladybug.parse.VarConflict;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

public final class PartitionType
extends SetType {
    private VariableList vars;
    private Variable func;
    private GivenType partType;
    private int numSets;

    public PartitionType(Variable pFunc, GivenType elemType) {
        super(elemType);
        this.func = pFunc;
        this.partType = new GivenType("_" + pFunc.getName());
        this.vars = new VariableList();
        this.numSets = 0;
        RelationType ft = new RelationType(this.partType, elemType);
        ft.setFunction(true);
        ft.setTotal(true);
        ft.setPartitioning(this);
        try {
            pFunc.setType(ft);
        }
        catch (ParseError pe) {
            ErrorReporter.internalError(pFunc.getLocation(), pe);
        }
    }

    private PartitionType(Variable pFunc, PartitionType ptype) {
        super(ptype.elemType());
        this.func = pFunc;
        this.partType = ptype.partType;
        this.vars = new VariableList();
        this.numSets = 0;
        RelationType ft = new RelationType(this.partType, this.elemType());
        ft.setFunction(true);
        ft.setTotal(true);
        ft.setPartitioning(this);
        try {
            pFunc.setType(ft);
        }
        catch (ParseError pe) {
            ErrorReporter.internalError(pFunc.getLocation(), pe);
        }
    }

    public void completedType() {
        this.partType.allowMore(false);
    }

    public boolean isPartition() {
        return true;
    }

    public GivenType partitionType() {
        return this.partType;
    }

    public Variable partFunction() {
        return this.func;
    }

    public int numPartitions() {
        return this.numSets;
    }

    public boolean usesType(Type ty) {
        if (super.usesType(ty)) {
            return true;
        }
        return this.partType.usesType(ty);
    }

    public void varUsesType(Variable v) throws VarConflict {
        if (this.vars.findVar(v.getName()) != null) {
            throw new VarConflict(v, "Variable %1 is duplicated in partition");
        }
        if (!this.partType.allowsLargerScope()) {
            ErrorReporter.internalError(v.getLocation(), "Adding additional element to partition " + this.func.getName());
        }
        this.vars.addVar(v, new Integer(this.numSets));
        this.partType.setElementName(this.numSets, "_" + v.getName());
        ++this.numSets;
        if (v.isConst() && !this.func.isConst()) {
            if (!this.func.isConstable()) {
                ErrorReporter.internalError(v.getLocation(), "Cannot const partition function for " + this.func.getName());
            }
            if (this.numSets > 1) {
                ErrorReporter.internalError(v.getLocation(), "Inconsistent const requirements for " + this.func.getName());
            }
            this.func.makeConst();
        } else if (!v.isConst() && this.func.isConst()) {
            ErrorReporter.internalError(v.getLocation(), "Inconsistent const requirements for " + this.func.getName());
        }
    }

    public Integer getTagValue(Variable v) {
        return (Integer)this.vars.tag(v);
    }

    public String toString() {
        return String.valueOf(this.func.getName()) + "part " + this.elemType().toString();
    }

    public void copyForSchema(Variable pfunc, Schema sch) {
        PartitionType pt2 = new PartitionType(pfunc, this);
        VarEnumeration ve = this.vars.elements();
        while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            Variable v2 = sch.findVar(v.getName());
            if (v2 == null) {
                ErrorReporter.internalError(SourceLoc.noLoc, "missing a partition element in schema " + sch.getName());
            }
            pt2.vars.addVar(v2, new Integer(pt2.numSets));
            ++pt2.numSets;
            v2.assignType(pt2);
        }
    }

    public void prime(Variable pfunc) {
        PartitionType pt2 = new PartitionType(pfunc, this);
        VarEnumeration ve = this.vars.elements();
        while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            Variable v2 = v.prime();
            pt2.vars.addVar(v2, new Integer(pt2.numSets));
            ++pt2.numSets;
            v2.assignType(pt2);
        }
    }

    public boolean equiv(Type other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PartitionType)) {
            return false;
        }
        PartitionType pt2 = (PartitionType)other;
        if (this.numSets != pt2.numSets) {
            return false;
        }
        if (!this.func.getName().equals(pt2.func.getName())) {
            return false;
        }
        return this.partType.equiv(pt2.partType);
    }

    public boolean includes(Type other) {
        if (other instanceof SetType) {
            return this.elemType().includes(((SetType)other).elemType());
        }
        return other == this;
    }
}

