/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.Scope;
import ladybug.parse.Clause;
import ladybug.parse.Formula;
import ladybug.parse.FormulaList;
import ladybug.parse.KeywordOperator;
import ladybug.parse.Renaming;
import ladybug.parse.Schema;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.VariableList;

public class NormalizedFormula
extends Formula {
    private Vector clausez = new Vector();

    public NormalizedFormula() {
    }

    public NormalizedFormula(Clause c) {
        this();
        this.clausez.addElement(c);
    }

    public void addClause(Clause clause) {
        Enumeration e = this.clauses();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            if (!c.equiv(clause)) continue;
            return;
        }
        this.clausez.addElement(clause);
    }

    public void removeClause(Clause clause) {
        this.clausez.removeElement(clause);
    }

    public boolean isEmpty() {
        if (this.clausez.isEmpty()) {
            return true;
        }
        Enumeration e = this.clauses();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isSimple() {
        return this.clausez.size() == 1;
    }

    public int numClauses() {
        return this.clausez.size();
    }

    public Enumeration clauses() {
        return this.clausez.elements();
    }

    public NormalizedFormula sum(NormalizedFormula other) {
        Clause c;
        NormalizedFormula result = new NormalizedFormula();
        Enumeration e = this.clauses();
        while (e.hasMoreElements()) {
            c = (Clause)e.nextElement();
            if (c.isAlwaysFalse()) continue;
            result.addClause(c);
        }
        e = other.clauses();
        block1: while (e.hasMoreElements()) {
            c = (Clause)e.nextElement();
            if (c.isAlwaysFalse()) continue;
            Enumeration ec = result.clauses();
            while (ec.hasMoreElements()) {
                Clause c2 = (Clause)ec.nextElement();
                if (c.contains(c2)) continue block1;
                if (!c2.contains(c)) continue;
                result.removeClause(c2);
            }
            result.addClause(c.copy());
        }
        return result;
    }

    public NormalizedFormula product(NormalizedFormula other) {
        if (this.isEmpty()) {
            return (NormalizedFormula)other.copy();
        }
        if (other.isEmpty()) {
            return (NormalizedFormula)this.copy();
        }
        NormalizedFormula result = new NormalizedFormula();
        Enumeration e = this.clauses();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            if (c.isAlwaysFalse()) continue;
            Enumeration e2 = other.clauses();
            block1: while (e2.hasMoreElements()) {
                Clause c3;
                Clause c2 = (Clause)e2.nextElement();
                if (c2.isAlwaysFalse() || (c3 = c.sum(c2)).isAlwaysFalse()) continue;
                Enumeration ec = result.clauses();
                while (ec.hasMoreElements()) {
                    Clause c4 = (Clause)ec.nextElement();
                    if (c4.contains(c3)) continue block1;
                    if (!c3.contains(c4)) continue;
                    result.removeClause(c4);
                }
                result.addClause(c3);
            }
        }
        return result;
    }

    public int precedence() {
        return KeywordOperator.findOperator(10).precedence();
    }

    public VariableList vars(Schema s) {
        VariableList vl = new VariableList();
        Enumeration e = this.clauses();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            vl = vl.union(c.vars(s));
        }
        return vl;
    }

    public TermList terms(Schema s) {
        TermList tl = new TermList();
        Enumeration e = this.clauses();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            tl = tl.union(c.terms(s));
        }
        return tl;
    }

    public FormulaList facts(Schema s) {
        if (this.clausez.size() == 0) {
            return new FormulaList();
        }
        if (this.clausez.size() == 1) {
            return ((Clause)this.clausez.elementAt(0)).facts(s);
        }
        Enumeration e = this.clauses();
        Clause c = (Clause)e.nextElement();
        FormulaList fl = c.facts(s);
        while (e.hasMoreElements()) {
            c = (Clause)e.nextElement();
            fl = fl.intersect(c.facts(s));
        }
        return fl;
    }

    public NormalizedFormula normalize(boolean negated) {
        if (negated) {
            return (NormalizedFormula)this.negated();
        }
        return this;
    }

    public Formula instantiate(Schema s) {
        return this.copy();
    }

    public Formula negated() {
        return null;
    }

    public boolean isPrime() {
        Enumeration e = this.clauses();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            if (!c.isPrime()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimable() {
        Enumeration e = this.clausez.elements();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            if (!c.isPrimable()) continue;
            return true;
        }
        return false;
    }

    public boolean equiv(Tree other) {
        Clause c2;
        Enumeration e2;
        Clause c;
        Enumeration e = this.clauses();
        if (other.getClass() != this.getClass()) {
            return false;
        }
        NormalizedFormula othernf = (NormalizedFormula)other;
        block0: while (e.hasMoreElements()) {
            c = (Clause)e.nextElement();
            e2 = othernf.clauses();
            while (e2.hasMoreElements()) {
                c2 = (Clause)e2.nextElement();
                if (c.equiv(c2)) continue block0;
            }
            return false;
        }
        e = othernf.clauses();
        block2: while (e.hasMoreElements()) {
            c = (Clause)e.nextElement();
            e2 = this.clauses();
            while (e2.hasMoreElements()) {
                c2 = (Clause)e2.nextElement();
                if (c.equiv(c2)) continue block2;
            }
            return false;
        }
        return true;
    }

    public Formula rename(Renaming renames) {
        NormalizedFormula nf = new NormalizedFormula();
        Enumeration e = this.clauses();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            nf.addClause(c.rename(renames));
        }
        return nf;
    }

    public Formula prime() {
        NormalizedFormula nf = new NormalizedFormula();
        Enumeration e = this.clauses();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            nf.addClause(c.prime());
        }
        return nf;
    }

    public Formula copy() {
        NormalizedFormula nf = new NormalizedFormula();
        Enumeration e = this.clauses();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            nf.addClause(c.copy());
        }
        return nf;
    }

    public double probability(Scope scope) {
        double p = 1.0;
        Enumeration e = this.clauses();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            p *= 1.0 - c.probability(scope);
        }
        return 1.0 - p;
    }

    public String toString() {
        String s = "";
        boolean first = true;
        Enumeration e = this.clausez.elements();
        String opName = " or " + Tree.linesep();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            if (first) {
                s = c.toString();
                first = false;
                continue;
            }
            s = String.valueOf(s) + opName + c.toString();
        }
        return "(" + Tree.linesep() + " " + s + Tree.linesep() + ")" + Tree.linesep();
    }

    int equivHashCode(int hashSize) {
        return 0;
    }
}

