/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.FormulaList;
import ladybug.parse.Renaming;
import ladybug.parse.SourceObject;
import ladybug.parse.Term;
import ladybug.parse.TermList;
import ladybug.parse.VariableList;

public class Maplet
extends SourceObject {
    private Term _from;
    private Term _to;

    public Maplet(Term f, Term t) {
        super(f.getLocation().merge(t.getLocation()));
        this._from = f;
        this._to = t;
    }

    public Term from() {
        return this._from;
    }

    public Term to() {
        return this._to;
    }

    public String toString() {
        return String.valueOf(this.from().toString()) + "->" + this.to().toString();
    }

    public VariableList vars() {
        return this.from().vars().union(this.to().vars());
    }

    public TermList terms() {
        return this.from().terms().union(this.to().terms());
    }

    public FormulaList constraints() {
        return this._from.constraints().union(this._to.constraints());
    }

    public Maplet copy() {
        return new Maplet(this._from.copy(), this._to.copy());
    }

    public Maplet rename(Renaming r) {
        return new Maplet(this._from.rename(r), this._to.rename(r));
    }

    public boolean isPrimable() {
        return this.from().isPrimable() || this.to().isPrimable();
    }

    public boolean isPrime() {
        return this.from().isPrime() || this.to().isPrime();
    }

    public Maplet prime() {
        return new Maplet(this._from.prime(), this._to.prime());
    }

    public boolean equiv(Maplet other) {
        return this.from().equiv(other.from()) && this.to().equiv(other.to());
    }
}

