/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.engine.Scope;
import ladybug.parse.ScalarType;
import ladybug.parse.Type;

public final class IntType
extends ScalarType {
    private int max;
    private int min;
    private int intType;
    private static int numIntTypes = 0;
    private ScalarType maxScope;
    private IntType sameAs;

    public IntType(int minValue, int maxValue) {
        this.max = maxValue;
        this.min = minValue;
        this.maxScope = null;
        this.intType = numIntTypes++;
        this.sameAs = null;
    }

    public IntType(ScalarType maxgt) {
        this.maxScope = maxgt;
        this.max = Integer.MAX_VALUE;
        this.min = 0;
        this.intType = numIntTypes++;
        this.sameAs = null;
    }

    public IntType() {
        this.max = Integer.MAX_VALUE;
        this.min = Integer.MIN_VALUE;
        this.maxScope = null;
        this.intType = numIntTypes++;
        this.sameAs = null;
    }

    public boolean usesType(Type ty) {
        return ty instanceof IntType;
    }

    public boolean isIntType() {
        return true;
    }

    public int getTypeClass() {
        return 4;
    }

    public int minValue(Scope s) {
        return this.min;
    }

    public int maxValue(Scope s) {
        if (this.maxScope != null) {
            return (int)this.maxScope.numValues(s);
        }
        return this.max;
    }

    public long numValues(Scope s) {
        return this.maxValue(s) - this.minValue(s) + 1;
    }

    public void unify(ScalarType other) {
        IntType iother = (IntType)other;
        if (this.baseType() == iother.baseType()) {
            return;
        }
        iother.baseType().sameAs = this.baseType();
    }

    public String getElementName(int i) {
        return String.valueOf(i);
    }

    public String getName() {
        if (this.sameAs != null) {
            return this.sameAs.getName();
        }
        return "Int" + String.valueOf(this.intType);
    }

    public String toString() {
        if (this.maxScope != null) {
            return String.valueOf(this.getName()) + "=" + String.valueOf(this.min) + "..#" + this.maxScope.getName();
        }
        if (this.min == Integer.MIN_VALUE) {
            if (this.max == Integer.MAX_VALUE) {
                return this.getName();
            }
            return String.valueOf(this.getName()) + "=" + ".." + String.valueOf(this.max);
        }
        if (this.max == Integer.MAX_VALUE) {
            if (this.min == 0) {
                return String.valueOf(this.getName()) + "=" + "Nat";
            }
            return String.valueOf(this.getName()) + "=" + String.valueOf(this.min) + "..";
        }
        return String.valueOf(this.getName()) + "=" + String.valueOf(this.min) + ".." + String.valueOf(this.max);
    }

    public boolean equiv(Type other) {
        return other instanceof IntType;
    }

    public boolean includes(Type other) {
        if (!(other instanceof IntType)) {
            return false;
        }
        IntType iother = (IntType)other;
        return iother.max <= this.max && iother.min <= this.min;
    }

    public ScalarType common(ScalarType other) {
        if (other.isIntType()) {
            return this.baseType();
        }
        return null;
    }

    private IntType baseType() {
        if (this.sameAs == null) {
            return this;
        }
        return this.sameAs.baseType();
    }
}

