/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.engine.DerivedVars;
import ladybug.parse.ErrorReporter;
import ladybug.parse.FormulaList;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.ScalarType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

public final class IdTerm
extends Term {
    public IdTerm(Type t, SourceLoc loc) throws TypeConflict {
        super(loc, t == null ? new RelationType(null, null) : t);
        this.debug_init();
    }

    public int precedence() {
        return 0;
    }

    public VariableList vars() {
        return new VariableList();
    }

    public TermList terms() {
        return new TermList(this);
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        return false;
    }

    public FormulaList constraints() {
        return new FormulaList();
    }

    public Term copy() {
        try {
            return new IdTerm(this.type, this.location);
        }
        catch (TypeConflict tc) {
            ErrorReporter.internalError(this.location, tc);
            return null;
        }
    }

    public String toString() {
        if (this._str == null) {
            this._str = "Id";
        }
        return this._str;
    }

    public Term rename(Renaming r) {
        return this.copy();
    }

    public boolean isPrime() {
        return false;
    }

    public boolean isPrimable() {
        return false;
    }

    public Term prime() {
        return this.copy();
    }

    public void setType(Type newType) throws TypeConflict {
        super.setType(newType);
        RelationType rtype = (RelationType)newType;
        if (rtype.domain() == null) {
            if (rtype.range() != null) {
                this.setDomain(rtype.range());
            }
        } else if (rtype.range() == null) {
            this.setRange(rtype.domain());
        }
    }

    public void setDomain(ScalarType newType) throws TypeConflict {
        if (newType == null || newType.equiv(((RelationType)this.getType()).domain())) {
            return;
        }
        super.setDomain(newType);
        this.setRange(newType);
    }

    public void setRange(ScalarType newType) throws TypeConflict {
        if (newType == null || newType.equiv(((RelationType)this.getType()).range())) {
            return;
        }
        super.setRange(newType);
        this.setDomain(newType);
    }

    public boolean equiv(Tree other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        IdTerm id = (IdTerm)other;
        if (this.getType() == null) {
            return id.getType() == null;
        }
        if (id.getType() == null) {
            return false;
        }
        return this.getType().equiv(id.getType());
    }

    public TermIndex index() {
        return new TermIndex(this);
    }

    int equivHashCode(int hashSize) {
        return 2;
    }
}

