/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.Scope;
import ladybug.parse.ScalarType;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;

public final class GivenType
extends ScalarType {
    public static final int largestBound = 32;
    private String name;
    private String prefix;
    private Vector elements;
    private Vector supers;
    private boolean allowMore;

    public GivenType(String typeName) {
        this.name = typeName;
        this.allowMore = true;
        this.elements = new Vector();
        this.supers = new Vector();
    }

    public GivenType(String typeName, String[] names, boolean more) {
        this(typeName);
        this.setNames(names, more);
    }

    public GivenType(String typeName, Vector names, boolean more) {
        this(typeName);
        this.setNames(names, more);
    }

    public void setNames(String[] names, boolean more) {
        int num = names.length;
        this.allowMore = more;
        int i = 0;
        while (i < num) {
            this.elements.insertElementAt(names[i], i);
            ++i;
        }
    }

    public void setNames(Vector names, boolean more) {
        int num = names.size();
        this.allowMore = more;
        this.elements = (Vector)names.clone();
    }

    public void allowMore(boolean allowIt) {
        this.allowMore = allowIt;
    }

    public boolean usesType(Type ty) {
        if (this.equiv(ty)) {
            return true;
        }
        if (ty instanceof GivenType) {
            GivenType gty = (GivenType)ty;
            if (this.hasSuper(gty)) {
                return true;
            }
            if (gty.hasSuper(this)) {
                return true;
            }
        }
        return false;
    }

    public boolean isGivenType() {
        return true;
    }

    public int getTypeClass() {
        return 3;
    }

    public int minValue(Scope s) {
        return 0;
    }

    public int maxValue(Scope s) {
        return s.maxBound(this) - 1;
    }

    public void unify(ScalarType st) {
    }

    public long numValues(Scope s) {
        return s.maxBound(this);
    }

    public void addSuperType(GivenType parent) throws TypeConflict {
        if (parent.hasSuper(this)) {
            throw new TypeConflict(this, parent, "Cyclical inheritance of %2 by %1");
        }
        if (this.supers.contains(parent)) {
            throw new TypeConflict(this, parent, "Duplicate supertype %2 for %1");
        }
        this.supers.addElement(parent);
    }

    public Enumeration directSupers() {
        return this.supers.elements();
    }

    public boolean hasSuper(GivenType parent) {
        Enumeration e = this.directSupers();
        while (e.hasMoreElements()) {
            GivenType p = (GivenType)e.nextElement();
            if (p == parent) {
                return true;
            }
            if (!p.hasSuper(parent)) continue;
            return true;
        }
        return false;
    }

    public ScalarType common(ScalarType other) {
        GivenType p;
        if (other == this) {
            return this;
        }
        if (!(other instanceof GivenType)) {
            return null;
        }
        GivenType gother = (GivenType)other;
        if (this.hasSuper(gother)) {
            return gother;
        }
        if (gother.hasSuper(this)) {
            return this;
        }
        Enumeration e = this.directSupers();
        while (e.hasMoreElements()) {
            p = (GivenType)e.nextElement();
            if (!gother.hasSuper(p)) continue;
            return p;
        }
        e = gother.directSupers();
        while (e.hasMoreElements()) {
            p = (GivenType)e.nextElement();
            if (!this.hasSuper(p)) continue;
            return p;
        }
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String p) {
        this.prefix = p;
    }

    public int minScope() {
        if (this.elements.size() == 0) {
            return 1;
        }
        return this.elements.size();
    }

    public int maxScope() {
        if (this.allowMore) {
            return 32;
        }
        return this.elements.size();
    }

    public boolean allowsLargerScope() {
        return this.allowMore;
    }

    public boolean isElementNamed(int i) {
        if (i < 0 || i >= this.elements.size()) {
            return false;
        }
        return this.elements.elementAt(i) != null;
    }

    public String getElementName(int i) {
        if (i < 0) {
            return null;
        }
        if (i >= this.elements.size()) {
            if (!this.allowMore) {
                return null;
            }
            return String.valueOf(this.prefix) + String.valueOf(i);
        }
        if (this.elements.elementAt(i) == null) {
            return String.valueOf(this.prefix) + String.valueOf(i);
        }
        return (String)this.elements.elementAt(i);
    }

    public String setElementName(int i, String name) {
        if (i < 0) {
            return null;
        }
        if (i >= this.elements.size()) {
            int j = this.elements.size();
            while (j <= i) {
                this.elements.insertElementAt(null, j);
                ++j;
            }
        }
        this.elements.setElementAt(name, i);
        return name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equiv(Type other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof GivenType)) {
            return false;
        }
        GivenType gother = (GivenType)other;
        if (!gother.getName().equals(this.getName())) {
            return false;
        }
        if (this.supers.size() != gother.supers.size()) {
            return false;
        }
        Enumeration e = this.supers.elements();
        Enumeration eother = gother.supers.elements();
        while (e.hasMoreElements()) {
            if (((Type)e.nextElement()).equiv((Type)eother.nextElement())) continue;
            return false;
        }
        if (this.allowsLargerScope() != gother.allowsLargerScope()) {
            return false;
        }
        if (this.elements.size() != gother.elements.size()) {
            return false;
        }
        e = this.elements.elements();
        eother = gother.elements.elements();
        while (e.hasMoreElements()) {
            if (((String)e.nextElement()).equals((String)eother.nextElement())) continue;
            return false;
        }
        return true;
    }

    public boolean includes(Type other) {
        if (other == null) {
            return false;
        }
        if (this.equiv(other)) {
            return true;
        }
        if (!(other instanceof GivenType)) {
            return false;
        }
        GivenType gother = (GivenType)other;
        return gother.hasSuper(this);
    }
}

