/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.Formula;
import ladybug.parse.FormulaList;

public final class FormulaSet {
    private int hsize;
    private FormulaList[] table;
    private static final int defaultSize = 32;

    public FormulaSet(int hashSize) {
        this.hsize = hashSize;
        this.table = new FormulaList[this.hsize];
    }

    public FormulaSet() {
        this.hsize = 32;
        this.table = new FormulaList[this.hsize];
    }

    public FormulaSet copy() {
        FormulaSet fset = new FormulaSet(this.hsize);
        int i = 0;
        i = 0;
        while (i < this.hsize) {
            if (this.table[i] != null) {
                fset.table[i] = this.table[i].copy();
            }
            ++i;
        }
        return fset;
    }

    public void addFormula(Formula f) {
        int h = f.equivHashCode(this.hsize) % this.hsize;
        if (this.table[h] == null) {
            this.table[h] = new FormulaList(f);
        } else {
            if (this.table[h].containsEquiv(f)) {
                return;
            }
            this.table[h].addFormula(f);
        }
    }

    public void addFormula(Formula f, Object tag) {
        int h = f.equivHashCode(this.hsize) % this.hsize;
        if (this.table[h] == null) {
            this.table[h] = new FormulaList(f, tag);
        } else {
            if (this.table[h].containsEquiv(f)) {
                return;
            }
            this.table[h].addFormula(f, tag);
        }
    }

    public boolean contains(Formula f) {
        int h = f.equivHashCode(this.hsize) % this.hsize;
        if (this.table[h] == null) {
            return false;
        }
        return this.table[h].containsEquiv(f);
    }

    public Object tag(Formula f) {
        int h = f.equivHashCode(this.hsize) % this.hsize;
        if (this.table[h] == null) {
            return null;
        }
        return this.table[h].equivTag(f);
    }
}

