/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Enumeration;
import java.util.Vector;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;
import ladybug.parse.SimpleFormulaEnum;

public final class FormulaList {
    private Formula[] _formulae;
    private Vector _tags;
    private int _numForms;
    private int _allocForms;
    private static final int initAllocSize = 32;
    private static final int maxAllocIncr = 64;

    public FormulaList() {
        this._formulae = new Formula[32];
        this._numForms = 0;
        this._allocForms = 32;
        this._tags = new Vector();
    }

    public FormulaList(Formula f) {
        this();
        this.addFormula(f);
    }

    public FormulaList(Formula f, Object tag) {
        this();
        this.addFormula(f, tag);
    }

    public FormulaList(Vector forms) {
        this._formulae = new Formula[forms.size()];
        this._numForms = forms.size();
        this._allocForms = forms.size();
        this._tags = new Vector();
        int i = 0;
        while (i < forms.size()) {
            this._tags.insertElementAt(null, i);
            this._formulae[i] = (Formula)forms.elementAt(i);
            ++i;
        }
    }

    public FormulaList(Formula[] forms, int numForms) {
        this._formulae = new Formula[forms.length];
        this._numForms = numForms;
        this._allocForms = numForms;
        this._tags = new Vector();
        int i = 0;
        while (i < numForms) {
            this._tags.insertElementAt(null, i);
            this._formulae[i] = forms[i];
            ++i;
        }
    }

    public FormulaList(Formula[] forms) {
        this(forms, forms.length);
    }

    public int size() {
        return this._numForms;
    }

    public FormulaList copy() {
        FormulaList fl = new FormulaList();
        fl._formulae = new Formula[this._allocForms];
        fl._allocForms = this._allocForms;
        int i = 0;
        while (i < this._numForms) {
            fl._formulae[i] = this._formulae[i];
            ++i;
        }
        fl._numForms = this._numForms;
        fl._tags = (Vector)this._tags.clone();
        return fl;
    }

    public FormulaList union(FormulaList other) {
        FormulaList fl = this.copy();
        FormulaEnumeration e = other.elements();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            if (this.containsEquiv(f)) continue;
            fl.addFormula(f, other.equivTag(f));
        }
        return fl;
    }

    public FormulaList intersect(FormulaList other) {
        FormulaList fl = new FormulaList();
        FormulaEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            if (!other.containsEquiv(f)) continue;
            fl.addFormula(f, this.equivTag(f));
        }
        return fl;
    }

    public FormulaEnumeration elements() {
        return new SimpleFormulaEnum(this._formulae, this._numForms);
    }

    public Enumeration tags() {
        return this._tags.elements();
    }

    public boolean contains(Formula f) {
        FormulaEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Formula elem = e.nextFormula();
            if (elem != f) continue;
            return true;
        }
        return false;
    }

    public boolean containsEquiv(Formula f) {
        FormulaEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Formula elem = e.nextFormula();
            if (!elem.equiv(f)) continue;
            return true;
        }
        return false;
    }

    public Object tag(Formula f) {
        int i = 0;
        while (i < this._numForms) {
            Formula elem = this._formulae[i];
            if (elem == f) {
                return this._tags.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public Object equivTag(Formula f) {
        int i = 0;
        while (i < this._numForms) {
            Formula elem = this._formulae[i];
            if (elem.equiv(f)) {
                return this._tags.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public void addFormula(Formula f) {
        this.append(f, null);
    }

    public void addFormula(Formula f, Object tag) {
        this.append(f, tag);
    }

    public void append(Formula f) {
        this.append(f, null);
    }

    public void append(Formula f, Object tag) {
        if (this._numForms >= this._allocForms) {
            Formula[] old = this._formulae;
            this._allocForms = this._allocForms > 64 ? (this._allocForms += 64) : (this._allocForms += this._allocForms);
            this._formulae = new Formula[this._allocForms];
            int i = 0;
            while (i < this._numForms) {
                this._formulae[i] = old[i];
                ++i;
            }
        }
        this._tags.insertElementAt(tag, this._numForms);
        this._formulae[this._numForms] = f;
        ++this._numForms;
    }

    public void removeFormula(Formula f) {
        int i = this._numForms - 1;
        while (i >= 0) {
            if (f == this._formulae[i]) {
                this._tags.removeElementAt(i);
                while (i < this._numForms) {
                    this._formulae[i] = this._formulae[i + 1];
                    ++i;
                }
                --this._numForms;
                return;
            }
            --i;
        }
    }

    public void removeEquiv(Formula f) {
        int i = this._numForms - 1;
        while (i >= 0) {
            if (f.equiv(this._formulae[i])) {
                this._tags.removeElementAt(i);
                while (i < this._numForms) {
                    this._formulae[i] = this._formulae[i + 1];
                    ++i;
                }
                --this._numForms;
                return;
            }
            --i;
        }
    }

    public void removeLast() {
        if (this._numForms == 0) {
            return;
        }
        --this._numForms;
        this._tags.removeElementAt(this._numForms);
    }
}

