/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Vector;
import ladybug.parse.TermIndex;
import ladybug.parse.parser;

public final class FormulaIndex {
    private int root;
    private TermIndex left;
    private TermIndex right;
    private static final int key1Mult = TermIndex.maxKey;
    private static final int key2Mult = TermIndex.maxKey * TermIndex.maxKey;

    public FormulaIndex() {
        this.left = null;
        this.right = null;
        this.root = 0;
    }

    public FormulaIndex(boolean negated, int symvalue, int typeClass) {
        this.left = null;
        this.right = null;
        this.root = this.computeRoot(negated, symvalue, typeClass);
    }

    public FormulaIndex(boolean negated, int symvalue, int typeClass, TermIndex child) {
        this.left = child;
        this.right = null;
        this.root = this.computeRoot(negated, symvalue, typeClass);
    }

    public FormulaIndex(boolean negated, int symvalue, int typeClass, TermIndex l, TermIndex r) {
        if (l == null) {
            this.left = r;
            this.right = null;
        } else {
            this.left = l;
            this.right = r;
        }
        this.root = this.computeRoot(negated, symvalue, typeClass);
    }

    public Object primaryKey() {
        int key = this.root;
        if (this.left != null) {
            key += this.left.key() * key1Mult;
            if (this.right != null) {
                key += this.right.key() * key2Mult;
            }
        } else if (this.right != null) {
            key += this.right.key() * key1Mult;
        }
        return new Integer(key);
    }

    public Vector possibleKeys() {
        Vector<Integer> v = new Vector<Integer>();
        v.addElement(new Integer(this.root));
        if (this.left != null) {
            v.addElement(new Integer(this.root + this.left.key() * key1Mult));
            if (this.right != null) {
                v.addElement(new Integer(this.root + this.left.key() * key1Mult + this.right.key() * key2Mult));
            }
        }
        if (this.right != null) {
            v.addElement(new Integer(this.root + this.right.key() * key1Mult));
        }
        return v;
    }

    private int computeRoot(boolean negated, int symvalue, int typeClass) {
        int r = symvalue * 5 + typeClass;
        if (negated) {
            r += parser.highestSymbol * 5;
        }
        return r;
    }
}

