/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.BadPeerClass;
import ladybug.engine.FormulaPeer;
import ladybug.engine.Scope;
import ladybug.parse.FormulaIndex;
import ladybug.parse.FormulaList;
import ladybug.parse.NormalizedFormula;
import ladybug.parse.Renaming;
import ladybug.parse.Schema;
import ladybug.parse.SourceLoc;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.VariableList;

public abstract class Formula
extends Tree {
    public Formula(SourceLoc loc) {
        super(loc);
    }

    public Formula() {
        super(SourceLoc.noLoc);
    }

    public FormulaPeer createPeer(Hashtable peerTypes) throws BadPeerClass {
        Class<?> thisClass = this.getClass();
        if (!peerTypes.containsKey(thisClass)) {
            throw new BadPeerClass(thisClass, "missing class");
        }
        Class cl = (Class)peerTypes.get(thisClass);
        FormulaPeer.peerSource = this;
        FormulaPeer.peerTypes = peerTypes;
        try {
            return (FormulaPeer)cl.newInstance();
        }
        catch (InstantiationException ie) {
            throw new BadPeerClass(thisClass, "newInstance failed - " + ie.toString());
        }
        catch (IllegalAccessException iae) {
            throw new BadPeerClass(thisClass, "newInstance failed - " + iae.toString());
        }
    }

    public abstract Formula copy();

    public abstract Formula rename(Renaming var1);

    public abstract Formula prime();

    public abstract NormalizedFormula normalize(boolean var1);

    public Formula formula() {
        return this;
    }

    public abstract Formula negated();

    public abstract Formula instantiate(Schema var1);

    public abstract VariableList vars(Schema var1);

    public abstract TermList terms(Schema var1);

    public abstract FormulaList facts(Schema var1);

    public abstract double probability(Scope var1);

    public FormulaIndex index() {
        return new FormulaIndex();
    }
}

