/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.io.IOException;
import ladybug.engine.LadyBug;
import ladybug.parse.ParseError;
import ladybug.parse.SourceLoc;
import ladybug.parse.Tree;
import ladybug.util.Console;

public class ErrorReporter {
    public static void internalError(SourceLoc loc, String msg) {
        ErrorReporter.reportPos(loc);
        LadyBug.parserError(String.valueOf(loc.startPos()) + ": " + msg);
        System.exit(99);
    }

    public static void internalError(SourceLoc loc, ParseError pe) {
        ErrorReporter.reportPos(loc);
        LadyBug.parserError(String.valueOf(loc.startPos()) + ": " + pe.toString());
        pe.printStackTrace(System.err);
        System.exit(99);
    }

    public static void error(SourceLoc loc, String msg) {
        ErrorReporter.reportPos(loc);
        LadyBug.parserError(String.valueOf(loc.startPos()) + ": " + msg);
    }

    public static void error(SourceLoc loc, ParseError pe) {
        ErrorReporter.reportPos(loc);
        LadyBug.parserError(String.valueOf(loc.startPos()) + ": " + pe.toString());
    }

    public static void warning(SourceLoc loc, String msg) {
        ErrorReporter.reportPos(loc);
        LadyBug.parserWarning(String.valueOf(loc.startPos()) + ": " + msg);
    }

    private static void reportPos(SourceLoc loc) {
        if (loc == SourceLoc.noLoc) {
            return;
        }
        String leadStr = "";
        String lns = null;
        Console c = LadyBug.getConsole();
        try {
            lns = loc.lines();
            if (lns == null) {
                return;
            }
            LadyBug.message(lns);
        }
        catch (IOException iOException) {
            return;
        }
        if (loc.start_char > 1) {
            leadStr = c.fillerString(" ", c.stringLength(lns.substring(0, loc.start_char - 2)));
        }
        leadStr = String.valueOf(leadStr) + "^";
        if (loc.start_line == loc.end_line) {
            if (loc.start_char < loc.end_char) {
                leadStr = String.valueOf(leadStr) + c.fillerString(".", c.stringLength(lns.substring(loc.start_char - 1, loc.end_char)) - c.stringLength("^^"));
                leadStr = String.valueOf(leadStr) + "^";
            }
            LadyBug.message(leadStr);
        } else {
            int endFirst = lns.indexOf(Tree.linesep());
            if (endFirst < 0) {
                return;
            }
            String firstLine = lns.substring(0, endFirst);
            leadStr = String.valueOf(leadStr) + c.fillerString(".", c.stringLength(firstLine.substring(loc.start_char - 1)) - c.stringLength("^"));
            LadyBug.message(leadStr);
            if (loc.end_char > 1) {
                int startLast = lns.lastIndexOf(Tree.linesep());
                String lastLine = lns.substring(startLast + 1);
                leadStr = c.fillerString(".", c.stringLength(lastLine.substring(0, loc.end_char - 1)) - c.stringLength("^"));
            }
            LadyBug.message(String.valueOf(leadStr) + "^");
        }
    }
}

