/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.engine.DerivedVars;
import ladybug.parse.FormulaList;
import ladybug.parse.Renaming;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

public final class EmptyTerm
extends Term {
    public EmptyTerm(Type t, SourceLoc loc) {
        super(loc, t);
        this.debug_init();
    }

    public Term copy() {
        return new EmptyTerm(this.type, this.location);
    }

    public void setType(Type newType) throws TypeConflict {
        if (!newType.isRelation() && !newType.isSet()) {
            throw new TypeConflict(newType, null, "Setting the type of an empty term to a non-set or relation type %1");
        }
        super.setType(newType);
    }

    public int precedence() {
        return 0;
    }

    public VariableList vars() {
        return new VariableList();
    }

    public TermList terms() {
        return new TermList(this);
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        return false;
    }

    public FormulaList constraints() {
        return new FormulaList();
    }

    public String toString() {
        if (this._str == null) {
            this._str = "{}";
        }
        return this._str;
    }

    public Term rename(Renaming r) {
        return this.copy();
    }

    public boolean isPrime() {
        return false;
    }

    public boolean isPrimable() {
        return false;
    }

    public Term prime() {
        return this.copy();
    }

    public boolean equiv(Tree other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        EmptyTerm ut = (EmptyTerm)other;
        if (this.getType() == null) {
            return ut.getType() == null;
        }
        if (ut.getType() == null) {
            return false;
        }
        return this.getType().equiv(ut.getType());
    }

    public TermIndex index() {
        return new TermIndex(this);
    }

    int equivHashCode(int hashSize) {
        return 2;
    }
}

