/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.engine.Scope;
import ladybug.parse.AtomicFormula;
import ladybug.parse.BinaryOperator;
import ladybug.parse.ErrorReporter;
import ladybug.parse.Formula;
import ladybug.parse.FormulaIndex;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.ScalarType;
import ladybug.parse.Schema;
import ladybug.parse.SetType;
import ladybug.parse.Term;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.VariableList;

public final class Comparison
extends AtomicFormula {
    public Term left;
    public Term right;
    public BinaryOperator op;
    private VariableList cachedVars;

    public Comparison(Term l, Term r, BinaryOperator o) {
        this(l, r, o, true);
    }

    public Comparison(Term l, Term r, BinaryOperator o, boolean checkType) {
        super(l.location.merge(r.location));
        this.left = l;
        this.right = r;
        this.op = o;
        this.cachedVars = null;
        this.checkTypes(checkType);
        this.debug_init();
    }

    public int precedence() {
        return this.op.precedence();
    }

    public VariableList vars(Schema s) {
        if (this.cachedVars == null) {
            this.cachedVars = this.left.vars().union(this.right.vars());
        }
        return this.cachedVars;
    }

    public TermList terms(Schema s) {
        return this.left.terms().union(this.right.terms());
    }

    public FormulaIndex index() {
        return new FormulaIndex(this.isNegated(), this.op.symbol, this.left.getType().getTypeClass(), this.left.index(), this.right.index());
    }

    public String toString() {
        if (this._str == null) {
            this._str = String.valueOf(this.isNegated() ? "not " : "") + this.left.toString() + " " + this.op.toString() + " " + this.right.toString();
        }
        return this._str;
    }

    public Formula rename(Renaming r) {
        Comparison result = new Comparison(this.left.rename(r), this.right.rename(r), this.op);
        if (this.isNegated()) {
            result.negate();
        }
        return result;
    }

    public boolean isPrime() {
        return this.left.isPrime() || this.right.isPrime();
    }

    public boolean isPrimable() {
        return this.left.isPrimable() || this.right.isPrimable();
    }

    public Formula prime() {
        if (!this.isPrimable()) {
            return this.copy();
        }
        Comparison result = new Comparison(this.left.prime(), this.right.prime(), this.op);
        if (this.isNegated()) {
            result.negate();
        }
        return result;
    }

    public Formula copy() {
        Comparison result = new Comparison(this.left.copy(), this.right.copy(), this.op);
        result.location = this.location;
        if (this.isNegated()) {
            result.negate();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equiv(Tree other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Comparison otherAF = (Comparison)other;
        if (otherAF.isNegated() != this.isNegated()) {
            return false;
        }
        if (otherAF.op != this.op) {
            return false;
        }
        if (this.op.isCommutative()) {
            if (this.left.equiv(otherAF.left)) {
                if (this.right.equiv(otherAF.right)) return true;
                return false;
            }
            if (!this.left.equiv(otherAF.right)) return false;
            if (this.right.equiv(otherAF.left)) return true;
            return false;
        }
        if (!this.left.equiv(otherAF.left)) {
            return false;
        }
        if (this.right.equiv(otherAF.right)) return true;
        return false;
    }

    public double probability(Scope scope) {
        switch (this.op.symbol) {
            case 23: {
                return 0.5;
            }
            case 24: {
                double nv = new Long(this.left.getType().numValues(scope)).doubleValue();
                return 1.0 / nv;
            }
            case 21: {
                double p;
                if (this.left.getType().isSet()) {
                    int max = (int)((SetType)this.left.getType()).elemType().numValues(scope);
                    p = 1.0;
                    int i = 0;
                    while (i < max) {
                        p *= 0.5;
                        ++i;
                    }
                } else {
                    RelationType lrt = (RelationType)this.left.getType();
                    RelationType rrt = (RelationType)this.right.getType();
                    int avgEdges = lrt.avgEdges(scope);
                    p = 1.0;
                    int i = 0;
                    while (i < avgEdges) {
                        p *= 0.5;
                        ++i;
                    }
                }
                double nv = new Long(this.left.getType().numValues(scope)).doubleValue();
                return p -= 1.0 / nv;
            }
            case 20: 
            case 22: {
                if (this.left.getType().isSet()) {
                    int max = (int)((SetType)this.left.getType()).elemType().numValues(scope);
                    double p = 1.0;
                    int i = 0;
                    while (i < max) {
                        p *= 0.5;
                        ++i;
                    }
                    return p;
                }
                RelationType lrt = (RelationType)this.left.getType();
                RelationType rrt = (RelationType)this.right.getType();
                int avgEdges = lrt.avgEdges(scope);
                double p = 1.0;
                int i = 0;
                while (i < avgEdges) {
                    p *= 0.5;
                    ++i;
                }
                return p;
            }
            case 67: 
            case 68: {
                return 0.5;
            }
            case 66: {
                double nv = new Long(this.left.getType().numValues(scope)).doubleValue();
                return (nv - 1.0) / (nv * 2.0);
            }
        }
        return 0.5;
    }

    int equivHashCode(int hashSize) {
        if (this.eqHashCode < 0) {
            this.eqHashCode = (this.left.equivHashCode(hashSize) * this.right.equivHashCode(hashSize) + this.op.symbol) % hashSize;
        }
        return this.eqHashCode;
    }

    private void checkTypes(boolean forceCheck) {
        Type ltype = this.left.getType();
        Type rtype = this.right.getType();
        if (!forceCheck && ltype != null && ltype.isComplete() && rtype != null && rtype.isComplete()) {
            return;
        }
        RelationType lrt = null;
        RelationType rrt = null;
        SetType lst = null;
        SetType rst = null;
        ScalarType lgt = null;
        ScalarType rgt = null;
        try {
            if (ltype != null) {
                if (ltype.isRelation()) {
                    lrt = (RelationType)ltype;
                } else if (ltype.isSet()) {
                    lst = (SetType)ltype;
                } else {
                    lgt = (ScalarType)ltype;
                }
            }
            if (rtype != null) {
                if (rtype.isRelation()) {
                    rrt = (RelationType)rtype;
                } else if (rtype.isSet()) {
                    rst = (SetType)rtype;
                } else {
                    rgt = (ScalarType)rtype;
                }
            }
            switch (this.op.symbol) {
                case 20: 
                case 21: 
                case 22: 
                case 24: {
                    if (ltype == null) {
                        if (rtype != null) {
                            if (rrt != null) {
                                this.left.setType(new RelationType(null, null));
                                if (rrt.domain() != null) {
                                    this.left.setDomain(rrt.domain());
                                }
                                if (rrt.range() != null) {
                                    this.left.setRange(rrt.range());
                                }
                            } else if (rst != null) {
                                this.left.setType(new SetType(null));
                                if (rst.elemType() != null) {
                                    this.left.setElemType(rst.elemType());
                                }
                            } else if (this.op.symbol == 24 && rgt != null) {
                                this.left.setType(rgt);
                            } else {
                                ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + "is not a set or a relation");
                            }
                        }
                    } else if (rtype == null) {
                        if (lrt != null) {
                            this.right.setType(new RelationType(null, null));
                            if (lrt.domain() != null) {
                                this.right.setDomain(lrt.domain());
                            }
                            if (lrt.range() != null) {
                                this.right.setRange(lrt.range());
                            }
                        } else if (lst != null) {
                            this.right.setType(new SetType(null));
                            if (lst.elemType() != null) {
                                this.right.setElemType(lst.elemType());
                            }
                        } else if (this.op.symbol == 24 && lgt != null) {
                            this.right.setType(lgt);
                        } else {
                            ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + "is not a set or a relation");
                        }
                    } else if (lrt != null) {
                        if (rrt == null) {
                            ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + " is a relation, but not the rhs");
                        } else {
                            if (lrt.domain() == null) {
                                if (rrt.domain() != null) {
                                    this.left.setDomain(rrt.domain());
                                }
                            } else if (rrt.domain() == null) {
                                this.right.setDomain(lrt.domain());
                            } else if (!rrt.domain().includes(lrt.domain())) {
                                ErrorReporter.error(this.getLocation(), "domains of lhs and rhs of " + this.op.toString() + " disagree");
                            }
                            if (lrt.range() == null) {
                                if (rrt.range() != null) {
                                    this.left.setRange(rrt.range());
                                }
                            } else if (rrt.range() == null) {
                                this.right.setRange(lrt.range());
                            } else if (!rrt.range().includes(lrt.range())) {
                                ErrorReporter.error(this.getLocation(), "ranges of lhs and rhs of " + this.op.toString() + " disagree");
                            }
                        }
                    } else if (lst != null) {
                        if (rst == null) {
                            ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + " is a set, but not the rhs");
                        } else if (lst.elemType() == null) {
                            if (rst.elemType() != null) {
                                this.left.setElemType(rst.elemType());
                            }
                        } else if (rst.elemType() == null) {
                            this.right.setElemType(lst.elemType());
                        } else if (!rst.elemType().includes(lst.elemType())) {
                            ErrorReporter.error(this.getLocation(), "element types of lhs and rhs of " + this.op.toString() + " disagree");
                        }
                    } else if (rgt == null) {
                        ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + " is a scalar, but not the rhs");
                    } else {
                        if (this.op.symbol != 24) {
                            if (this.op.symbol == 20) {
                                this.op.symbol = 67;
                            } else if (this.op.symbol == 21) {
                                this.op.symbol = 66;
                            } else if (this.op.symbol == 22) {
                                this.op.symbol = 68;
                            }
                            if (!rgt.isIntType()) {
                                ErrorReporter.error(this.getLocation(), String.valueOf(this.op.toString()) + " comparison of non-integer");
                            }
                        }
                        if (!rgt.includes(lgt) && !lgt.includes(rgt)) {
                            ErrorReporter.error(this.getLocation(), "types of lhs and rhs of " + this.op.toString() + " disagree");
                        } else {
                            lgt.unify(rgt);
                        }
                    }
                    break;
                }
                case 23: {
                    if (ltype == null) {
                        if (rtype != null & rst == null) {
                            ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + " is not a set");
                        }
                    } else if (rtype == null) {
                        if (lgt == null) {
                            ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + " is not a scalar");
                        }
                    } else if (lgt == null) {
                        ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + " is not a scalar");
                    } else if (rst == null) {
                        ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + " is not a set");
                    } else if (rst.elemType() == null) {
                        rst.setElemType(lgt);
                    } else if (!rst.elemType().includes(lgt) && !lgt.includes(rst.elemType())) {
                        ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + " is not typed as an element of the lhs");
                    } else {
                        rst.elemType().unify(lgt);
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (TypeConflict tc) {
            ErrorReporter.error(this.getLocation(), tc);
        }
    }
}

